/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.app.activity;

import android.app.Activity;
import android.databinding.DataBindingUtil;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import com.komect.network.R;
import com.komect.network.app.activity.BasicActivity;
import com.komect.network.bean.NetworkDevice;
import com.komect.network.bean.TestPoint;
import com.komect.network.bean.WiFiCoverage;
import com.komect.network.database.DbManager;
import com.komect.network.database.OrderEntity;
import com.komect.network.databinding.ActivityNwReportBinding;
import com.komect.network.databinding.ReportConfig;
import com.zhy.autolayout.utils.AutoUtils;
import java.util.List;

public class ReportActivity
extends BasicActivity {
    ActivityNwReportBinding binding;
    DbManager dbManager;
    private OrderEntity entity;

    protected void onCreate(@Nullable Bundle bundle) {
        super.onCreate(bundle);
        this.binding = (ActivityNwReportBinding)DataBindingUtil.setContentView((Activity)this, (int)R.layout.activity_nw_report);
        this.bindTopBar(this.binding.topBar);
        AutoUtils.autoSize((View)this.binding.getRoot());
        this.dbManager = DbManager.getManager();
        this.binding.layoutUserInfo.lyUserInfo.setVisibility(0);
        if (this.getIntent().hasExtra("bundle")) {
            Bundle bundle2 = this.getIntent().getBundleExtra("bundle");
            this.entity = (OrderEntity)bundle2.getSerializable("order_entity");
            this.binding.setProfile(this.entity);
            this.dbManager.setOrderId(this.entity.getId());
        }
        this.showPreTestReport();
        this.showProjectDesign();
        this.showPostReport();
        this.showBuildingInfo();
    }

    private void showBuildingInfo() {
        if (TextUtils.isEmpty((CharSequence)this.entity.getPlanCity())) {
            this.binding.layoutBuildingInfo.lyBuildingInfo.setVisibility(8);
        } else {
            this.binding.layoutBuildingInfo.lyBuildingInfo.setVisibility(0);
        }
    }

    private void showPreTestReport() {
        List<NetworkDevice> list = this.dbManager.getDeviceList(1);
        List<TestPoint> list2 = this.dbManager.getTestPoint(1);
        if (list.size() > 0 || list2.size() > 0) {
            ReportConfig reportConfig;
            if (TextUtils.isEmpty((CharSequence)this.entity.getPlanCity())) {
                reportConfig = new ReportConfig().setTitle(this.getString(R.string.preinstall_test_report)).setMapTitle(this.getString(R.string.nw_wifi_coverage_heatmap)).setTestPoints(list2).setHasFamily(false);
            } else {
                reportConfig = new ReportConfig().setTitle(this.getString(R.string.preinstall_test_report)).setMapTitle(this.getString(R.string.nw_wifi_coverage_heatmap)).setDevices(list).setTestPoints(list2).setHasFamily(true);
                WiFiCoverage wiFiCoverage = this.dbManager.getCoverage(1);
                if (wiFiCoverage != null) {
                    reportConfig = reportConfig.setCoverage(wiFiCoverage.getReliableRate()).setMapImg(wiFiCoverage.getWifiMap());
                }
            }
            this.binding.lyPretestReport.setConfig(reportConfig);
            this.binding.lyPretestReport.setVisibility(0);
        } else {
            this.binding.lyPretestReport.setVisibility(8);
        }
    }

    private void showProjectDesign() {
        List<NetworkDevice> list = this.dbManager.getDeviceList(2);
        if (list.size() > 0) {
            ReportConfig reportConfig;
            if (TextUtils.isEmpty((CharSequence)this.entity.getPlanCity())) {
                reportConfig = new ReportConfig().setTitle(this.getString(R.string.intelligent_networking_scheme)).setMapTitle(this.getString(R.string.nw_network_design)).setDevices(list).setHasFamily(false);
            } else {
                reportConfig = new ReportConfig().setTitle(this.getString(R.string.intelligent_networking_scheme)).setMapTitle(this.getString(R.string.nw_network_design)).setDevices(list).setHasFamily(true);
                WiFiCoverage wiFiCoverage = this.dbManager.getCoverage(2);
                if (wiFiCoverage != null) {
                    reportConfig = reportConfig.setMapImg(wiFiCoverage.getHouseImg());
                }
            }
            this.binding.lyDesignReport.setConfig(reportConfig);
            this.binding.lyDesignReport.setVisibility(0);
        } else {
            this.binding.lyDesignReport.setVisibility(8);
        }
    }

    private void showPostReport() {
        List<NetworkDevice> list = this.dbManager.getDeviceList(2);
        List<TestPoint> list2 = this.dbManager.getTestPoint(3);
        if (list2.size() > 0) {
            ReportConfig reportConfig;
            if (TextUtils.isEmpty((CharSequence)this.entity.getPlanCity())) {
                reportConfig = new ReportConfig().setTitle(this.getString(R.string.post_install_test_plan)).setMapTitle(this.getString(R.string.nw_wifi_coverage_heatmap)).setTestPoints(list2).setDevices(list).setNoShowDeviceTable(true).setHasFamily(false);
            } else {
                reportConfig = new ReportConfig().setTitle(this.getString(R.string.post_install_test_plan)).setMapTitle(this.getString(R.string.nw_wifi_coverage_heatmap)).setTestPoints(list2).setDevices(list).setNoShowDeviceTable(true).setHasFamily(true);
                WiFiCoverage wiFiCoverage = this.dbManager.getCoverage(3);
                if (wiFiCoverage != null) {
                    reportConfig = reportConfig.setCoverage(wiFiCoverage.getReliableRate()).setMapImg(wiFiCoverage.getWifiMap());
                }
            }
            this.binding.lyPostReport.setConfig(reportConfig);
            this.binding.lyPostReport.setVisibility(0);
        } else {
            this.binding.lyPostReport.setVisibility(8);
        }
    }
}

