/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.app.activity;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.databinding.DataBindingUtil;
import android.os.Bundle;
import android.view.View;
import android.widget.ListAdapter;
import android.widget.Toast;
import com.komect.network.R;
import com.komect.network.a.a;
import com.komect.network.app.a.f;
import com.komect.network.app.a.i;
import com.komect.network.app.activity.BasicActivity;
import com.komect.network.app.activity.ChooseFamilyActivity;
import com.komect.network.app.activity.DeviceAddActivity;
import com.komect.network.app.activity.NetworkTestActivity;
import com.komect.network.app.activity.PostInstallActivity;
import com.komect.network.app.activity.ProjectDesignActivity;
import com.komect.network.app.activity.TrstAddActivity;
import com.komect.network.app.widget.Marker;
import com.komect.network.app.widget.StepView;
import com.komect.network.bean.NetworkDevice;
import com.komect.network.bean.StepEntity;
import com.komect.network.bean.TestPoint;
import com.komect.network.bean.WiFiCoverage;
import com.komect.network.database.DbManager;
import com.komect.network.database.OrderEntity;
import com.komect.network.databinding.ActivityPreinstallTestBinding;
import com.komect.network.databinding.ReportConfig;
import com.komect.network.databinding.WifiCoverPresenter;
import com.komect.network.komectinnet.bean.request.FloorPlanImg;
import com.komect.network.komectinnet.bean.response.FamilyEntity;
import com.komect.network.komectinnet.bean.response.WiFiCoverEntity;
import com.komect.network.komectinnet.event.c;
import com.komect.network.litepal.crud.DataSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

public class PreInstallTestActivity
extends BasicActivity
implements StepView.OnItemClickListener {
    public static final String BUNDLE_FAMILY_ENTITY = "family_entity";
    public static final String INTENT_ADD_DEVICE = "network_device";
    public static final String INTENT_TEST_POINT = "test_point";
    public static final String INTENT_TEST_COUNT = "test_count";
    public static final String INTENT_TOTAL_ADDED = "total_added";
    public static final String INTENT_POINT_LIST = "test_point_list";
    public static final String INTENT_DEVICE_INDEX = "add_device_index";
    public static final int REQUEST_ADD_DEVICE = 1;
    public static final int REQUEST_ADD_TRST = 2;
    public static final int REQUEST_START_TEST = 3;
    private ActivityPreinstallTestBinding binding;
    private f mDeviceAdapter;
    private i mPointAdapter;
    private WiFiCoverage coverage = new WiFiCoverage();
    private List<NetworkDevice> deviceList = new ArrayList<NetworkDevice>();
    private List<TestPoint> pointList = new ArrayList<TestPoint>();
    private List<TestPoint> pointListBackup = new ArrayList<TestPoint>();
    private boolean isFirstAddDevice = true;
    private boolean isFirstAddTest = true;
    private boolean isCompleteTest;
    private DbManager dbManager;
    private FamilyEntity familyEntity;
    private OrderEntity orderEntity;
    @Inject
    com.komect.network.b.f cacheUtil;
    @Inject
    WifiCoverPresenter wifiCoverPresenter;
    @Inject
    StepEntity stepEntity;

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.getAppComponent().a(this);
        this.binding = (ActivityPreinstallTestBinding)DataBindingUtil.setContentView((Activity)this, (int)R.layout.activity_preinstall_test);
        this.bindTopBar(this.binding.topBar);
        this.binding.layoutBuildingInfo.lyBuildingInfo.setVisibility(0);
        this.dbManager = DbManager.getManager();
        this.orderEntity = DataSupport.findLast(OrderEntity.class);
        this.binding.setOrder(this.orderEntity);
        String string2 = this.orderEntity.getObsPlanId();
        new FloorPlanImg().setObsPlanId(string2).post();
        if (this.getIntent().hasExtra("bundle")) {
            Bundle bundle2 = this.getIntent().getBundleExtra("bundle");
            this.familyEntity = (FamilyEntity)bundle2.getSerializable(BUNDLE_FAMILY_ENTITY);
        }
        this.mDeviceAdapter = new f();
        this.binding.deviceListView.setAdapter((ListAdapter)this.mDeviceAdapter);
        this.mPointAdapter = new i();
        this.binding.testListView.setAdapter((ListAdapter)this.mPointAdapter);
        this.mDeviceAdapter.b((Collection<NetworkDevice>)this.deviceList);
        this.mPointAdapter.b((Collection<TestPoint>)this.pointList);
    }

    @Override
    protected void onResume() {
        super.onResume();
        this.binding.stepView.setCurrentIndex(1).setStepEntity(this.stepEntity).setOnItemClickListener(this);
    }

    public void showAddDeviceView(View view) {
        if (this.mDeviceAdapter.getCount() < 12) {
            Bundle bundle = new Bundle();
            bundle.putInt(INTENT_TOTAL_ADDED, this.mDeviceAdapter.getCount());
            bundle.putBoolean("is_network_design", false);
            new a().a(bundle).b(1).a(DeviceAddActivity.class).g();
        } else {
            Toast.makeText((Context)this, (int)R.string.unable_add_more_devices, (int)0).show();
        }
    }

    public void showAddTestView(View view) {
        if (this.mPointAdapter.getCount() < 20) {
            Bundle bundle = new Bundle();
            bundle.putInt(INTENT_TOTAL_ADDED, this.mPointAdapter.getCount());
            new a().a(bundle).b(2).a(TrstAddActivity.class).g();
        } else {
            Toast.makeText((Context)this, (int)R.string.nw_unable_add_more_tps, (int)0).show();
        }
    }

    public void reset(View view) {
        this.deviceList.clear();
        this.pointList.clear();
        this.pointListBackup.clear();
        this.isFirstAddDevice = true;
        this.isFirstAddTest = true;
        this.mDeviceAdapter.b((Collection<NetworkDevice>)this.deviceList);
        this.mPointAdapter.b((Collection<TestPoint>)this.pointList);
        this.binding.lyHeatMap.removeMarkers();
    }

    public void startTest(View view) {
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.deviceList.isEmpty() || this.deviceList.size() == 1 && this.deviceList.get(0).getDeviceName().equals("-")) {
            bl2 = true;
        }
        if (this.pointList.isEmpty() || this.pointList.size() == 1 && this.pointList.get(0).getPosition().equals("-")) {
            bl3 = true;
        }
        if (bl2 && bl3) {
            Toast.makeText((Context)this, (int)R.string.please_add_device_or_tp, (int)0).show();
            return;
        }
        this.wifiCoverPresenter.getWifiCover(this.orderEntity.getObsPlanId(), this.getRequestDevices());
        this.binding.scrollviewLayout.scrollTo(0, 0);
        if (!this.getTpList().isEmpty()) {
            Bundle bundle = new Bundle();
            bundle.putParcelableArrayList(INTENT_POINT_LIST, this.getTpList());
            new a().a(bundle).b(3).a(NetworkTestActivity.class).g();
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onStirngEvent(c c2) {
        this.coverage.setWifiMap(c2.a());
        this.coverage.setHouseImg(c2.a());
        this.binding.setCoverage(this.coverage);
        if (this.familyEntity != null) {
            this.familyEntity.setPics(c2.a());
            this.dbManager.updateOrderEntityWithBuildingInfo(this.familyEntity);
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN, sticky=true)
    public void onDataSynEvent(WiFiCoverEntity wiFiCoverEntity) {
        if (wiFiCoverEntity.getWifiMap() != null) {
            this.coverage.setReliableRate(wiFiCoverEntity.getReliableRate());
            this.coverage.setWifiMap(wiFiCoverEntity.getWifiMap());
        }
        if (this.getTpList().isEmpty()) {
            this.showTestCompletedView(null, true);
            this.updateStepState(1, 2);
        }
        this.savePreInstallData();
    }

    private void showTestCompletedView(List<TestPoint> list, boolean bl2) {
        this.isCompleteTest = bl2;
        this.showUserInfo(bl2);
        this.showOrderInfo(bl2);
        if (bl2) {
            Toast.makeText((Context)this, (int)R.string.nw_testing_completed, (int)0).show();
            this.binding.btnStartTest.setVisibility(8);
            this.binding.btnRetest.setVisibility(0);
            this.binding.lyActionButton.setVisibility(8);
            this.binding.setCoverage(this.coverage);
            if (list != null && !list.isEmpty()) {
                this.mPointAdapter.b((Collection<TestPoint>)list);
            }
        } else {
            this.binding.btnStartTest.setVisibility(0);
            this.binding.btnRetest.setVisibility(8);
            this.binding.lyActionButton.setVisibility(0);
            this.binding.setCoverage(this.coverage.reset());
            this.mPointAdapter.b((Collection<TestPoint>)list);
        }
    }

    public void retest(View view) {
        this.pointList.clear();
        this.pointList.addAll(this.pointListBackup);
        this.showTestCompletedView(this.pointList, false);
        this.updateStepState(1, 1);
        if (this.stepEntity.getStepThree() != 0) {
            this.updateStepState(3, 0);
        }
        this.cacheUtil.c("cache_config_pre");
        this.dbManager.deleteAll(1);
        this.dbManager.deleteAllTP(4);
        this.dbManager.deleteAll(3);
    }

    private void showUserInfo(boolean bl2) {
        if (bl2) {
            this.binding.includeUserInfo.lyUserInfo.setVisibility(0);
            return;
        }
        this.binding.includeUserInfo.lyUserInfo.setVisibility(8);
    }

    private void showOrderInfo(boolean bl2) {
        if (bl2) {
            this.binding.lyOrderInfo.setVisibility(0);
            return;
        }
        this.binding.lyOrderInfo.setVisibility(8);
    }

    protected void onActivityResult(int n2, int n3, Intent intent) {
        if (n3 == -1) {
            DataSupport dataSupport;
            if (n2 == 1) {
                dataSupport = (NetworkDevice)intent.getParcelableExtra(INTENT_ADD_DEVICE);
                if (this.isFirstAddDevice) {
                    this.isFirstAddDevice = false;
                    this.deviceList.clear();
                }
                this.deviceList.add((NetworkDevice)dataSupport);
                this.mDeviceAdapter.b((Collection<NetworkDevice>)this.deviceList);
                Marker marker = com.komect.network.b.c.a((Context)this, com.komect.network.b.c.a(((NetworkDevice)dataSupport).getDeviceType()));
                marker.setMarkerType(2);
                marker.setObject(dataSupport);
                marker.setIndex(this.deviceList.size());
                marker.setParentView((View)this.binding.imgHeatMap);
                this.binding.lyHeatMap.addMarker(marker);
            }
            if (n2 == 2) {
                dataSupport = (TestPoint)intent.getParcelableExtra(INTENT_TEST_POINT);
                int n4 = intent.getIntExtra(INTENT_TEST_COUNT, 0);
                if (this.isFirstAddTest) {
                    this.isFirstAddTest = false;
                    this.pointList.clear();
                    this.pointListBackup.clear();
                }
                try {
                    for (int i2 = 0; i2 < n4; ++i2) {
                        TestPoint testPoint = (TestPoint)((TestPoint)dataSupport).clone();
                        this.pointList.add(testPoint);
                        this.pointListBackup.add(testPoint);
                        Marker marker = com.komect.network.b.c.a((Context)this, R.drawable.test_marker);
                        marker.setMarkerType(1);
                        marker.setObject(testPoint);
                        marker.setIndex(this.pointList.size());
                        marker.setParentView((View)this.binding.imgHeatMap);
                        this.binding.lyHeatMap.addMarker(marker);
                    }
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    cloneNotSupportedException.printStackTrace();
                }
                this.mPointAdapter.b((Collection<TestPoint>)this.pointList);
            }
            if (n2 == 3) {
                this.pointList = intent.getParcelableArrayListExtra(INTENT_TEST_POINT);
                this.showTestCompletedView(this.pointList, true);
                this.updateStepState(1, 2);
            }
        }
    }

    @Override
    public void onTopBarRightClick(View view) {
        this.onNextStep(ProjectDesignActivity.class);
    }

    public ArrayList<TestPoint> getTpList() {
        ArrayList<TestPoint> arrayList = new ArrayList<TestPoint>();
        ArrayList<Marker> arrayList2 = this.binding.lyHeatMap.getChilds();
        for (Marker marker : arrayList2) {
            if (marker.getMarkerType() != 1) continue;
            TestPoint testPoint = (TestPoint)marker.getObject();
            testPoint.setX(marker.getX());
            testPoint.setY(marker.getY());
            arrayList.add(testPoint);
        }
        return arrayList;
    }

    private List<NetworkDevice> getRequestDevices() {
        ArrayList<NetworkDevice> arrayList = new ArrayList<NetworkDevice>();
        ArrayList<Marker> arrayList2 = this.binding.lyHeatMap.getChilds();
        for (Marker marker : arrayList2) {
            int n2 = marker.getParentView().getHeight();
            int n3 = marker.getParentView().getWidth();
            if (marker.getMarkerType() != 2) continue;
            NetworkDevice networkDevice = (NetworkDevice)marker.getObject();
            networkDevice.setX(marker.getX() + (float)marker.getWidth() * 0.55f);
            networkDevice.setY(marker.getY() + (float)marker.getHeight() * 0.7f);
            networkDevice.setParentHeight(n2);
            networkDevice.setParentWitdh(n3);
            if (networkDevice.getDeviceType().equalsIgnoreCase("POE\u4ea4\u6362\u673a")) continue;
            arrayList.add(networkDevice);
        }
        return arrayList;
    }

    private List<NetworkDevice> getNetworkDevices() {
        ArrayList<NetworkDevice> arrayList = new ArrayList<NetworkDevice>();
        ArrayList<Marker> arrayList2 = this.binding.lyHeatMap.getChilds();
        for (Marker marker : arrayList2) {
            int n2 = marker.getParentView().getHeight();
            int n3 = marker.getParentView().getWidth();
            if (marker.getMarkerType() != 2) continue;
            NetworkDevice networkDevice = (NetworkDevice)marker.getObject();
            networkDevice.setX(marker.getX());
            networkDevice.setY(marker.getY());
            networkDevice.setParentHeight(n2);
            networkDevice.setParentWitdh(n3);
            this.dbManager.saveDevice(networkDevice, 1);
            arrayList.add(networkDevice);
        }
        return arrayList;
    }

    private void savePreInstallData() {
        List<NetworkDevice> list = this.getNetworkDevices();
        for (TestPoint testPoint : this.pointList) {
            this.dbManager.saveTP(testPoint, 1);
        }
        for (TestPoint testPoint : this.pointListBackup) {
            this.dbManager.saveTP(testPoint, 4);
        }
        this.dbManager.saveCoverage(this.coverage, 1);
        ReportConfig reportConfig = new ReportConfig().setTitle(this.getString(R.string.preinstall_test_report)).setMapTitle(this.getString(R.string.nw_wifi_coverage_heatmap)).setDevices(list).setTestPoints(this.pointList).setHasFamily(true).setCoverage(this.coverage.getReliableRate()).setMapImg(this.coverage.getWifiMap());
        this.cacheUtil.a("cache_config_pre", reportConfig);
    }

    @Override
    public void onItemClick(View view, int n2) {
        if (n2 == 2) {
            this.onNextStep(ProjectDesignActivity.class);
            return;
        }
        if (n2 == 3) {
            this.onNextStep(PostInstallActivity.class);
            return;
        }
    }

    private void onNextStep(final Class<?> clazz) {
        if (!this.isCompleteTest) {
            this.showAlertDialog(null, this.getString(R.string.preinstall_undone_skip_step), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int n2) {
                    PreInstallTestActivity.this.updateStepState(1, -1);
                    PreInstallTestActivity.this.startNextPage(clazz);
                }
            });
        } else {
            this.startNextPage(clazz);
        }
    }

    private void updateStepState(int n2, int n3) {
        switch (n2) {
            case 1: {
                this.binding.stepView.setStepEntity(this.stepEntity.setStepOne(n3));
                break;
            }
            case 3: {
                this.binding.stepView.setStepEntity(this.stepEntity.setStepThree(n3));
                break;
            }
        }
    }

    private void startNextPage(Class<?> clazz) {
        new a().a(clazz).g();
    }

    @Override
    protected void onPause() {
        super.onPause();
        EventBus.getDefault().removeAllStickyEvents();
    }

    @Override
    public void onTopBarLeftClick(View view) {
        new a().a(true).a(0x4000000).a(ChooseFamilyActivity.class).g();
    }
}

