/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.app.activity;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.databinding.DataBindingUtil;
import android.os.Bundle;
import android.view.View;
import android.widget.ListAdapter;
import android.widget.Toast;
import com.komect.network.R;
import com.komect.network.a.a;
import com.komect.network.app.a.i;
import com.komect.network.app.activity.BasicActivity;
import com.komect.network.app.activity.NetworkTestActivity;
import com.komect.network.app.activity.PostInstallActivity;
import com.komect.network.app.activity.ProjectDesignActivity;
import com.komect.network.app.activity.TrstAddActivity;
import com.komect.network.app.widget.StepView;
import com.komect.network.b.f;
import com.komect.network.bean.StepEntity;
import com.komect.network.bean.TestPoint;
import com.komect.network.database.DbManager;
import com.komect.network.database.OrderEntity;
import com.komect.network.databinding.ActivityPreInstallNoRoomBinding;
import com.komect.network.databinding.ReportConfig;
import com.komect.network.litepal.crud.DataSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.greenrobot.eventbus.EventBus;

public class PreInstallNoRoomActivity
extends BasicActivity
implements StepView.OnItemClickListener {
    private static final String TAG = "PreInstallTestActivity";
    public static final String INTENT_TEST_POINT = "test_point";
    public static final String INTENT_TEST_COUNT = "test_count";
    public static final String INTENT_TOTAL_ADDED = "total_added";
    public static final String INTENT_POINT_LIST = "test_point_list";
    public static final int REQUEST_ADD_TRST = 2;
    public static final int REQUEST_START_TEST = 3;
    private ActivityPreInstallNoRoomBinding binding;
    private i mPointAdapter;
    private List<TestPoint> pointList = new ArrayList<TestPoint>();
    private List<TestPoint> pointListBackup = new ArrayList<TestPoint>();
    private boolean isFirstAddTest = true;
    private DbManager dbManager;
    private OrderEntity orderEntity;
    @Inject
    f cacheUtil;
    @Inject
    StepEntity stepEntity;

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.getAppComponent().a(this);
        this.binding = (ActivityPreInstallNoRoomBinding)DataBindingUtil.setContentView((Activity)this, (int)R.layout.activity_pre_install_no_room);
        this.bindTopBar(this.binding.topBar);
        this.dbManager = DbManager.getManager();
        this.orderEntity = DataSupport.findLast(OrderEntity.class);
        this.binding.setOrder(this.orderEntity);
        this.mPointAdapter = new i();
        this.binding.testListView.setAdapter((ListAdapter)this.mPointAdapter);
        this.mPointAdapter.b((Collection<TestPoint>)this.pointList);
    }

    @Override
    protected void onResume() {
        super.onResume();
        this.binding.stepView.setCurrentIndex(1).setStepEntity(this.stepEntity).setOnItemClickListener(this);
    }

    public void showAddTestView(View view) {
        if (this.mPointAdapter.getCount() < 20) {
            Bundle bundle = new Bundle();
            bundle.putInt(INTENT_TOTAL_ADDED, this.mPointAdapter.getCount());
            new a().a(bundle).b(2).a(TrstAddActivity.class).g();
        } else {
            Toast.makeText((Context)this, (int)R.string.nw_unable_add_more_tps, (int)0).show();
        }
    }

    public void reset(View view) {
        this.pointList.clear();
        this.pointListBackup.clear();
        this.isFirstAddTest = true;
        this.mPointAdapter.b((Collection<TestPoint>)this.pointList);
    }

    public void startTest(View view) {
        if (this.pointList.isEmpty() || this.pointList.size() == 1 && this.pointList.get(0).getPosition().equals("-")) {
            Toast.makeText((Context)this, (int)R.string.nw_please_add_tps, (int)0).show();
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putParcelableArrayList(INTENT_POINT_LIST, (ArrayList)this.pointList);
        new a().a(bundle).b(3).a(NetworkTestActivity.class).g();
    }

    private void showTestCompletedView(List<TestPoint> list, boolean bl2) {
        this.showUserInfo(bl2);
        this.showOrderInfo(bl2);
        if (bl2) {
            Toast.makeText((Context)this, (int)R.string.nw_testing_completed, (int)0).show();
            this.binding.txtAdd.setVisibility(8);
            this.binding.btnRetest.setVisibility(0);
            this.binding.lyActionButton.setVisibility(8);
            if (list != null && !list.isEmpty()) {
                this.mPointAdapter.b((Collection<TestPoint>)list);
            }
        } else {
            this.binding.txtAdd.setVisibility(0);
            this.binding.btnStartTest.setVisibility(0);
            this.binding.btnRetest.setVisibility(8);
            this.binding.lyActionButton.setVisibility(0);
            this.mPointAdapter.b((Collection<TestPoint>)this.pointListBackup);
        }
    }

    public void retest(View view) {
        this.showTestCompletedView(null, false);
        this.updateStepState(1, 1);
        if (this.stepEntity.getStepThree() != 0) {
            this.updateStepState(3, 0);
        }
        this.cacheUtil.c("cache_config_pre");
        this.dbManager.deleteAll(1);
        this.dbManager.deleteAllTP(4);
        this.dbManager.deleteAll(3);
    }

    private void showUserInfo(boolean bl2) {
        if (bl2) {
            this.binding.includeUserInfo.lyUserInfo.setVisibility(0);
            return;
        }
        this.binding.includeUserInfo.lyUserInfo.setVisibility(8);
    }

    private void showOrderInfo(boolean bl2) {
        if (bl2) {
            this.binding.lyOrderInfo.setVisibility(0);
            return;
        }
        this.binding.lyOrderInfo.setVisibility(8);
    }

    protected void onActivityResult(int n2, int n3, Intent intent) {
        if (n3 == -1) {
            if (n2 == 2) {
                TestPoint testPoint = (TestPoint)intent.getParcelableExtra(INTENT_TEST_POINT);
                int n4 = intent.getIntExtra(INTENT_TEST_COUNT, 0);
                if (this.isFirstAddTest) {
                    this.isFirstAddTest = false;
                    this.pointList.clear();
                    this.pointListBackup.clear();
                }
                try {
                    for (int i2 = 0; i2 < n4; ++i2) {
                        TestPoint testPoint2 = (TestPoint)testPoint.clone();
                        this.pointList.add(testPoint2);
                        this.pointListBackup.add(testPoint2);
                    }
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    cloneNotSupportedException.printStackTrace();
                }
                this.mPointAdapter.b((Collection<TestPoint>)this.pointList);
            }
            if (n2 == 3) {
                this.pointList = intent.getParcelableArrayListExtra(INTENT_TEST_POINT);
                this.showTestCompletedView(this.pointList, true);
                this.savePreInstallData();
                this.updateStepState(1, 2);
            }
        }
    }

    @Override
    public void onTopBarRightClick(View view) {
        this.onNextStep(ProjectDesignActivity.class);
    }

    private void savePreInstallData() {
        for (TestPoint testPoint : this.pointList) {
            this.dbManager.saveTP(testPoint, 1);
        }
        for (TestPoint testPoint : this.pointListBackup) {
            this.dbManager.saveTP(testPoint, 4);
        }
        ReportConfig reportConfig = new ReportConfig().setTitle(this.getString(R.string.nw_preload_test_report)).setTestPoints(this.pointList).setHasFamily(false);
        this.cacheUtil.a("cache_config_pre", reportConfig);
    }

    @Override
    public void onItemClick(View view, int n2) {
        if (n2 == 2) {
            this.onNextStep(ProjectDesignActivity.class);
            return;
        }
        if (n2 == 3) {
            this.onNextStep(PostInstallActivity.class);
            return;
        }
    }

    private void updateStepState(int n2, int n3) {
        switch (n2) {
            case 1: {
                this.binding.stepView.setStepEntity(this.stepEntity.setStepOne(n3));
                break;
            }
            case 3: {
                this.binding.stepView.setStepEntity(this.stepEntity.setStepThree(n3));
                break;
            }
        }
    }

    private void onNextStep(final Class<?> clazz) {
        if (this.stepEntity.getStepOne() != 2) {
            this.showAlertDialog(null, this.getString(R.string.preinstall_undone_skip_step), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int n2) {
                    PreInstallNoRoomActivity.this.updateStepState(1, -1);
                    PreInstallNoRoomActivity.this.startNextPage(clazz);
                }
            });
        } else {
            this.startNextPage(clazz);
        }
    }

    private void startNextPage(Class<?> clazz) {
        new a().a(clazz).g();
    }

    @Override
    protected void onPause() {
        super.onPause();
        EventBus.getDefault().removeAllStickyEvents();
    }
}

