/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.app.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.databinding.DataBindingUtil;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.View;
import com.komect.network.R;
import com.komect.network.app.activity.BasicActivity;
import com.komect.network.b.h;
import com.komect.network.bean.TestPoint;
import com.komect.network.connectionclass.ConnectionQuality;
import com.komect.network.connectionclass.a;
import com.komect.network.connectionclass.b;
import com.komect.network.databinding.ActivityNetworkTestBinding;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;

public class NetworkTestActivity
extends BasicActivity
implements a.b {
    private static final String TAG = "NetworkTestActivity";
    private ActivityNetworkTestBinding databing;
    private h mWifiUtil;
    private int tpIndex = 1;
    private ArrayList<TestPoint> pointList = new ArrayList();
    private TestPoint point;
    private int mTries = 0;
    private a mConnectionClassManager;
    private b mDeviceBandwidthSampler;
    private ConnectionQuality mConnectionClass = ConnectionQuality.UNKNOWN;

    protected void onCreate(Bundle bundle) {
        Bundle bundle2;
        super.onCreate(bundle);
        this.getAppComponent().a(this);
        this.databing = (ActivityNetworkTestBinding)DataBindingUtil.setContentView((Activity)this, (int)R.layout.activity_network_test);
        if (this.getIntent().hasExtra("bundle") && (bundle2 = this.getIntent().getBundleExtra("bundle")).containsKey("test_point_list")) {
            this.pointList = bundle2.getParcelableArrayList("test_point_list");
        }
        this.mConnectionClassManager = a.a();
        this.mDeviceBandwidthSampler = b.a();
    }

    @Override
    protected void onResume() {
        super.onResume();
        this.mConnectionClassManager.a(this);
        this.mWifiUtil = new h((Context)this);
        this.databing.currentSsid.setText((CharSequence)String.format(this.getString(R.string.nw_current_wifi), this.mWifiUtil.d()));
    }

    @Override
    protected void onPause() {
        super.onPause();
        this.mConnectionClassManager.b(this);
    }

    public void switchNetwork(View view) {
        this.startActivity(new Intent("android.settings.WIFI_SETTINGS"));
    }

    public void dismissTestWindow(View view) {
        this.onBackPressed();
    }

    public void testNetwork(View view) {
        this.showCheckLoading();
        if (this.pointList != null && !this.pointList.isEmpty()) {
            this.point = this.pointList.get(this.tpIndex - 1);
            this.point.setSsid(String.format("%s(%s)", this.mWifiUtil.d(), this.mWifiUtil.c()));
            this.point.setLevel(String.format("%ddBm", this.mWifiUtil.c((Context)this)));
            this.point.setLinkSpeed(String.format("%dMbps", this.mWifiUtil.e()));
            this.point.setFrequency(String.format("%dMHz/%d", this.mWifiUtil.d((Context)this), this.mWifiUtil.e((Context)this)));
            if (this.tpIndex < this.pointList.size()) {
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        NetworkTestActivity.this.hideCheckLoading();
                    }
                }, 1000L);
                ++this.tpIndex;
                this.databing.speedGuide.setText((CharSequence)String.format(this.getString(R.string.nw_network_test_tips), this.tpIndex));
            } else {
                this.startActivityPage();
            }
        } else {
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    NetworkTestActivity.this.hideCheckLoading();
                }
            }, 1000L);
            this.startActivityPage();
        }
    }

    private void startActivityPage() {
        Intent intent = new Intent();
        intent.putExtra("test_point", this.pointList);
        this.setResult(-1, intent);
        this.finish();
    }

    private void showCheckLoading() {
        this.databing.rlCheckGuide.setVisibility(8);
        this.databing.lyCheckLoading.setVisibility(0);
    }

    private void hideCheckLoading() {
        this.databing.rlCheckGuide.setVisibility(0);
        this.databing.lyCheckLoading.setVisibility(8);
    }

    @Override
    public void onBandwidthStateChange(ConnectionQuality connectionQuality) {
        this.mConnectionClass = connectionQuality;
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                double d2 = NetworkTestActivity.this.mConnectionClassManager.c();
                Log.d((String)NetworkTestActivity.TAG, (String)("run: " + d2));
                if (d2 < 100.0) {
                    NetworkTestActivity.this.point.setDownloadSpeed(String.format(NetworkTestActivity.this.getString(R.string.kbs), d2 / 8.0));
                } else {
                    double d3 = d2 / 8000.0;
                    NetworkTestActivity.this.point.setDownloadSpeed(String.format(NetworkTestActivity.this.getString(R.string.ms), d3));
                }
                NetworkTestActivity.this.hideCheckLoading();
                if (NetworkTestActivity.this.tpIndex < NetworkTestActivity.this.pointList.size()) {
                    NetworkTestActivity.this.tpIndex = NetworkTestActivity.this.tpIndex + 1;
                    ((NetworkTestActivity)NetworkTestActivity.this).databing.speedGuide.setText((CharSequence)String.format(NetworkTestActivity.this.getString(R.string.nw_network_test_tips), NetworkTestActivity.this.tpIndex));
                } else {
                    NetworkTestActivity.this.startActivityPage();
                }
            }
        });
    }

    private class DownloadImage
    extends AsyncTask<String, Void, Void> {
        private DownloadImage() {
        }

        protected void onPreExecute() {
            NetworkTestActivity.this.mDeviceBandwidthSampler.b();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Void doInBackground(String ... stringArray) {
            String string2 = stringArray[0];
            try {
                URLConnection uRLConnection = new URL(string2).openConnection();
                uRLConnection.setUseCaches(false);
                uRLConnection.connect();
                try (InputStream inputStream = uRLConnection.getInputStream();){
                    byte[] byArray = new byte[1024];
                    while (inputStream.read(byArray) != -1) {
                    }
                }
            }
            catch (IOException iOException) {
                Log.e((String)NetworkTestActivity.TAG, (String)"Error while downloading image.");
            }
            return null;
        }

        protected void onPostExecute(Void void_) {
            NetworkTestActivity.this.mDeviceBandwidthSampler.c();
            if (NetworkTestActivity.this.mConnectionClass == ConnectionQuality.UNKNOWN && NetworkTestActivity.this.mTries < 10) {
                NetworkTestActivity.this.mTries++;
                new DownloadImage().execute(new String[]{"http://xy3.gph.netease.com/patch3.0.492.xy3"});
            }
        }
    }
}

