/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.app.activity;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.view.KeyEvent;
import com.komect.network.R;
import com.komect.network.app.activity.BasicActivity;
import java.util.ArrayList;
import java.util.List;

public class CheckPermissionsActivity
extends BasicActivity
implements ActivityCompat.OnRequestPermissionsResultCallback {
    protected String[] needPermissions = new String[]{"android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_COARSE_LOCATION", "android.permission.WRITE_EXTERNAL_STORAGE"};
    private static final int PERMISSON_REQUESTCODE = 0;
    private boolean isNeedCheck = true;

    @Override
    protected void onResume() {
        super.onResume();
        if (this.isNeedCheck) {
            this.checkPermissions(this.needPermissions);
        }
    }

    private void checkPermissions(String ... stringArray) {
        List<String> list = this.findDeniedPermissions(stringArray);
        if (null != list && list.size() > 0) {
            ActivityCompat.requestPermissions((Activity)this, (String[])list.toArray(new String[list.size()]), (int)0);
        }
    }

    private List<String> findDeniedPermissions(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : stringArray) {
            if (ContextCompat.checkSelfPermission((Context)this, (String)string2) == 0 && !ActivityCompat.shouldShowRequestPermissionRationale((Activity)this, (String)string2)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    private boolean verifyPermissions(int[] nArray) {
        for (int n2 : nArray) {
            if (n2 == 0) continue;
            return false;
        }
        return true;
    }

    public void onRequestPermissionsResult(int n2, String[] stringArray, int[] nArray) {
        if (n2 == 0 && !this.verifyPermissions(nArray)) {
            this.showMissingPermissionDialog();
            this.isNeedCheck = false;
        }
    }

    private void showMissingPermissionDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setTitle(R.string.nw_notifyTitle);
        builder.setMessage(R.string.nw_notifyMsg);
        builder.setNegativeButton(R.string.nw_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n2) {
                CheckPermissionsActivity.this.finish();
            }
        });
        builder.setPositiveButton(R.string.nw_setting, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n2) {
                CheckPermissionsActivity.this.startAppSettings();
            }
        });
        builder.setCancelable(false);
        builder.show();
    }

    private void startAppSettings() {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent.setData(Uri.parse((String)("package:" + this.getPackageName())));
        this.startActivity(intent);
    }

    public boolean onKeyDown(int n2, KeyEvent keyEvent) {
        if (n2 == 4) {
            this.finish();
            return true;
        }
        return super.onKeyDown(n2, keyEvent);
    }
}

