/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.app.activity;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.databinding.DataBindingUtil;
import android.net.wifi.ScanResult;
import android.os.Build;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.komect.network.R;
import com.komect.network.a.c;
import com.komect.network.app.a.a;
import com.komect.network.app.a.e;
import com.komect.network.app.activity.CheckPermissionsActivity;
import com.komect.network.b.b;
import com.komect.network.b.h;
import com.komect.network.databinding.ActivityNwAccessPointBinding;
import com.komect.network.databinding.BindConverters;
import com.komect.network.databinding.LayoutNwAccessPointBinding;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

public class AccessPointActivity
extends CheckPermissionsActivity
implements AdapterView.OnItemClickListener {
    private static final int REQUEST_CODE_LOCATION_SETTINGS = 0;
    private static final String TAG_BAND_VIEW = "tag_band_view";
    private static final String TAG_DISTURB_VIEW = "tag_disturb_view";
    private ActivityNwAccessPointBinding binding;
    private LayoutNwAccessPointBinding apBinding;
    private a mAccessPointAdapter;
    private h mWifiUtil;
    private List<ScanResult> mWifiList;
    private String[] headers = new String[]{"\u9891\u6bb5", "\u5e72\u6270"};
    private String[] bands = new String[]{"\u4e0d\u9650", "2.4G", "5G"};
    private String[] disturbs = new String[]{"\u4e0d\u9650", "\u540c\u9891\u5e72\u6270", "\u90bb\u9891\u5e72\u6270"};
    private List<View> popupViews = new ArrayList<View>();
    private e bandAdapter;
    private e disturbAdapter;
    final TimerTask mTimerTask = new TimerTask(){

        @Override
        public void run() {
            if (AccessPointActivity.this.mWifiUtil != null) {
                AccessPointActivity.this.mWifiUtil.b((Context)AccessPointActivity.this);
                AccessPointActivity.this.mWifiList = AccessPointActivity.this.mWifiUtil.b();
                if (AccessPointActivity.this.mWifiList != null) {
                    new c().a(AccessPointActivity.this.mWifiList).g();
                }
            }
        }
    };

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this);
        this.binding = (ActivityNwAccessPointBinding)DataBindingUtil.setContentView((Activity)this, (int)R.layout.activity_nw_access_point);
        this.bindTopBar(this.binding.topBar);
        this.apBinding = (LayoutNwAccessPointBinding)DataBindingUtil.inflate((LayoutInflater)layoutInflater, (int)R.layout.layout_nw_access_point, null, (boolean)false);
        this.mAccessPointAdapter = new a();
        this.apBinding.apList.setAdapter((ListAdapter)this.mAccessPointAdapter);
        this.initDropDownMenu(layoutInflater);
        if (Build.VERSION.SDK_INT > 23 && !b.a((Context)this)) {
            this.showAlertDialog(this.getString(R.string.nw_need_open_gps), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int n2) {
                    Intent intent = new Intent("android.settings.LOCATION_SOURCE_SETTINGS");
                    AccessPointActivity.this.startActivityForResult(intent, 0);
                }
            });
        } else {
            this.init();
        }
    }

    private void initDropDownMenu(LayoutInflater layoutInflater) {
        ListView listView = new ListView((Context)this);
        listView.setTag((Object)TAG_BAND_VIEW);
        listView.setDividerHeight(0);
        this.bandAdapter = new e(layoutInflater, Arrays.asList(this.bands));
        listView.setAdapter((ListAdapter)this.bandAdapter);
        ListView listView2 = new ListView((Context)this);
        listView2.setTag((Object)TAG_DISTURB_VIEW);
        listView2.setDividerHeight(0);
        this.disturbAdapter = new e(layoutInflater, Arrays.asList(this.disturbs));
        listView2.setAdapter((ListAdapter)this.disturbAdapter);
        this.popupViews.add((View)listView);
        this.popupViews.add((View)listView2);
        listView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        listView2.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        this.binding.dropDownMenu.setDropDownMenu(Arrays.asList(this.headers), this.popupViews, this.apBinding.getRoot());
    }

    private void init() {
        this.mWifiUtil = new h((Context)this);
        this.initCurrentNetworkData();
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
        scheduledExecutorService.scheduleAtFixedRate(this.mTimerTask, 0L, 3000L, TimeUnit.MILLISECONDS);
    }

    private void initCurrentNetworkData() {
        this.apBinding.currentNetwork.ssid.setText((CharSequence)this.mWifiUtil.d());
        this.apBinding.currentNetwork.macAddress.setText((CharSequence)String.format("(%s)", this.mWifiUtil.c()));
        this.apBinding.currentNetwork.wifiLevel.setText((CharSequence)String.format("%ddBm", this.mWifiUtil.c((Context)this)));
        this.apBinding.currentNetwork.channel.setText((CharSequence)String.format("%d", this.mWifiUtil.e((Context)this)));
        this.apBinding.currentNetwork.frequency.setText((CharSequence)String.format("%dMHz", this.mWifiUtil.d((Context)this)));
        this.apBinding.currentNetwork.linkSpeed.setText((CharSequence)String.format("%dMbps", this.mWifiUtil.e()));
        this.apBinding.currentNetwork.encryption.setText((CharSequence)this.mWifiUtil.f((Context)this));
        this.apBinding.currentNetwork.wifiType.setText((CharSequence)h.d(this.mWifiUtil.d((Context)this)));
        BindConverters.loadWifilevel(this.apBinding.currentNetwork.wifiLevel, this.mWifiUtil.c((Context)this));
        BindConverters.loadImagelevel(this.apBinding.currentNetwork.imageLevel, this.mWifiUtil.c((Context)this));
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onUpdateEvent(c c2) {
        this.mAccessPointAdapter.b(this.getFilterBandList(c2.a()));
        this.apBinding.currentNetwork.wifiLevel.setText((CharSequence)String.format("%ddBm", this.mWifiUtil.c((Context)this)));
    }

    protected void onActivityResult(int n2, int n3, Intent intent) {
        super.onActivityResult(n2, n3, intent);
        if (n2 == 0 && b.a((Context)this)) {
            this.init();
        }
    }

    @Override
    public void onBackPressed() {
        if (this.binding.dropDownMenu.isShowing()) {
            this.binding.dropDownMenu.closeMenu();
        } else {
            super.onBackPressed();
        }
    }

    public void onItemClick(AdapterView<?> adapterView, View view, int n2, long l2) {
        switch (adapterView.getTag().toString()) {
            case "tag_band_view": {
                this.bandAdapter.a(n2);
                this.binding.dropDownMenu.setTabText(n2 == 0 ? this.headers[0] : this.bands[n2]);
                this.binding.dropDownMenu.closeMenu();
                this.updateList();
                break;
            }
            case "tag_disturb_view": {
                this.disturbAdapter.a(n2);
                this.binding.dropDownMenu.setTabText(n2 == 0 ? this.headers[1] : this.disturbs[n2]);
                this.binding.dropDownMenu.closeMenu();
                this.updateList();
                break;
            }
        }
    }

    private void updateList() {
        new c().a(this.mWifiList).g();
    }

    private List<ScanResult> getFilterBandList(List<ScanResult> list) {
        List<ScanResult> list2 = new ArrayList<ScanResult>();
        if (list == null || list.isEmpty()) {
            return list2;
        }
        int n2 = this.bandAdapter.a();
        switch (n2) {
            case 0: {
                list2 = list;
                break;
            }
            case 1: {
                for (ScanResult scanResult : list) {
                    if (!h.b(scanResult.frequency)) continue;
                    list2.add(scanResult);
                }
                break;
            }
            case 2: {
                for (ScanResult scanResult : list) {
                    if (!h.c(scanResult.frequency)) continue;
                    list2.add(scanResult);
                }
                break;
            }
        }
        List<ScanResult> list3 = new ArrayList();
        int n3 = this.disturbAdapter.a();
        int n4 = this.mWifiUtil.d((Context)this);
        switch (n3) {
            case 0: {
                list3 = list2;
                break;
            }
            case 1: {
                for (ScanResult scanResult : list2) {
                    if (n4 != scanResult.frequency) continue;
                    list3.add(scanResult);
                }
            }
            case 2: {
                for (ScanResult scanResult : list2) {
                    int n5;
                    if (!h.b(scanResult.frequency) || (n5 = Math.abs(n4 - scanResult.frequency)) <= 0 || n5 >= 25) continue;
                    list3.add(scanResult);
                }
                break;
            }
        }
        return list3;
    }
}

