/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.utils;

import android.content.Context;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.text.TextUtils;
import android.widget.Toast;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class WiFiUtil {
    private WifiManager mWifiManager;
    private WifiInfo mWifiInfo;
    private List<ScanResult> mWifiList;

    public WiFiUtil(Context context) {
        this.mWifiManager = (WifiManager)context.getSystemService("wifi");
        this.mWifiInfo = this.mWifiManager.getConnectionInfo();
    }

    public WifiManager getWifiManager() {
        return this.mWifiManager;
    }

    public void openWifi(Context context) {
        if (!this.mWifiManager.isWifiEnabled()) {
            this.mWifiManager.setWifiEnabled(true);
        } else if (this.mWifiManager.getWifiState() == 2) {
            Toast.makeText((Context)context, (CharSequence)"WiFi\u6b63\u5728\u5f00\u542f\uff0c\u4e0d\u7528\u518d\u5f00\u4e86", (int)0).show();
        } else {
            Toast.makeText((Context)context, (CharSequence)"WiFi\u5df2\u7ecf\u5f00\u542f,\u4e0d\u7528\u518d\u5f00\u4e86", (int)0).show();
        }
    }

    public void closeWifi(Context context) {
        if (this.mWifiManager.isWifiEnabled()) {
            this.mWifiManager.setWifiEnabled(false);
        } else if (this.mWifiManager.getWifiState() == 1) {
            Toast.makeText((Context)context, (CharSequence)"WiFi\u5df2\u7ecf\u5173\u95ed\uff0c\u4e0d\u7528\u518d\u5173\u4e86", (int)0).show();
        } else if (this.mWifiManager.getWifiState() == 0) {
            Toast.makeText((Context)context, (CharSequence)"WiFi\u6b63\u5728\u5173\u95ed\uff0c\u4e0d\u7528\u518d\u5173\u4e86", (int)0).show();
        } else {
            Toast.makeText((Context)context, (CharSequence)"\u8bf7\u91cd\u65b0\u5173\u95ed", (int)0).show();
        }
    }

    public void checkState(Context context) {
        if (this.mWifiManager.getWifiState() == 0) {
            Toast.makeText((Context)context, (CharSequence)"WiFi\u6b63\u5728\u5173\u95ed", (int)0).show();
        } else if (this.mWifiManager.getWifiState() == 1) {
            Toast.makeText((Context)context, (CharSequence)"WiFi\u5df2\u7ecf\u5173\u95ed", (int)0).show();
        } else if (this.mWifiManager.getWifiState() == 2) {
            Toast.makeText((Context)context, (CharSequence)"WiFi\u6b63\u5728\u5f00\u542f", (int)0).show();
        } else if (this.mWifiManager.getWifiState() == 3) {
            Toast.makeText((Context)context, (CharSequence)"WiFi\u5df2\u7ecf\u5f00\u542f", (int)0).show();
        } else {
            Toast.makeText((Context)context, (CharSequence)"\u6ca1\u6709\u83b7\u53d6\u5230WiFi\u72b6\u6001", (int)0).show();
        }
    }

    public void startScan(Context context) {
        this.mWifiManager.startScan();
        this.mWifiList = this.mWifiManager.getScanResults();
        if (this.mWifiList == null) {
            if (this.mWifiManager.getWifiState() == 3) {
                Toast.makeText((Context)context, (CharSequence)"\u5f53\u524d\u533a\u57df\u6ca1\u6709\u65e0\u7ebf\u7f51\u7edc", (int)0).show();
            } else if (this.mWifiManager.getWifiState() == 2) {
                Toast.makeText((Context)context, (CharSequence)"WiFi\u6b63\u5728\u5f00\u542f\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (int)0).show();
            } else {
                Toast.makeText((Context)context, (CharSequence)"WiFi\u6ca1\u6709\u5f00\u542f", (int)0).show();
            }
        }
    }

    public List<ScanResult> getWifiList() {
        return this.mWifiList;
    }

    private List<ScanResult> sortByLevel(List<ScanResult> list) {
        for (int i = 0; i < list.size(); ++i) {
            for (int j = 0; j < list.size(); ++j) {
                if (list.get((int)i).level <= list.get((int)j).level) continue;
                ScanResult temp = list.get(i);
                list.set(i, list.get(j));
                list.set(j, temp);
            }
        }
        return list;
    }

    private List<ScanResult> sortBySSID(List<ScanResult> list) {
        Collections.sort(list, new Comparator<ScanResult>(){

            @Override
            public int compare(ScanResult scanResult, ScanResult t1) {
                if (scanResult.SSID.compareToIgnoreCase(t1.SSID) == 0) {
                    return scanResult.BSSID.compareToIgnoreCase(t1.BSSID);
                }
                return scanResult.SSID.compareToIgnoreCase(t1.SSID);
            }
        });
        return list;
    }

    public String getMacAddress() {
        return this.mWifiInfo == null ? "unknown mac" : this.mWifiInfo.getMacAddress();
    }

    public String getBSSID() {
        return this.mWifiInfo == null ? "unknown bssid" : this.mWifiInfo.getBSSID();
    }

    public int getIPAddress() {
        return this.mWifiInfo == null ? 0 : this.mWifiInfo.getIpAddress();
    }

    public int getNetworkId() {
        return this.mWifiInfo == null ? 0 : this.mWifiInfo.getNetworkId();
    }

    public String getSSID() {
        if (this.mWifiInfo == null) {
            return null;
        }
        String ssid = this.mWifiInfo.getSSID();
        return TextUtils.isEmpty((CharSequence)ssid) ? "unknown ssid" : ssid.substring(1, ssid.length() - 1);
    }

    public int getLinkSpeed() {
        return this.mWifiInfo == null ? 0 : this.mWifiInfo.getLinkSpeed();
    }

    public int getCurrentLevel(Context context) {
        if (this.mWifiManager == null) {
            this.mWifiManager = (WifiManager)context.getSystemService("wifi");
            this.mWifiInfo = this.mWifiManager.getConnectionInfo();
        }
        List scanResults = this.mWifiManager.getScanResults();
        for (ScanResult result : scanResults) {
            if (!result.BSSID.equalsIgnoreCase(this.mWifiInfo.getBSSID()) || !result.SSID.equalsIgnoreCase(this.mWifiInfo.getSSID().substring(1, this.mWifiInfo.getSSID().length() - 1))) continue;
            return result.level;
        }
        return -1;
    }

    public int getCurrentFrequency(Context context) {
        if (this.mWifiManager == null) {
            this.mWifiManager = (WifiManager)context.getSystemService("wifi");
            this.mWifiInfo = this.mWifiManager.getConnectionInfo();
        }
        List scanResults = this.mWifiManager.getScanResults();
        for (ScanResult result : scanResults) {
            if (!result.BSSID.equalsIgnoreCase(this.mWifiInfo.getBSSID()) || !result.SSID.equalsIgnoreCase(this.mWifiInfo.getSSID().substring(1, this.mWifiInfo.getSSID().length() - 1))) continue;
            return result.frequency;
        }
        return -1;
    }

    public int getCurrentChannel(Context context) {
        if (this.mWifiManager == null) {
            this.mWifiManager = (WifiManager)context.getSystemService("wifi");
            this.mWifiInfo = this.mWifiManager.getConnectionInfo();
        }
        List scanResults = this.mWifiManager.getScanResults();
        for (ScanResult result : scanResults) {
            if (!result.BSSID.equalsIgnoreCase(this.mWifiInfo.getBSSID()) || !result.SSID.equalsIgnoreCase(this.mWifiInfo.getSSID().substring(1, this.mWifiInfo.getSSID().length() - 1))) continue;
            return WiFiUtil.getChannelByFrequency(result.frequency);
        }
        return -1;
    }

    public String getCurrentSecurity(Context context) {
        if (this.mWifiManager == null) {
            this.mWifiManager = (WifiManager)context.getSystemService("wifi");
            this.mWifiInfo = this.mWifiManager.getConnectionInfo();
        }
        List scanResults = this.mWifiManager.getScanResults();
        for (ScanResult result : scanResults) {
            if (!result.BSSID.equalsIgnoreCase(this.mWifiInfo.getBSSID()) || !result.SSID.equalsIgnoreCase(this.mWifiInfo.getSSID().substring(1, this.mWifiInfo.getSSID().length() - 1))) continue;
            return WiFiUtil.getSecurity(result.capabilities);
        }
        return null;
    }

    public static int getChannelByFrequency(int frequency) {
        int channel = -1;
        switch (frequency) {
            case 2412: {
                channel = 1;
                break;
            }
            case 2417: {
                channel = 2;
                break;
            }
            case 2422: {
                channel = 3;
                break;
            }
            case 2427: {
                channel = 4;
                break;
            }
            case 2432: {
                channel = 5;
                break;
            }
            case 2437: {
                channel = 6;
                break;
            }
            case 2442: {
                channel = 7;
                break;
            }
            case 2447: {
                channel = 8;
                break;
            }
            case 2452: {
                channel = 9;
                break;
            }
            case 2457: {
                channel = 10;
                break;
            }
            case 2462: {
                channel = 11;
                break;
            }
            case 2467: {
                channel = 12;
                break;
            }
            case 2472: {
                channel = 13;
                break;
            }
            case 2484: {
                channel = 14;
                break;
            }
            case 5745: {
                channel = 149;
                break;
            }
            case 5765: {
                channel = 153;
                break;
            }
            case 5785: {
                channel = 157;
                break;
            }
            case 5805: {
                channel = 161;
                break;
            }
            case 5825: {
                channel = 165;
                break;
            }
        }
        return channel;
    }

    public static String getSecurity(String capabilities) {
        ArrayList<String> list = new ArrayList<String>();
        if (capabilities.contains("WEP") || capabilities.contains("wep")) {
            list.add("WEP");
        }
        if (capabilities.contains("WPA") || capabilities.contains("wpa")) {
            list.add("WPA");
        }
        if (capabilities.contains("WPA2") || capabilities.contains("wpa2")) {
            list.add("WPA2");
        }
        return list.isEmpty() ? "" : list.toString();
    }

    public static boolean is24GHz(int freq) {
        return freq > 2400 && freq < 2500;
    }

    public static boolean is5GHz(int freq) {
        return freq > 4900 && freq < 5900;
    }

    public static String wifiType(int freq) {
        if (WiFiUtil.is24GHz(freq)) {
            return "2.4G";
        }
        if (WiFiUtil.is5GHz(freq)) {
            return "5G";
        }
        return "";
    }
}

