/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.utils;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.util.Log;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class SignatureUtil {
    private static final String TAG = "SignatureUtil";
    private static final String KEYSTORE_SHA1 = "6B661591F2895596DA9745C1D3491B5693588471";
    private static final String KEYSTORE_SHA256 = "D9B61BCF70E7CB26435C377EF585C983A1615447ACAA83A5A407CE7FAFDCB8B2";

    public static boolean checkSignature(Context context) {
        PackageManager pm = context.getPackageManager();
        try {
            PackageInfo packageInfo = pm.getPackageInfo(context.getPackageName(), 64);
            Signature[] signatures = packageInfo.signatures;
            if (signatures != null && signatures.length > 0) {
                for (Signature signature : signatures) {
                    String certHashSha1 = SignatureUtil.bytesToHexString(SignatureUtil.getCertHash(signature, "SHA-1")).toUpperCase();
                    String certHashSha256 = SignatureUtil.bytesToHexString(SignatureUtil.getCertHash(signature, "SHA-256")).toUpperCase();
                    Log.d((String)TAG, (String)("SHA1: " + certHashSha1 + "\nSHA256: " + certHashSha256));
                    if (!KEYSTORE_SHA1.equals(certHashSha1) || !KEYSTORE_SHA256.equals(certHashSha256)) continue;
                    return true;
                }
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return false;
    }

    private static byte[] getCertHash(Signature signature, String algo) {
        try {
            MessageDigest md = MessageDigest.getInstance(algo);
            return md.digest(signature.toByteArray());
        }
        catch (NoSuchAlgorithmException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static String bytesToHexString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        StringBuilder ret = new StringBuilder(2 * bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            int b = 0xF & bytes[i] >> 4;
            ret.append("0123456789abcdef".charAt(b));
            b = 0xF & bytes[i];
            ret.append("0123456789abcdef".charAt(b));
        }
        return ret.toString();
    }
}

