/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.utils;

import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.provider.Settings;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.widget.Toast;
import com.komect.network.komectinnet.utils.StringUtil;

public class PermissionUtil {
    private static final String ENABLED_NOTIFICATION_LISTENERS = "enabled_notification_listeners";

    public static boolean isLacksPermissions(Context context, String ... permissions) {
        for (String permission2 : permissions) {
            if (ContextCompat.checkSelfPermission((Context)context, (String)permission2) == 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isNotificationListenersEnabled(Context context) {
        String pkgName = context.getPackageName();
        String flat = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)ENABLED_NOTIFICATION_LISTENERS);
        if (!TextUtils.isEmpty((CharSequence)flat)) {
            String[] names = flat.split(":");
            for (int i = 0; i < names.length; ++i) {
                ComponentName cn = ComponentName.unflattenFromString((String)names[i]);
                if (cn == null || !StringUtil.equals(pkgName, cn.getPackageName())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean gotoNotificationAccessSetting(Context context) {
        try {
            Intent intent = new Intent("android.settings.ACTION_NOTIFICATION_LISTENER_SETTINGS");
            intent.addFlags(0x10000000);
            context.startActivity(intent);
            return true;
        }
        catch (ActivityNotFoundException e) {
            try {
                Intent intent = new Intent();
                intent.addFlags(0x10000000);
                ComponentName cn = new ComponentName("com.android.settings", "com.android.settings.Settings$NotificationAccessSettingsActivity");
                intent.setComponent(cn);
                intent.putExtra(":settings:show_fragment", "NotificationAccessSettings");
                context.startActivity(intent);
                return true;
            }
            catch (Exception e1) {
                e1.printStackTrace();
                Toast.makeText((Context)context, (CharSequence)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u624b\u673a\u6682\u4e0d\u652f\u6301\u8be5\u529f\u80fd", (int)0).show();
                e.printStackTrace();
                return false;
            }
        }
    }
}

