/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.litepal.util;

import android.content.SharedPreferences;
import android.text.TextUtils;
import com.komect.network.litepal.LitePalApplication;

public class SharedUtil {
    private static final String VERSION = "litepal_version";
    private static final String LITEPAL_PREPS = "litepal_prefs";

    public static void updateVersion(String extraKeyName, int newVersion) {
        SharedPreferences.Editor sEditor = LitePalApplication.getContext().getSharedPreferences(LITEPAL_PREPS, 0).edit();
        if (TextUtils.isEmpty((CharSequence)extraKeyName)) {
            sEditor.putInt(VERSION, newVersion);
        } else {
            if (extraKeyName.endsWith(".db")) {
                extraKeyName = extraKeyName.replace(".db", "");
            }
            sEditor.putInt("litepal_version_" + extraKeyName, newVersion);
        }
        sEditor.apply();
    }

    public static int getLastVersion(String extraKeyName) {
        SharedPreferences sPref = LitePalApplication.getContext().getSharedPreferences(LITEPAL_PREPS, 0);
        if (TextUtils.isEmpty((CharSequence)extraKeyName)) {
            return sPref.getInt(VERSION, 0);
        }
        if (extraKeyName.endsWith(".db")) {
            extraKeyName = extraKeyName.replace(".db", "");
        }
        return sPref.getInt("litepal_version_" + extraKeyName, 0);
    }

    public static void removeVersion(String extraKeyName) {
        SharedPreferences.Editor sEditor = LitePalApplication.getContext().getSharedPreferences(LITEPAL_PREPS, 0).edit();
        if (TextUtils.isEmpty((CharSequence)extraKeyName)) {
            sEditor.remove(VERSION);
        } else {
            if (extraKeyName.endsWith(".db")) {
                extraKeyName = extraKeyName.replace(".db", "");
            }
            sEditor.remove("litepal_version_" + extraKeyName);
        }
        sEditor.apply();
    }
}

