/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.litepal.util;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import com.komect.network.litepal.exceptions.DatabaseGenerateException;
import com.komect.network.litepal.tablemanager.model.ColumnModel;
import com.komect.network.litepal.tablemanager.model.TableModel;
import com.komect.network.litepal.util.BaseUtility;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DBUtility {
    private static final String TAG = "DBUtility";
    private static final String SQLITE_KEYWORDS = ",abort,add,after,all,alter,and,as,asc,autoincrement,before,begin,between,by,cascade,check,collate,column,commit,conflict,constraint,create,cross,database,deferrable,deferred,delete,desc,distinct,drop,each,end,escape,except,exclusive,exists,foreign,from,glob,group,having,in,index,inner,insert,intersect,into,is,isnull,join,like,limit,match,natural,not,notnull,null,of,offset,on,or,order,outer,plan,pragma,primary,query,raise,references,regexp,reindex,release,rename,replace,restrict,right,rollback,row,savepoint,select,set,table,temp,temporary,then,to,transaction,trigger,union,unique,update,using,vacuum,values,view,virtual,when,where,";
    private static final String KEYWORDS_COLUMN_SUFFIX = "_lpcolumn";
    private static final String REG_OPERATOR = "\\s*(=|!=|<>|<|>)";
    private static final String REG_FUZZY = "\\s+(not\\s+)?(like|between)\\s+";
    private static final String REG_COLLECTION = "\\s+(not\\s+)?(in)\\s*\\(";

    private DBUtility() {
    }

    public static String getTableNameByClassName(String className) {
        if (!TextUtils.isEmpty((CharSequence)className)) {
            if ('.' == className.charAt(className.length() - 1)) {
                return null;
            }
            return className.substring(className.lastIndexOf(".") + 1);
        }
        return null;
    }

    public static List<String> getTableNameListByClassNameList(List<String> classNames) {
        ArrayList<String> tableNames = new ArrayList<String>();
        if (classNames != null && !classNames.isEmpty()) {
            for (String className : classNames) {
                tableNames.add(DBUtility.getTableNameByClassName(className));
            }
        }
        return tableNames;
    }

    public static String getTableNameByForeignColumn(String foreignColumnName) {
        if (!TextUtils.isEmpty((CharSequence)foreignColumnName)) {
            if (foreignColumnName.toLowerCase(Locale.US).endsWith("_id")) {
                return foreignColumnName.substring(0, foreignColumnName.length() - "_id".length());
            }
            return null;
        }
        return null;
    }

    public static String getIntermediateTableName(String tableName, String associatedTableName) {
        if (!TextUtils.isEmpty((CharSequence)tableName) && !TextUtils.isEmpty((CharSequence)associatedTableName)) {
            String intermediateTableName = tableName.toLowerCase(Locale.US).compareTo(associatedTableName.toLowerCase(Locale.US)) <= 0 ? tableName + "_" + associatedTableName : associatedTableName + "_" + tableName;
            return intermediateTableName;
        }
        return null;
    }

    public static String getGenericTableName(String className, String fieldName) {
        String tableName = DBUtility.getTableNameByClassName(className);
        return BaseUtility.changeCase(tableName + "_" + fieldName);
    }

    public static String getGenericValueIdColumnName(String className) {
        return BaseUtility.changeCase(DBUtility.getTableNameByClassName(className) + "_id");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isIntermediateTable(String tableName, SQLiteDatabase db) {
        block10: {
            if (!TextUtils.isEmpty((CharSequence)tableName) && tableName.matches("[0-9a-zA-Z]+_[0-9a-zA-Z]+")) {
                try (Cursor cursor = null;){
                    cursor = db.query("table_schema", null, null, null, null, null, null);
                    if (!cursor.moveToFirst()) break block10;
                    do {
                        String tableNameDB;
                        if (!tableName.equalsIgnoreCase(tableNameDB = cursor.getString(cursor.getColumnIndexOrThrow("name")))) continue;
                        int tableType = cursor.getInt(cursor.getColumnIndexOrThrow("type"));
                        if (tableType == 1) {
                            boolean bl = true;
                            return bl;
                        }
                        break;
                    } while (cursor.moveToNext());
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isGenericTable(String tableName, SQLiteDatabase db) {
        block10: {
            if (!TextUtils.isEmpty((CharSequence)tableName) && tableName.matches("[0-9a-zA-Z]+_[0-9a-zA-Z]+")) {
                try (Cursor cursor = null;){
                    cursor = db.query("table_schema", null, null, null, null, null, null);
                    if (!cursor.moveToFirst()) break block10;
                    do {
                        String tableNameDB;
                        if (!tableName.equalsIgnoreCase(tableNameDB = cursor.getString(cursor.getColumnIndexOrThrow("name")))) continue;
                        int tableType = cursor.getInt(cursor.getColumnIndexOrThrow("type"));
                        if (tableType == 2) {
                            boolean bl = true;
                            return bl;
                        }
                        break;
                    } while (cursor.moveToNext());
                }
            }
        }
        return false;
    }

    public static boolean isTableExists(String tableName, SQLiteDatabase db) {
        boolean exist;
        try {
            exist = BaseUtility.containsIgnoreCases(DBUtility.findAllTableNames(db), tableName);
        }
        catch (Exception e) {
            e.printStackTrace();
            exist = false;
        }
        return exist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isColumnExists(String columnName, String tableName, SQLiteDatabase db) {
        boolean exist;
        block8: {
            if (TextUtils.isEmpty((CharSequence)columnName) || TextUtils.isEmpty((CharSequence)tableName)) {
                return false;
            }
            exist = false;
            try (Cursor cursor = null;){
                String checkingColumnSQL = "pragma table_info(" + tableName + ")";
                cursor = db.rawQuery(checkingColumnSQL, null);
                if (!cursor.moveToFirst()) break block8;
                do {
                    String name;
                    if (!columnName.equalsIgnoreCase(name = cursor.getString(cursor.getColumnIndexOrThrow("name")))) continue;
                    exist = true;
                    break;
                } while (cursor.moveToNext());
            }
        }
        return exist;
    }

    public static List<String> findAllTableNames(SQLiteDatabase db) {
        ArrayList<String> tableNames = new ArrayList<String>();
        try (Cursor cursor = null;){
            cursor = db.rawQuery("select * from sqlite_master where type = ?", new String[]{"table"});
            if (cursor.moveToFirst()) {
                do {
                    String tableName;
                    if (tableNames.contains(tableName = cursor.getString(cursor.getColumnIndexOrThrow("tbl_name")))) continue;
                    tableNames.add(tableName);
                } while (cursor.moveToNext());
            }
        }
        return tableNames;
    }

    public static TableModel findPragmaTableInfo(String tableName, SQLiteDatabase db) {
        if (DBUtility.isTableExists(tableName, db)) {
            List<String> uniqueColumns = DBUtility.findUniqueColumns(tableName, db);
            TableModel tableModelDB = new TableModel();
            tableModelDB.setTableName(tableName);
            String checkingColumnSQL = "pragma table_info(" + tableName + ")";
            try (Cursor cursor = null;){
                cursor = db.rawQuery(checkingColumnSQL, null);
                if (cursor.moveToFirst()) {
                    do {
                        ColumnModel columnModel = new ColumnModel();
                        String name = cursor.getString(cursor.getColumnIndexOrThrow("name"));
                        String type = cursor.getString(cursor.getColumnIndexOrThrow("type"));
                        boolean nullable = cursor.getInt(cursor.getColumnIndexOrThrow("notnull")) != 1;
                        boolean unique = uniqueColumns.contains(name);
                        String defaultValue = cursor.getString(cursor.getColumnIndexOrThrow("dflt_value"));
                        columnModel.setColumnName(name);
                        columnModel.setColumnType(type);
                        columnModel.setNullable(nullable);
                        columnModel.setUnique(unique);
                        defaultValue = defaultValue != null ? defaultValue.replace("'", "") : "";
                        columnModel.setDefaultValue(defaultValue);
                        tableModelDB.addColumnModel(columnModel);
                    } while (cursor.moveToNext());
                }
            }
            return tableModelDB;
        }
        throw new DatabaseGenerateException("Table doesn't exist when executing " + tableName);
    }

    public static List<String> findUniqueColumns(String tableName, SQLiteDatabase db) {
        ArrayList<String> columns = new ArrayList<String>();
        Cursor cursor = null;
        Cursor innerCursor = null;
        try {
            cursor = db.rawQuery("pragma index_list(" + tableName + ")", null);
            if (cursor.moveToFirst()) {
                do {
                    int unique;
                    if ((unique = cursor.getInt(cursor.getColumnIndexOrThrow("unique"))) != 1) continue;
                    String name = cursor.getString(cursor.getColumnIndexOrThrow("name"));
                    innerCursor = db.rawQuery("pragma index_info(" + name + ")", null);
                    if (!innerCursor.moveToFirst()) continue;
                    String columnName = innerCursor.getString(innerCursor.getColumnIndexOrThrow("name"));
                    columns.add(columnName);
                } while (cursor.moveToNext());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DatabaseGenerateException(e.getMessage());
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            if (innerCursor != null) {
                innerCursor.close();
            }
        }
        return columns;
    }

    public static boolean isFieldNameConflictWithSQLiteKeywords(String fieldName) {
        String fieldNameWithComma;
        return !TextUtils.isEmpty((CharSequence)fieldName) && SQLITE_KEYWORDS.contains(fieldNameWithComma = "," + fieldName.toLowerCase(Locale.US) + ",");
    }

    public static String convertToValidColumnName(String columnName) {
        if (DBUtility.isFieldNameConflictWithSQLiteKeywords(columnName)) {
            return columnName + KEYWORDS_COLUMN_SUFFIX;
        }
        return columnName;
    }

    public static String convertWhereClauseToColumnName(String whereClause) {
        try {
            StringBuffer convertedWhereClause = new StringBuffer();
            Pattern p = Pattern.compile("(\\w+\\s*(=|!=|<>|<|>)|\\w+\\s+(not\\s+)?(like|between)\\s+|\\w+\\s+(not\\s+)?(in)\\s*\\()");
            Matcher m = p.matcher(whereClause);
            while (m.find()) {
                String matches = m.group();
                String column = matches.replaceAll("(\\s*(=|!=|<>|<|>)|\\s+(not\\s+)?(like|between)\\s+|\\s+(not\\s+)?(in)\\s*\\()", "");
                String rest = matches.replace(column, "");
                column = DBUtility.convertToValidColumnName(column);
                m.appendReplacement(convertedWhereClause, column + rest);
            }
            m.appendTail(convertedWhereClause);
            return convertedWhereClause.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return whereClause;
        }
    }

    public static String[] convertSelectClauseToValidNames(String[] columns) {
        if (columns != null && columns.length > 0) {
            String[] convertedColumns = new String[columns.length];
            for (int i = 0; i < columns.length; ++i) {
                convertedColumns[i] = DBUtility.convertToValidColumnName(columns[i]);
            }
            return convertedColumns;
        }
        return null;
    }

    public static String convertOrderByClauseToValidName(String orderBy) {
        if (!TextUtils.isEmpty((CharSequence)orderBy)) {
            if ((orderBy = orderBy.trim().toLowerCase(Locale.US)).contains(",")) {
                String[] orderByItems = orderBy.split(",");
                StringBuilder builder = new StringBuilder();
                boolean needComma = false;
                for (String orderByItem : orderByItems) {
                    if (needComma) {
                        builder.append(",");
                    }
                    builder.append(DBUtility.convertOrderByItem(orderByItem));
                    needComma = true;
                }
                orderBy = builder.toString();
            } else {
                orderBy = DBUtility.convertOrderByItem(orderBy);
            }
            return orderBy;
        }
        return null;
    }

    private static String convertOrderByItem(String orderByItem) {
        String column = null;
        String append = null;
        if (orderByItem.endsWith("asc")) {
            column = orderByItem.replace("asc", "").trim();
            append = " asc";
        } else if (orderByItem.endsWith("desc")) {
            column = orderByItem.replace("desc", "").trim();
            append = " desc";
        } else {
            column = orderByItem;
            append = "";
        }
        return DBUtility.convertToValidColumnName(column) + append;
    }
}

