/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.litepal.util;

import android.content.res.AssetManager;
import android.text.TextUtils;
import com.komect.network.litepal.LitePalApplication;
import com.komect.network.litepal.exceptions.DataSupportException;
import com.komect.network.litepal.parser.LitePalAttr;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Locale;

public class BaseUtility {
    private BaseUtility() {
    }

    public static String changeCase(String string2) {
        if (string2 != null) {
            LitePalAttr litePalAttr = LitePalAttr.getInstance();
            String cases = litePalAttr.getCases();
            if ("keep".equals(cases)) {
                return string2;
            }
            if ("upper".equals(cases)) {
                return string2.toUpperCase(Locale.US);
            }
            return string2.toLowerCase(Locale.US);
        }
        return null;
    }

    public static boolean containsIgnoreCases(Collection<String> collection, String string2) {
        if (collection == null) {
            return false;
        }
        if (string2 == null) {
            return collection.contains(null);
        }
        boolean contains = false;
        for (String element : collection) {
            if (!string2.equalsIgnoreCase(element)) continue;
            contains = true;
            break;
        }
        return contains;
    }

    public static String capitalize(String string2) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            return string2.substring(0, 1).toUpperCase(Locale.US) + string2.substring(1);
        }
        return string2 == null ? null : "";
    }

    public static int count(String string2, String mark) {
        if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)mark)) {
            int count = 0;
            int index = string2.indexOf(mark);
            while (index != -1) {
                ++count;
                string2 = string2.substring(index + mark.length());
                index = string2.indexOf(mark);
            }
            return count;
        }
        return 0;
    }

    public static void checkConditionsCorrect(String ... conditions) {
        String whereClause;
        int placeHolderSize;
        int conditionsSize;
        if (conditions != null && (conditionsSize = conditions.length) > 0 && conditionsSize != (placeHolderSize = BaseUtility.count(whereClause = conditions[0], "?")) + 1) {
            throw new DataSupportException("The parameters in conditions are incorrect.");
        }
    }

    public static boolean isFieldTypeSupported(String fieldType) {
        if ("boolean".equals(fieldType) || "java.lang.Boolean".equals(fieldType)) {
            return true;
        }
        if ("float".equals(fieldType) || "java.lang.Float".equals(fieldType)) {
            return true;
        }
        if ("double".equals(fieldType) || "java.lang.Double".equals(fieldType)) {
            return true;
        }
        if ("int".equals(fieldType) || "java.lang.Integer".equals(fieldType)) {
            return true;
        }
        if ("long".equals(fieldType) || "java.lang.Long".equals(fieldType)) {
            return true;
        }
        if ("short".equals(fieldType) || "java.lang.Short".equals(fieldType)) {
            return true;
        }
        if ("char".equals(fieldType) || "java.lang.Character".equals(fieldType)) {
            return true;
        }
        if ("[B".equals(fieldType) || "[Ljava.lang.Byte;".equals(fieldType)) {
            return true;
        }
        return "java.lang.String".equals(fieldType) || "java.util.Date".equals(fieldType);
    }

    public static boolean isGenericTypeSupported(String genericType) {
        if ("java.lang.String".equals(genericType)) {
            return true;
        }
        if ("java.lang.Integer".equals(genericType)) {
            return true;
        }
        if ("java.lang.Float".equals(genericType)) {
            return true;
        }
        if ("java.lang.Double".equals(genericType)) {
            return true;
        }
        if ("java.lang.Long".equals(genericType)) {
            return true;
        }
        if ("java.lang.Short".equals(genericType)) {
            return true;
        }
        if ("java.lang.Boolean".equals(genericType)) {
            return true;
        }
        return "java.lang.Character".equals(genericType);
    }

    public static boolean isLitePalXMLExists() {
        try {
            AssetManager assetManager = LitePalApplication.getContext().getAssets();
            String[] fileNames = assetManager.list("");
            if (fileNames != null && fileNames.length > 0) {
                for (String fileName : fileNames) {
                    if (!"litepal.xml".equalsIgnoreCase(fileName)) continue;
                    return true;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isClassAndMethodExist(String className, String methodName) {
        try {
            Method[] methods;
            Class<?> clazz = Class.forName(className);
            for (Method method : methods = clazz.getMethods()) {
                if (!methodName.equals(method.getName())) continue;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }
}

