/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.litepal.tablemanager;

import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import com.komect.network.litepal.crud.model.AssociationsInfo;
import com.komect.network.litepal.tablemanager.AssociationUpdater;
import com.komect.network.litepal.tablemanager.model.ColumnModel;
import com.komect.network.litepal.tablemanager.model.TableModel;
import com.komect.network.litepal.util.DBUtility;
import com.komect.network.litepal.util.LogUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class Upgrader
extends AssociationUpdater {
    protected TableModel mTableModel;
    protected TableModel mTableModelDB;
    private boolean hasConstraintChanged;

    @Override
    protected void createOrUpgradeTable(SQLiteDatabase db, boolean force) {
        this.mDb = db;
        Iterator<TableModel> iterator = this.getAllTableModels().iterator();
        while (iterator.hasNext()) {
            TableModel tableModel;
            this.mTableModel = tableModel = iterator.next();
            this.mTableModelDB = this.getTableModelFromDB(tableModel.getTableName());
            LogUtil.d("AssociationUpdater", "createOrUpgradeTable: model is " + this.mTableModel.getTableName());
            this.upgradeTable();
        }
    }

    private void upgradeTable() {
        if (this.hasNewUniqueOrNotNullColumn()) {
            this.createOrUpgradeTable(this.mTableModel, this.mDb, true);
            Collection<AssociationsInfo> associationsInfo = this.getAssociationInfo(this.mTableModel.getClassName());
            for (AssociationsInfo info : associationsInfo) {
                if (info.getAssociationType() != 2 && info.getAssociationType() != 1 || !info.getClassHoldsForeignKey().equalsIgnoreCase(this.mTableModel.getClassName())) continue;
                String associatedTableName = DBUtility.getTableNameByClassName(info.getAssociatedClassName());
                this.addForeignKeyColumn(this.mTableModel.getTableName(), associatedTableName, this.mTableModel.getTableName(), this.mDb);
            }
        } else {
            this.hasConstraintChanged = false;
            this.removeColumns(this.findColumnsToRemove());
            this.addColumns(this.findColumnsToAdd());
            this.changeColumnsType(this.findColumnTypesToChange());
            this.changeColumnsConstraints();
        }
    }

    private boolean hasNewUniqueOrNotNullColumn() {
        List<ColumnModel> columnModelList = this.mTableModel.getColumnModels();
        for (ColumnModel columnModel : columnModelList) {
            ColumnModel columnModelDB = this.mTableModelDB.getColumnModelByName(columnModel.getColumnName());
            if (columnModel.isUnique() && (columnModelDB == null || !columnModelDB.isUnique())) {
                return true;
            }
            if (columnModelDB == null || columnModel.isNullable() || !columnModelDB.isNullable()) continue;
            return true;
        }
        return false;
    }

    private List<ColumnModel> findColumnsToAdd() {
        ArrayList<ColumnModel> columnsToAdd = new ArrayList<ColumnModel>();
        for (ColumnModel columnModel : this.mTableModel.getColumnModels()) {
            String columnName = columnModel.getColumnName();
            if (this.mTableModelDB.containsColumn(columnName)) continue;
            columnsToAdd.add(columnModel);
        }
        return columnsToAdd;
    }

    private List<String> findColumnsToRemove() {
        String tableName = this.mTableModel.getTableName();
        ArrayList<String> removeColumns = new ArrayList<String>();
        List<ColumnModel> columnModelList = this.mTableModelDB.getColumnModels();
        for (ColumnModel columnModel : columnModelList) {
            String dbColumnName = columnModel.getColumnName();
            if (!this.isNeedToRemove(dbColumnName)) continue;
            removeColumns.add(dbColumnName);
        }
        LogUtil.d("AssociationUpdater", "remove columns from " + tableName + " >> " + removeColumns);
        return removeColumns;
    }

    private List<ColumnModel> findColumnTypesToChange() {
        ArrayList<ColumnModel> columnsToChangeType = new ArrayList<ColumnModel>();
        for (ColumnModel columnModelDB : this.mTableModelDB.getColumnModels()) {
            for (ColumnModel columnModel : this.mTableModel.getColumnModels()) {
                if (!columnModelDB.getColumnName().equalsIgnoreCase(columnModel.getColumnName())) continue;
                if (!(columnModelDB.getColumnType().equalsIgnoreCase(columnModel.getColumnType()) || columnModel.getColumnType().equalsIgnoreCase("blob") && TextUtils.isEmpty((CharSequence)columnModelDB.getColumnType()))) {
                    columnsToChangeType.add(columnModel);
                }
                if (this.hasConstraintChanged) continue;
                LogUtil.d("AssociationUpdater", "default value db is:" + columnModelDB.getDefaultValue() + ", default value is:" + columnModel.getDefaultValue());
                if (columnModelDB.isNullable() == columnModel.isNullable() && columnModelDB.getDefaultValue().equalsIgnoreCase(columnModel.getDefaultValue()) && (!columnModelDB.isUnique() || columnModel.isUnique())) continue;
                this.hasConstraintChanged = true;
            }
        }
        return columnsToChangeType;
    }

    private boolean isNeedToRemove(String columnName) {
        return this.isRemovedFromClass(columnName) && !this.isIdColumn(columnName) && !this.isForeignKeyColumn(this.mTableModel, columnName);
    }

    private boolean isRemovedFromClass(String columnName) {
        return !this.mTableModel.containsColumn(columnName);
    }

    private String generateAddColumnSQL(ColumnModel columnModel) {
        return this.generateAddColumnSQL(this.mTableModel.getTableName(), columnModel);
    }

    private List<String> getAddColumnSQLs(List<ColumnModel> columnModelList) {
        ArrayList<String> sqls = new ArrayList<String>();
        for (ColumnModel columnModel : columnModelList) {
            sqls.add(this.generateAddColumnSQL(columnModel));
        }
        return sqls;
    }

    private void removeColumns(List<String> removeColumnNames) {
        LogUtil.d("AssociationUpdater", "do removeColumns " + removeColumnNames);
        this.removeColumns(removeColumnNames, this.mTableModel.getTableName());
        for (String columnName : removeColumnNames) {
            this.mTableModelDB.removeColumnModelByName(columnName);
        }
    }

    private void addColumns(List<ColumnModel> columnModelList) {
        LogUtil.d("AssociationUpdater", "do addColumn");
        this.execute(this.getAddColumnSQLs(columnModelList), this.mDb);
        for (ColumnModel columnModel : columnModelList) {
            this.mTableModelDB.addColumnModel(columnModel);
        }
    }

    private void changeColumnsType(List<ColumnModel> columnModelList) {
        LogUtil.d("AssociationUpdater", "do changeColumnsType");
        ArrayList<String> columnNames = new ArrayList<String>();
        if (columnModelList != null && !columnModelList.isEmpty()) {
            for (ColumnModel columnModel : columnModelList) {
                columnNames.add(columnModel.getColumnName());
            }
        }
        this.removeColumns(columnNames);
        this.addColumns(columnModelList);
    }

    private void changeColumnsConstraints() {
        if (this.hasConstraintChanged) {
            LogUtil.d("AssociationUpdater", "do changeColumnsConstraints");
            this.execute(this.getChangeColumnsConstraintsSQL(), this.mDb);
        }
    }

    private List<String> getChangeColumnsConstraintsSQL() {
        String alterToTempTableSQL = this.generateAlterToTempTableSQL(this.mTableModel.getTableName());
        String createNewTableSQL = this.generateCreateTableSQL(this.mTableModel);
        List<String> addForeignKeySQLs = this.generateAddForeignKeySQL();
        String dataMigrationSQL = this.generateDataMigrationSQL(this.mTableModelDB);
        String dropTempTableSQL = this.generateDropTempTableSQL(this.mTableModel.getTableName());
        ArrayList<String> sqls = new ArrayList<String>();
        sqls.add(alterToTempTableSQL);
        sqls.add(createNewTableSQL);
        sqls.addAll(addForeignKeySQLs);
        sqls.add(dataMigrationSQL);
        sqls.add(dropTempTableSQL);
        LogUtil.d("AssociationUpdater", "generateChangeConstraintSQL >> ");
        for (String sql : sqls) {
            LogUtil.d("AssociationUpdater", sql);
        }
        LogUtil.d("AssociationUpdater", "<< generateChangeConstraintSQL");
        return sqls;
    }

    private List<String> generateAddForeignKeySQL() {
        ArrayList<String> addForeignKeySQLs = new ArrayList<String>();
        List<String> foreignKeyColumns = this.getForeignKeyColumns(this.mTableModel);
        for (String foreignKeyColumn : foreignKeyColumns) {
            if (this.mTableModel.containsColumn(foreignKeyColumn)) continue;
            ColumnModel columnModel = new ColumnModel();
            columnModel.setColumnName(foreignKeyColumn);
            columnModel.setColumnType("integer");
            addForeignKeySQLs.add(this.generateAddColumnSQL(this.mTableModel.getTableName(), columnModel));
        }
        return addForeignKeySQLs;
    }
}

