/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.litepal.tablemanager;

import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import com.komect.network.litepal.LitePalBase;
import com.komect.network.litepal.exceptions.DatabaseGenerateException;
import com.komect.network.litepal.parser.LitePalAttr;
import com.komect.network.litepal.tablemanager.Creator;
import com.komect.network.litepal.tablemanager.Dropper;
import com.komect.network.litepal.tablemanager.Upgrader;
import com.komect.network.litepal.tablemanager.model.AssociationsModel;
import com.komect.network.litepal.tablemanager.model.TableModel;
import com.komect.network.litepal.util.BaseUtility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class Generator
extends LitePalBase {
    public static final String TAG = "Generator";
    private Collection<TableModel> mTableModels;
    private Collection<AssociationsModel> mAllRelationModels;

    protected Collection<TableModel> getAllTableModels() {
        if (this.mTableModels == null) {
            this.mTableModels = new ArrayList<TableModel>();
        }
        if (!this.canUseCache()) {
            this.mTableModels.clear();
            for (String className : LitePalAttr.getInstance().getClassNames()) {
                this.mTableModels.add(this.getTableModel(className));
            }
        }
        return this.mTableModels;
    }

    protected Collection<AssociationsModel> getAllAssociations() {
        if (this.mAllRelationModels == null || this.mAllRelationModels.isEmpty()) {
            this.mAllRelationModels = this.getAssociations(LitePalAttr.getInstance().getClassNames());
        }
        return this.mAllRelationModels;
    }

    protected void execute(List<String> sqls, SQLiteDatabase db) {
        String throwSQL = "";
        try {
            if (sqls != null && !sqls.isEmpty()) {
                for (String sql : sqls) {
                    if (TextUtils.isEmpty((CharSequence)sql)) continue;
                    throwSQL = BaseUtility.changeCase(sql);
                    db.execSQL(throwSQL);
                }
            }
        }
        catch (SQLException e) {
            throw new DatabaseGenerateException("An exception that indicates there was an error with SQL parsing or execution. " + throwSQL);
        }
    }

    private static void addAssociation(SQLiteDatabase db, boolean force) {
        Creator associationsCreator = new Creator();
        associationsCreator.addOrUpdateAssociation(db, force);
    }

    private static void updateAssociations(SQLiteDatabase db) {
        Upgrader associationUpgrader = new Upgrader();
        associationUpgrader.addOrUpdateAssociation(db, false);
    }

    private static void upgradeTables(SQLiteDatabase db) {
        Upgrader upgrader = new Upgrader();
        upgrader.createOrUpgradeTable(db, false);
    }

    private static void create(SQLiteDatabase db, boolean force) {
        Creator creator = new Creator();
        creator.createOrUpgradeTable(db, force);
    }

    private static void drop(SQLiteDatabase db) {
        Dropper dropper = new Dropper();
        dropper.createOrUpgradeTable(db, false);
    }

    private boolean canUseCache() {
        if (this.mTableModels == null) {
            return false;
        }
        return this.mTableModels.size() == LitePalAttr.getInstance().getClassNames().size();
    }

    static void create(SQLiteDatabase db) {
        Generator.create(db, true);
        Generator.addAssociation(db, true);
    }

    static void upgrade(SQLiteDatabase db) {
        Generator.drop(db);
        Generator.create(db, false);
        Generator.updateAssociations(db);
        Generator.upgradeTables(db);
        Generator.addAssociation(db, false);
    }

    protected abstract void createOrUpgradeTable(SQLiteDatabase var1, boolean var2);

    protected abstract void addOrUpdateAssociation(SQLiteDatabase var1, boolean var2);
}

