/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.litepal.tablemanager;

import android.database.sqlite.SQLiteDatabase;
import com.komect.network.litepal.tablemanager.AssociationCreator;
import com.komect.network.litepal.tablemanager.model.TableModel;
import com.komect.network.litepal.util.DBUtility;
import java.util.ArrayList;
import java.util.List;

class Creator
extends AssociationCreator {
    public static final String TAG = "Creator";

    Creator() {
    }

    @Override
    protected void createOrUpgradeTable(SQLiteDatabase db, boolean force) {
        for (TableModel tableModel : this.getAllTableModels()) {
            this.createOrUpgradeTable(tableModel, db, force);
        }
    }

    protected void createOrUpgradeTable(TableModel tableModel, SQLiteDatabase db, boolean force) {
        this.execute(this.getCreateTableSQLs(tableModel, db, force), db);
        this.giveTableSchemaACopy(tableModel.getTableName(), 0, db);
    }

    protected List<String> getCreateTableSQLs(TableModel tableModel, SQLiteDatabase db, boolean force) {
        ArrayList<String> sqls = new ArrayList<String>();
        if (force) {
            sqls.add(this.generateDropTableSQL(tableModel));
            sqls.add(this.generateCreateTableSQL(tableModel));
        } else {
            if (DBUtility.isTableExists(tableModel.getTableName(), db)) {
                return null;
            }
            sqls.add(this.generateCreateTableSQL(tableModel));
        }
        return sqls;
    }

    private String generateDropTableSQL(TableModel tableModel) {
        return this.generateDropTableSQL(tableModel.getTableName());
    }

    String generateCreateTableSQL(TableModel tableModel) {
        return this.generateCreateTableSQL(tableModel.getTableName(), tableModel.getColumnModels(), true);
    }
}

