/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.litepal.tablemanager;

import android.database.sqlite.SQLiteDatabase;
import com.komect.network.litepal.parser.LitePalAttr;
import com.komect.network.litepal.tablemanager.Creator;
import com.komect.network.litepal.tablemanager.model.AssociationsModel;
import com.komect.network.litepal.tablemanager.model.ColumnModel;
import com.komect.network.litepal.tablemanager.model.GenericModel;
import com.komect.network.litepal.tablemanager.model.TableModel;
import com.komect.network.litepal.util.BaseUtility;
import com.komect.network.litepal.util.DBUtility;
import com.komect.network.litepal.util.LogUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class AssociationUpdater
extends Creator {
    public static final String TAG = "AssociationUpdater";
    private Collection<AssociationsModel> mAssociationModels;
    protected SQLiteDatabase mDb;

    @Override
    protected abstract void createOrUpgradeTable(SQLiteDatabase var1, boolean var2);

    @Override
    protected void addOrUpdateAssociation(SQLiteDatabase db, boolean force) {
        this.mAssociationModels = this.getAllAssociations();
        this.mDb = db;
        this.removeAssociations();
    }

    protected List<String> getForeignKeyColumns(TableModel tableModel) {
        ArrayList<String> foreignKeyColumns = new ArrayList<String>();
        List<ColumnModel> columnModelList = this.getTableModelFromDB(tableModel.getTableName()).getColumnModels();
        for (ColumnModel columnModel : columnModelList) {
            String columnName = columnModel.getColumnName();
            if (!this.isForeignKeyColumnFormat(columnModel.getColumnName()) || tableModel.containsColumn(columnName)) continue;
            LogUtil.d(TAG, "getForeignKeyColumnNames >> foreign key column is " + columnName);
            foreignKeyColumns.add(columnName);
        }
        return foreignKeyColumns;
    }

    protected boolean isForeignKeyColumn(TableModel tableModel, String columnName) {
        return BaseUtility.containsIgnoreCases(this.getForeignKeyColumns(tableModel), columnName);
    }

    protected TableModel getTableModelFromDB(String tableName) {
        return DBUtility.findPragmaTableInfo(tableName, this.mDb);
    }

    protected void dropTables(List<String> dropTableNames, SQLiteDatabase db) {
        if (dropTableNames != null && !dropTableNames.isEmpty()) {
            ArrayList<String> dropTableSQLS = new ArrayList<String>();
            for (int i = 0; i < dropTableNames.size(); ++i) {
                dropTableSQLS.add(this.generateDropTableSQL(dropTableNames.get(i)));
            }
            this.execute(dropTableSQLS, db);
        }
    }

    protected void removeColumns(Collection<String> removeColumnNames, String tableName) {
        if (removeColumnNames != null && !removeColumnNames.isEmpty()) {
            this.execute(this.getRemoveColumnSQLs(removeColumnNames, tableName), this.mDb);
        }
    }

    protected void clearCopyInTableSchema(List<String> tableNames) {
        if (tableNames != null && !tableNames.isEmpty()) {
            StringBuilder deleteData = new StringBuilder("delete from ");
            deleteData.append("table_schema").append(" where");
            boolean needOr = false;
            for (String tableName : tableNames) {
                if (needOr) {
                    deleteData.append(" or ");
                }
                needOr = true;
                deleteData.append(" lower(").append("name").append(") ");
                deleteData.append("=").append(" lower('").append(tableName).append("')");
            }
            LogUtil.d(TAG, "clear table schema value sql is " + deleteData);
            ArrayList<String> sqls = new ArrayList<String>();
            sqls.add(deleteData.toString());
            this.execute(sqls, this.mDb);
        }
    }

    private void removeAssociations() {
        this.removeForeignKeyColumns();
        this.removeIntermediateTables();
        this.removeGenericTables();
    }

    private void removeForeignKeyColumns() {
        for (String className : LitePalAttr.getInstance().getClassNames()) {
            TableModel tableModel = this.getTableModel(className);
            this.removeColumns(this.findForeignKeyToRemove(tableModel), tableModel.getTableName());
        }
    }

    private void removeIntermediateTables() {
        List<String> tableNamesToDrop = this.findIntermediateTablesToDrop();
        this.dropTables(tableNamesToDrop, this.mDb);
        this.clearCopyInTableSchema(tableNamesToDrop);
    }

    private void removeGenericTables() {
        List<String> tableNamesToDrop = this.findGenericTablesToDrop();
        this.dropTables(tableNamesToDrop, this.mDb);
        this.clearCopyInTableSchema(tableNamesToDrop);
    }

    private List<String> findForeignKeyToRemove(TableModel tableModel) {
        ArrayList<String> removeRelations = new ArrayList<String>();
        List<String> foreignKeyColumns = this.getForeignKeyColumns(tableModel);
        String selfTableName = tableModel.getTableName();
        for (String foreignKeyColumn : foreignKeyColumns) {
            String associatedTableName = DBUtility.getTableNameByForeignColumn(foreignKeyColumn);
            if (!this.shouldDropForeignKey(selfTableName, associatedTableName)) continue;
            removeRelations.add(foreignKeyColumn);
        }
        LogUtil.d(TAG, "findForeignKeyToRemove >> " + tableModel.getTableName() + " " + removeRelations);
        return removeRelations;
    }

    private List<String> findIntermediateTablesToDrop() {
        ArrayList<String> intermediateTables = new ArrayList<String>();
        for (String tableName : DBUtility.findAllTableNames(this.mDb)) {
            if (!DBUtility.isIntermediateTable(tableName, this.mDb)) continue;
            boolean dropIntermediateTable = true;
            for (AssociationsModel associationModel : this.mAssociationModels) {
                String intermediateTableName;
                if (associationModel.getAssociationType() != 3 || !tableName.equalsIgnoreCase(intermediateTableName = DBUtility.getIntermediateTableName(associationModel.getTableName(), associationModel.getAssociatedTableName()))) continue;
                dropIntermediateTable = false;
            }
            if (!dropIntermediateTable) continue;
            intermediateTables.add(tableName);
        }
        LogUtil.d(TAG, "findIntermediateTablesToDrop >> " + intermediateTables);
        return intermediateTables;
    }

    private List<String> findGenericTablesToDrop() {
        ArrayList<String> genericTablesToDrop = new ArrayList<String>();
        for (String tableName : DBUtility.findAllTableNames(this.mDb)) {
            if (!DBUtility.isGenericTable(tableName, this.mDb)) continue;
            boolean dropGenericTable = true;
            for (GenericModel genericModel : this.getGenericModels()) {
                String genericTableName = genericModel.getTableName();
                if (!tableName.equalsIgnoreCase(genericTableName)) continue;
                dropGenericTable = false;
            }
            if (!dropGenericTable) continue;
            genericTablesToDrop.add(tableName);
        }
        return genericTablesToDrop;
    }

    protected String generateAlterToTempTableSQL(String tableName) {
        StringBuilder sql = new StringBuilder();
        sql.append("alter table ").append(tableName).append(" rename to ").append(this.getTempTableName(tableName));
        return sql.toString();
    }

    private String generateCreateNewTableSQL(Collection<String> removeColumnNames, TableModel tableModel) {
        for (String removeColumnName : removeColumnNames) {
            tableModel.removeColumnModelByName(removeColumnName);
        }
        return this.generateCreateTableSQL(tableModel);
    }

    protected String generateDataMigrationSQL(TableModel tableModel) {
        String tableName = tableModel.getTableName();
        List<ColumnModel> columnModels = tableModel.getColumnModels();
        if (!columnModels.isEmpty()) {
            StringBuilder sql = new StringBuilder();
            sql.append("insert into ").append(tableName).append("(");
            boolean needComma = false;
            for (ColumnModel columnModel : columnModels) {
                if (needComma) {
                    sql.append(", ");
                }
                needComma = true;
                sql.append(columnModel.getColumnName());
            }
            sql.append(") ");
            sql.append("select ");
            needComma = false;
            for (ColumnModel columnModel : columnModels) {
                if (needComma) {
                    sql.append(", ");
                }
                needComma = true;
                sql.append(columnModel.getColumnName());
            }
            sql.append(" from ").append(this.getTempTableName(tableName));
            return sql.toString();
        }
        return null;
    }

    protected String generateDropTempTableSQL(String tableName) {
        return this.generateDropTableSQL(this.getTempTableName(tableName));
    }

    protected String getTempTableName(String tableName) {
        return tableName + "_temp";
    }

    private List<String> getRemoveColumnSQLs(Collection<String> removeColumnNames, String tableName) {
        TableModel tableModelFromDB = this.getTableModelFromDB(tableName);
        String alterToTempTableSQL = this.generateAlterToTempTableSQL(tableName);
        LogUtil.d(TAG, "generateRemoveColumnSQL >> " + alterToTempTableSQL);
        String createNewTableSQL = this.generateCreateNewTableSQL(removeColumnNames, tableModelFromDB);
        LogUtil.d(TAG, "generateRemoveColumnSQL >> " + createNewTableSQL);
        String dataMigrationSQL = this.generateDataMigrationSQL(tableModelFromDB);
        LogUtil.d(TAG, "generateRemoveColumnSQL >> " + dataMigrationSQL);
        String dropTempTableSQL = this.generateDropTempTableSQL(tableName);
        LogUtil.d(TAG, "generateRemoveColumnSQL >> " + dropTempTableSQL);
        ArrayList<String> sqls = new ArrayList<String>();
        sqls.add(alterToTempTableSQL);
        sqls.add(createNewTableSQL);
        sqls.add(dataMigrationSQL);
        sqls.add(dropTempTableSQL);
        return sqls;
    }

    private boolean shouldDropForeignKey(String selfTableName, String associatedTableName) {
        for (AssociationsModel associationModel : this.mAssociationModels) {
            if (!(associationModel.getAssociationType() == 1 ? selfTableName.equalsIgnoreCase(associationModel.getTableHoldsForeignKey()) && (associationModel.getTableName().equalsIgnoreCase(selfTableName) ? this.isRelationCorrect(associationModel, selfTableName, associatedTableName) : associationModel.getAssociatedTableName().equalsIgnoreCase(selfTableName) && this.isRelationCorrect(associationModel, associatedTableName, selfTableName)) : associationModel.getAssociationType() == 2 && this.isRelationCorrect(associationModel, associatedTableName, selfTableName))) continue;
            return false;
        }
        return true;
    }

    private boolean isRelationCorrect(AssociationsModel associationModel, String tableName1, String tableName2) {
        return associationModel.getTableName().equalsIgnoreCase(tableName1) && associationModel.getAssociatedTableName().equalsIgnoreCase(tableName2);
    }
}

