/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.litepal.tablemanager;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import com.komect.network.litepal.exceptions.DatabaseGenerateException;
import com.komect.network.litepal.tablemanager.Generator;
import com.komect.network.litepal.tablemanager.model.AssociationsModel;
import com.komect.network.litepal.tablemanager.model.ColumnModel;
import com.komect.network.litepal.tablemanager.model.GenericModel;
import com.komect.network.litepal.util.BaseUtility;
import com.komect.network.litepal.util.DBUtility;
import com.komect.network.litepal.util.LogUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;

public abstract class AssociationCreator
extends Generator {
    @Override
    protected abstract void createOrUpgradeTable(SQLiteDatabase var1, boolean var2);

    @Override
    protected void addOrUpdateAssociation(SQLiteDatabase db, boolean force) {
        this.addAssociations(this.getAllAssociations(), db, force);
    }

    protected String generateCreateTableSQL(String tableName, List<ColumnModel> columnModels, boolean autoIncrementId) {
        StringBuilder createTableSQL = new StringBuilder("create table ");
        createTableSQL.append(tableName).append(" (");
        if (autoIncrementId) {
            createTableSQL.append("id integer primary key autoincrement,");
        }
        if (this.isContainsOnlyIdField(columnModels)) {
            createTableSQL.deleteCharAt(createTableSQL.length() - 1);
        }
        boolean needSeparator = false;
        for (ColumnModel columnModel : columnModels) {
            String defaultValue;
            if (columnModel.isIdColumn()) continue;
            if (needSeparator) {
                createTableSQL.append(", ");
            }
            needSeparator = true;
            createTableSQL.append(columnModel.getColumnName()).append(" ").append(columnModel.getColumnType());
            if (!columnModel.isNullable()) {
                createTableSQL.append(" not null");
            }
            if (columnModel.isUnique()) {
                createTableSQL.append(" unique");
            }
            if (TextUtils.isEmpty((CharSequence)(defaultValue = columnModel.getDefaultValue()))) continue;
            createTableSQL.append(" default ").append(defaultValue);
        }
        createTableSQL.append(")");
        LogUtil.d("Generator", "create table sql is >> " + createTableSQL);
        return createTableSQL.toString();
    }

    protected String generateDropTableSQL(String tableName) {
        return "drop table if exists " + tableName;
    }

    protected String generateAddColumnSQL(String tableName, ColumnModel columnModel) {
        String defaultValue;
        StringBuilder addColumnSQL = new StringBuilder();
        addColumnSQL.append("alter table ").append(tableName);
        addColumnSQL.append(" add column ").append(columnModel.getColumnName());
        addColumnSQL.append(" ").append(columnModel.getColumnType());
        if (!columnModel.isNullable()) {
            addColumnSQL.append(" not null");
        }
        if (columnModel.isUnique()) {
            addColumnSQL.append(" unique");
        }
        if (!TextUtils.isEmpty((CharSequence)(defaultValue = columnModel.getDefaultValue()))) {
            addColumnSQL.append(" default ").append(defaultValue);
        } else if (!columnModel.isNullable()) {
            if ("integer".equalsIgnoreCase(columnModel.getColumnType())) {
                defaultValue = "0";
            } else if ("text".equalsIgnoreCase(columnModel.getColumnType())) {
                defaultValue = "''";
            } else if ("real".equalsIgnoreCase(columnModel.getColumnType())) {
                defaultValue = "0.0";
            }
            addColumnSQL.append(" default ").append(defaultValue);
        }
        LogUtil.d("Generator", "add column sql is >> " + addColumnSQL);
        return addColumnSQL.toString();
    }

    protected boolean isForeignKeyColumnFormat(String columnName) {
        if (!TextUtils.isEmpty((CharSequence)columnName)) {
            return columnName.toLowerCase(Locale.US).endsWith("_id") && !columnName.equalsIgnoreCase("_id");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void giveTableSchemaACopy(String tableName, int tableType, SQLiteDatabase db) {
        StringBuilder sql = new StringBuilder("select * from ");
        sql.append("table_schema");
        LogUtil.d("Generator", "giveTableSchemaACopy SQL is >> " + sql);
        try (Cursor cursor = null;){
            cursor = db.rawQuery(sql.toString(), null);
            if (this.isNeedtoGiveACopy(cursor, tableName)) {
                ContentValues values = new ContentValues();
                values.put("name", BaseUtility.changeCase(tableName));
                values.put("type", Integer.valueOf(tableType));
                db.insert("table_schema", null, values);
            }
        }
    }

    private boolean isNeedtoGiveACopy(Cursor cursor, String tableName) {
        return !this.isValueExists(cursor, tableName) && !this.isSpecialTable(tableName);
    }

    private boolean isValueExists(Cursor cursor, String tableName) {
        boolean exist = false;
        if (cursor.moveToFirst()) {
            do {
                String name;
                if (!(name = cursor.getString(cursor.getColumnIndexOrThrow("name"))).equalsIgnoreCase(tableName)) continue;
                exist = true;
                break;
            } while (cursor.moveToNext());
        }
        return exist;
    }

    private boolean isSpecialTable(String tableName) {
        return "table_schema".equalsIgnoreCase(tableName);
    }

    private void addAssociations(Collection<AssociationsModel> associatedModels, SQLiteDatabase db, boolean force) {
        for (AssociationsModel associationModel : associatedModels) {
            if (2 == associationModel.getAssociationType() || 1 == associationModel.getAssociationType()) {
                this.addForeignKeyColumn(associationModel.getTableName(), associationModel.getAssociatedTableName(), associationModel.getTableHoldsForeignKey(), db);
                continue;
            }
            if (3 != associationModel.getAssociationType()) continue;
            this.createIntermediateTable(associationModel.getTableName(), associationModel.getAssociatedTableName(), db, force);
        }
        for (GenericModel genericModel : this.getGenericModels()) {
            this.createGenericTable(genericModel, db, force);
        }
    }

    private void createIntermediateTable(String tableName, String associatedTableName, SQLiteDatabase db, boolean force) {
        ArrayList<ColumnModel> columnModelList = new ArrayList<ColumnModel>();
        ColumnModel column1 = new ColumnModel();
        column1.setColumnName(tableName + "_id");
        column1.setColumnType("integer");
        ColumnModel column2 = new ColumnModel();
        column2.setColumnName(associatedTableName + "_id");
        column2.setColumnType("integer");
        columnModelList.add(column1);
        columnModelList.add(column2);
        String intermediateTableName = DBUtility.getIntermediateTableName(tableName, associatedTableName);
        ArrayList<String> sqls = new ArrayList<String>();
        if (DBUtility.isTableExists(intermediateTableName, db)) {
            if (force) {
                sqls.add(this.generateDropTableSQL(intermediateTableName));
                sqls.add(this.generateCreateTableSQL(intermediateTableName, columnModelList, false));
            }
        } else {
            sqls.add(this.generateCreateTableSQL(intermediateTableName, columnModelList, false));
        }
        this.execute(sqls, db);
        this.giveTableSchemaACopy(intermediateTableName, 1, db);
    }

    private void createGenericTable(GenericModel genericModel, SQLiteDatabase db, boolean force) {
        String tableName = genericModel.getTableName();
        String valueColumnName = genericModel.getValueColumnName();
        String valueColumnType = genericModel.getValueColumnType();
        String valueIdColumnName = genericModel.getValueIdColumnName();
        ArrayList<ColumnModel> columnModelList = new ArrayList<ColumnModel>();
        ColumnModel column1 = new ColumnModel();
        column1.setColumnName(valueColumnName);
        column1.setColumnType(valueColumnType);
        ColumnModel column2 = new ColumnModel();
        column2.setColumnName(valueIdColumnName);
        column2.setColumnType("integer");
        columnModelList.add(column1);
        columnModelList.add(column2);
        ArrayList<String> sqls = new ArrayList<String>();
        if (DBUtility.isTableExists(tableName, db)) {
            if (force) {
                sqls.add(this.generateDropTableSQL(tableName));
                sqls.add(this.generateCreateTableSQL(tableName, columnModelList, false));
            }
        } else {
            sqls.add(this.generateCreateTableSQL(tableName, columnModelList, false));
        }
        this.execute(sqls, db);
        this.giveTableSchemaACopy(tableName, 2, db);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addForeignKeyColumn(String tableName, String associatedTableName, String tableHoldsForeignKey, SQLiteDatabase db) {
        if (!DBUtility.isTableExists(tableName, db)) throw new DatabaseGenerateException("Table doesn't exist with the name of " + tableName);
        if (!DBUtility.isTableExists(associatedTableName, db)) throw new DatabaseGenerateException("Table doesn't exist with the name of " + associatedTableName);
        String foreignKeyColumn = null;
        if (tableName.equals(tableHoldsForeignKey)) {
            foreignKeyColumn = this.getForeignKeyColumnName(associatedTableName);
        } else if (associatedTableName.equals(tableHoldsForeignKey)) {
            foreignKeyColumn = this.getForeignKeyColumnName(tableName);
        }
        if (!DBUtility.isColumnExists(foreignKeyColumn, tableHoldsForeignKey, db)) {
            ColumnModel columnModel = new ColumnModel();
            columnModel.setColumnName(foreignKeyColumn);
            columnModel.setColumnType("integer");
            ArrayList<String> sqls = new ArrayList<String>();
            sqls.add(this.generateAddColumnSQL(tableHoldsForeignKey, columnModel));
            this.execute(sqls, db);
            return;
        } else {
            LogUtil.d("Generator", "column " + foreignKeyColumn + " is already exist, no need to add one");
        }
    }

    private boolean isContainsOnlyIdField(List<ColumnModel> columnModels) {
        return columnModels.size() == 0 || columnModels.size() == 1 && this.isIdColumn(columnModels.get(0).getColumnName()) || columnModels.size() == 2 && this.isIdColumn(columnModels.get(0).getColumnName()) && this.isIdColumn(columnModels.get(1).getColumnName());
    }
}

