/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.litepal.parser;

import android.text.TextUtils;
import com.komect.network.litepal.exceptions.InvalidAttributesException;
import com.komect.network.litepal.parser.LitePalConfig;
import com.komect.network.litepal.parser.LitePalParser;
import com.komect.network.litepal.util.BaseUtility;
import com.komect.network.litepal.util.SharedUtil;
import java.util.ArrayList;
import java.util.List;

public final class LitePalAttr {
    private static LitePalAttr litePalAttr;
    private int version;
    private String dbName;
    private String cases;
    private String storage;
    private List<String> classNames;
    private String extraKeyName;

    private LitePalAttr() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LitePalAttr getInstance() {
        if (litePalAttr != null) return litePalAttr;
        Class<LitePalAttr> clazz = LitePalAttr.class;
        synchronized (LitePalAttr.class) {
            if (litePalAttr != null) return litePalAttr;
            litePalAttr = new LitePalAttr();
            LitePalAttr.loadLitePalXMLConfiguration();
            // ** MonitorExit[var0] (shouldn't be in output)
            return litePalAttr;
        }
    }

    private static void loadLitePalXMLConfiguration() {
        if (BaseUtility.isLitePalXMLExists()) {
            LitePalConfig config = LitePalParser.parseLitePalConfiguration();
            litePalAttr.setDbName(config.getDbName());
            litePalAttr.setVersion(config.getVersion());
            litePalAttr.setClassNames(config.getClassNames());
            litePalAttr.setCases(config.getCases());
            litePalAttr.setStorage(config.getStorage());
        }
    }

    public static void clearInstance() {
        litePalAttr = null;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getStorage() {
        return this.storage;
    }

    public void setStorage(String storage) {
        this.storage = storage;
    }

    public String getExtraKeyName() {
        return this.extraKeyName;
    }

    public void setExtraKeyName(String extraKeyName) {
        this.extraKeyName = extraKeyName;
    }

    public List<String> getClassNames() {
        if (this.classNames == null) {
            this.classNames = new ArrayList<String>();
            this.classNames.add("com.komect.network.litepal.model.Table_Schema");
        } else if (this.classNames.isEmpty()) {
            this.classNames.add("com.komect.network.litepal.model.Table_Schema");
        }
        return this.classNames;
    }

    public void addClassName(String className) {
        this.getClassNames().add(className);
    }

    public void setClassNames(List<String> classNames) {
        this.classNames = classNames;
    }

    public String getCases() {
        return this.cases;
    }

    public void setCases(String cases) {
        this.cases = cases;
    }

    public void checkSelfValid() {
        if (TextUtils.isEmpty((CharSequence)this.dbName)) {
            LitePalAttr.loadLitePalXMLConfiguration();
            if (TextUtils.isEmpty((CharSequence)this.dbName)) {
                throw new InvalidAttributesException("dbname is empty or not defined in litepal.xml file, or your litepal.xml file is missing.");
            }
        }
        if (!this.dbName.endsWith(".db")) {
            this.dbName = this.dbName + ".db";
        }
        if (this.version < 1) {
            throw new InvalidAttributesException("the version of database can not be less than 1");
        }
        if (this.version < SharedUtil.getLastVersion(this.extraKeyName)) {
            throw new InvalidAttributesException("the version in litepal.xml is earlier than the current version");
        }
        if (TextUtils.isEmpty((CharSequence)this.cases)) {
            this.cases = "lower";
        } else if (!(this.cases.equals("upper") || this.cases.equals("lower") || this.cases.equals("keep"))) {
            throw new InvalidAttributesException(this.cases + " is an invalid value for <cases></cases>");
        }
    }
}

