/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.litepal.crud;

import android.content.ContentValues;
import android.database.sqlite.SQLiteDatabase;
import android.os.Build;
import com.komect.network.litepal.annotation.Encrypt;
import com.komect.network.litepal.crud.DataHandler;
import com.komect.network.litepal.crud.DataSupport;
import com.komect.network.litepal.crud.DynamicExecutor;
import com.komect.network.litepal.crud.model.AssociationsInfo;
import com.komect.network.litepal.exceptions.DataSupportException;
import com.komect.network.litepal.util.BaseUtility;
import com.komect.network.litepal.util.DBUtility;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class UpdateHandler
extends DataHandler {
    UpdateHandler(SQLiteDatabase db) {
        this.mDatabase = db;
    }

    int onUpdate(DataSupport baseObj, long id2) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        List<Field> supportedFields = this.getSupportedFields(baseObj.getClassName());
        List<Field> supportedGenericFields = this.getSupportedGenericFields(baseObj.getClassName());
        this.updateGenericTables(baseObj, supportedGenericFields, id2);
        ContentValues values = new ContentValues();
        this.putFieldsValue(baseObj, supportedFields, values);
        this.putFieldsToDefaultValue(baseObj, values, id2);
        if (values.size() > 0) {
            return this.mDatabase.update(baseObj.getTableName(), values, "id = " + id2, null);
        }
        return 0;
    }

    int onUpdate(Class<?> modelClass, long id2, ContentValues values) {
        if (values.size() > 0) {
            this.convertContentValues(values);
            return this.mDatabase.update(this.getTableName(modelClass), values, "id = " + id2, null);
        }
        return 0;
    }

    int onUpdateAll(DataSupport baseObj, String ... conditions) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        List<?> list;
        BaseUtility.checkConditionsCorrect(conditions);
        if (conditions != null && conditions.length > 0) {
            conditions[0] = DBUtility.convertWhereClauseToColumnName(conditions[0]);
        }
        List<Field> supportedFields = this.getSupportedFields(baseObj.getClassName());
        List<Field> supportedGenericFields = this.getSupportedGenericFields(baseObj.getClassName());
        long[] ids = null;
        if (!supportedGenericFields.isEmpty() && (list = DataSupport.select("id").where(conditions).find(baseObj.getClass())).size() > 0) {
            ids = new long[list.size()];
            for (int i = 0; i < ids.length; ++i) {
                DataSupport dataSupport = (DataSupport)list.get(i);
                ids[i] = dataSupport.getBaseObjId();
            }
            this.updateGenericTables(baseObj, supportedGenericFields, ids);
        }
        ContentValues values = new ContentValues();
        this.putFieldsValue(baseObj, supportedFields, values);
        this.putFieldsToDefaultValue(baseObj, values, ids);
        return this.doUpdateAllAction(baseObj.getTableName(), values, conditions);
    }

    int onUpdateAll(String tableName, ContentValues values, String ... conditions) {
        BaseUtility.checkConditionsCorrect(conditions);
        if (conditions != null && conditions.length > 0) {
            conditions[0] = DBUtility.convertWhereClauseToColumnName(conditions[0]);
        }
        this.convertContentValues(values);
        return this.doUpdateAllAction(tableName, values, conditions);
    }

    private int doUpdateAllAction(String tableName, ContentValues values, String ... conditions) {
        BaseUtility.checkConditionsCorrect(conditions);
        if (values.size() > 0) {
            return this.mDatabase.update(tableName, values, this.getWhereClause(conditions), this.getWhereArgs(conditions));
        }
        return 0;
    }

    private void putFieldsToDefaultValue(DataSupport baseObj, ContentValues values, long ... ids) {
        String fieldName = null;
        try {
            DataSupport emptyModel = this.getEmptyModel(baseObj);
            Class<?> emptyModelClass = emptyModel.getClass();
            for (String name : baseObj.getFieldsToSetToDefault()) {
                if (this.isIdColumn(name)) continue;
                fieldName = name;
                Field field = emptyModelClass.getDeclaredField(fieldName);
                if (this.isCollection(field.getType())) {
                    String genericTypeName;
                    if (ids == null || ids.length <= 0 || !BaseUtility.isGenericTypeSupported(genericTypeName = this.getGenericTypeName(field))) continue;
                    String tableName = DBUtility.getGenericTableName(baseObj.getClassName(), field.getName());
                    String genericValueIdColumnName = DBUtility.getGenericValueIdColumnName(baseObj.getClassName());
                    StringBuilder whereClause = new StringBuilder();
                    boolean needOr = false;
                    for (long id2 : ids) {
                        if (needOr) {
                            whereClause.append(" or ");
                        }
                        whereClause.append(genericValueIdColumnName).append(" = ").append(id2);
                        needOr = true;
                    }
                    this.mDatabase.delete(tableName, whereClause.toString(), null);
                    continue;
                }
                this.putContentValuesForUpdate(emptyModel, field, values);
            }
        }
        catch (NoSuchFieldException e) {
            throw new DataSupportException(DataSupportException.noSuchFieldExceptioin(baseObj.getClassName(), fieldName), e);
        }
        catch (Exception e) {
            throw new DataSupportException(e.getMessage(), e);
        }
    }

    private int doUpdateAssociations(DataSupport baseObj, long id2, ContentValues values) {
        int rowsAffected = 0;
        this.analyzeAssociations(baseObj);
        this.updateSelfTableForeignKey(baseObj, values);
        return rowsAffected += this.updateAssociatedTableForeignKey(baseObj, id2);
    }

    private void analyzeAssociations(DataSupport baseObj) {
        try {
            Collection<AssociationsInfo> associationInfos = this.getAssociationInfo(baseObj.getClassName());
            this.analyzeAssociatedModels(baseObj, associationInfos);
        }
        catch (Exception e) {
            throw new DataSupportException(e.getMessage(), e);
        }
    }

    private void updateSelfTableForeignKey(DataSupport baseObj, ContentValues values) {
        Map<String, Long> associatedModelMap = baseObj.getAssociatedModelsMapWithoutFK();
        for (String associatedTable : associatedModelMap.keySet()) {
            String fkName = this.getForeignKeyColumnName(associatedTable);
            values.put(fkName, associatedModelMap.get(associatedTable));
        }
    }

    private int updateAssociatedTableForeignKey(DataSupport baseObj, long id2) {
        Map<String, Set<Long>> associatedModelMap = baseObj.getAssociatedModelsMapWithFK();
        ContentValues values = new ContentValues();
        for (String associatedTable : associatedModelMap.keySet()) {
            values.clear();
            String fkName = this.getForeignKeyColumnName(baseObj.getTableName());
            values.put(fkName, Long.valueOf(id2));
            Set<Long> ids = associatedModelMap.get(associatedTable);
            if (ids == null || ids.isEmpty()) continue;
            return this.mDatabase.update(associatedTable, values, this.getWhereOfIdsWithOr(ids), null);
        }
        return 0;
    }

    private void updateGenericTables(DataSupport baseObj, List<Field> supportedGenericFields, long ... ids) throws IllegalAccessException, InvocationTargetException {
        if (ids != null && ids.length > 0) {
            for (Field field : supportedGenericFields) {
                Encrypt annotation = field.getAnnotation(Encrypt.class);
                String algorithm = null;
                if (annotation != null && "java.lang.String".equals(this.getGenericTypeName(field))) {
                    algorithm = annotation.algorithm();
                }
                field.setAccessible(true);
                Collection collection = (Collection)field.get(baseObj);
                if (collection == null || collection.isEmpty()) continue;
                String tableName = DBUtility.getGenericTableName(baseObj.getClassName(), field.getName());
                String genericValueIdColumnName = DBUtility.getGenericValueIdColumnName(baseObj.getClassName());
                for (long id2 : ids) {
                    this.mDatabase.delete(tableName, genericValueIdColumnName + " = ?", new String[]{String.valueOf(id2)});
                    for (Object object : collection) {
                        ContentValues values = new ContentValues();
                        values.put(genericValueIdColumnName, Long.valueOf(id2));
                        object = this.encryptValue(algorithm, object);
                        Object[] parameters = new Object[]{DBUtility.convertToValidColumnName(BaseUtility.changeCase(field.getName())), object};
                        Class[] parameterTypes = new Class[]{String.class, this.getGenericTypeClass(field)};
                        DynamicExecutor.send(values, "put", parameters, values.getClass(), parameterTypes);
                        this.mDatabase.insert(tableName, null, values);
                    }
                }
            }
        }
    }

    private void convertContentValues(ContentValues values) {
        if (Build.VERSION.SDK_INT >= 11) {
            HashMap<String, Object> valuesToConvert = new HashMap<String, Object>();
            for (String key : values.keySet()) {
                if (!DBUtility.isFieldNameConflictWithSQLiteKeywords(key)) continue;
                Object object = values.get(key);
                valuesToConvert.put(key, object);
            }
            for (String key : valuesToConvert.keySet()) {
                String convertedKey = DBUtility.convertToValidColumnName(key);
                Object object = values.get(key);
                values.remove(key);
                if (object == null) {
                    values.putNull(convertedKey);
                    continue;
                }
                String className = object.getClass().getName();
                if ("java.lang.Byte".equals(className)) {
                    values.put(convertedKey, (Byte)object);
                    continue;
                }
                if ("[B".equals(className)) {
                    values.put(convertedKey, (byte[])object);
                    continue;
                }
                if ("java.lang.Boolean".equals(className)) {
                    values.put(convertedKey, (Boolean)object);
                    continue;
                }
                if ("java.lang.String".equals(className)) {
                    values.put(convertedKey, (String)object);
                    continue;
                }
                if ("java.lang.Float".equals(className)) {
                    values.put(convertedKey, (Float)object);
                    continue;
                }
                if ("java.lang.Long".equals(className)) {
                    values.put(convertedKey, (Long)object);
                    continue;
                }
                if ("java.lang.Integer".equals(className)) {
                    values.put(convertedKey, (Integer)object);
                    continue;
                }
                if ("java.lang.Short".equals(className)) {
                    values.put(convertedKey, (Short)object);
                    continue;
                }
                if (!"java.lang.Double".equals(className)) continue;
                values.put(convertedKey, (Double)object);
            }
        }
    }
}

