/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.litepal.crud;

import android.content.ContentValues;
import android.database.sqlite.SQLiteDatabase;
import com.komect.network.litepal.annotation.Encrypt;
import com.komect.network.litepal.crud.DataHandler;
import com.komect.network.litepal.crud.DataSupport;
import com.komect.network.litepal.crud.DynamicExecutor;
import com.komect.network.litepal.crud.model.AssociationsInfo;
import com.komect.network.litepal.exceptions.DataSupportException;
import com.komect.network.litepal.util.BaseUtility;
import com.komect.network.litepal.util.DBUtility;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

class SaveHandler
extends DataHandler {
    private boolean ignoreAssociations = false;
    private ContentValues values = new ContentValues();

    SaveHandler(SQLiteDatabase db) {
        this.mDatabase = db;
    }

    void onSave(DataSupport baseObj) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String className = baseObj.getClassName();
        List<Field> supportedFields = this.getSupportedFields(className);
        List<Field> supportedGenericFields = this.getSupportedGenericFields(className);
        Collection<AssociationsInfo> associationInfos = this.getAssociationInfo(className);
        if (!baseObj.isSaved()) {
            if (!this.ignoreAssociations) {
                this.analyzeAssociatedModels(baseObj, associationInfos);
            }
            this.doSaveAction(baseObj, supportedFields, supportedGenericFields);
            if (!this.ignoreAssociations) {
                this.analyzeAssociatedModels(baseObj, associationInfos);
            }
        } else {
            if (!this.ignoreAssociations) {
                this.analyzeAssociatedModels(baseObj, associationInfos);
            }
            this.doUpdateAction(baseObj, supportedFields, supportedGenericFields);
        }
    }

    void onSaveFast(DataSupport baseObj) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        this.ignoreAssociations = true;
        this.onSave(baseObj);
    }

    <T extends DataSupport> void onSaveAll(Collection<T> collection) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (collection != null && collection.size() > 0) {
            DataSupport[] array = collection.toArray(new DataSupport[0]);
            DataSupport firstObj = array[0];
            String className = firstObj.getClassName();
            List<Field> supportedFields = this.getSupportedFields(className);
            List<Field> supportedGenericFields = this.getSupportedGenericFields(className);
            Collection<AssociationsInfo> associationInfos = this.getAssociationInfo(className);
            for (DataSupport baseObj : array) {
                if (!baseObj.isSaved()) {
                    this.analyzeAssociatedModels(baseObj, associationInfos);
                    this.doSaveAction(baseObj, supportedFields, supportedGenericFields);
                    this.analyzeAssociatedModels(baseObj, associationInfos);
                } else {
                    this.analyzeAssociatedModels(baseObj, associationInfos);
                    this.doUpdateAction(baseObj, supportedFields, supportedGenericFields);
                }
                baseObj.clearAssociatedData();
            }
        }
    }

    private void doSaveAction(DataSupport baseObj, List<Field> supportedFields, List<Field> supportedGenericFields) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        this.values.clear();
        this.beforeSave(baseObj, supportedFields, this.values);
        long id2 = this.saving(baseObj, this.values);
        this.afterSave(baseObj, supportedFields, supportedGenericFields, id2);
    }

    private void beforeSave(DataSupport baseObj, List<Field> supportedFields, ContentValues values) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        this.putFieldsValue(baseObj, supportedFields, values);
        if (!this.ignoreAssociations) {
            this.putForeignKeyValue(values, baseObj);
        }
    }

    private long saving(DataSupport baseObj, ContentValues values) {
        if (values.size() == 0) {
            values.putNull("id");
        }
        return this.mDatabase.insert(baseObj.getTableName(), null, values);
    }

    private void afterSave(DataSupport baseObj, List<Field> supportedFields, List<Field> supportedGenericFields, long id2) throws IllegalAccessException, InvocationTargetException {
        this.throwIfSaveFailed(id2);
        this.assignIdValue(baseObj, this.getIdField(supportedFields), id2);
        this.updateGenericTables(baseObj, supportedGenericFields, id2);
        if (!this.ignoreAssociations) {
            this.updateAssociatedTableWithFK(baseObj);
            this.insertIntermediateJoinTableValue(baseObj, false);
        }
    }

    private void doUpdateAction(DataSupport baseObj, List<Field> supportedFields, List<Field> supportedGenericFields) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        this.values.clear();
        this.beforeUpdate(baseObj, supportedFields, this.values);
        this.updating(baseObj, this.values);
        this.afterUpdate(baseObj, supportedGenericFields);
    }

    private void beforeUpdate(DataSupport baseObj, List<Field> supportedFields, ContentValues values) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        this.putFieldsValue(baseObj, supportedFields, values);
        if (!this.ignoreAssociations) {
            this.putForeignKeyValue(values, baseObj);
            for (String fkName : baseObj.getListToClearSelfFK()) {
                values.putNull(fkName);
            }
        }
    }

    private void updating(DataSupport baseObj, ContentValues values) {
        this.mDatabase.update(baseObj.getTableName(), values, "id = ?", new String[]{String.valueOf(baseObj.getBaseObjId())});
    }

    private void afterUpdate(DataSupport baseObj, List<Field> supportedGenericFields) throws InvocationTargetException, IllegalAccessException {
        this.updateGenericTables(baseObj, supportedGenericFields, baseObj.getBaseObjId());
        if (!this.ignoreAssociations) {
            this.updateAssociatedTableWithFK(baseObj);
            this.insertIntermediateJoinTableValue(baseObj, true);
            this.clearFKValueInAssociatedTable(baseObj);
        }
    }

    private Field getIdField(List<Field> supportedFields) {
        for (Field field : supportedFields) {
            if (!this.isIdColumn(field.getName())) continue;
            return field;
        }
        return null;
    }

    private void throwIfSaveFailed(long id2) {
        if (id2 == -1L) {
            throw new DataSupportException("Save current model failed.");
        }
    }

    private void assignIdValue(DataSupport baseObj, Field idField, long id2) {
        try {
            this.giveBaseObjIdValue(baseObj, id2);
            if (idField != null) {
                this.giveModelIdValue(baseObj, idField.getName(), idField.getType(), id2);
            }
        }
        catch (Exception e) {
            throw new DataSupportException(e.getMessage(), e);
        }
    }

    private void giveModelIdValue(DataSupport baseObj, String idName, Class<?> idType, long id2) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        if (this.shouldGiveModelIdValue(idName, idType, id2)) {
            Number value;
            if (idType == Integer.TYPE || idType == Integer.class) {
                value = (int)id2;
            } else if (idType == Long.TYPE || idType == Long.class) {
                value = id2;
            } else {
                throw new DataSupportException("id type is not supported. Only int or long is acceptable for id");
            }
            DynamicExecutor.setField(baseObj, idName, value, baseObj.getClass());
        }
    }

    private void putForeignKeyValue(ContentValues values, DataSupport baseObj) {
        Map<String, Long> associatedModelMap = baseObj.getAssociatedModelsMapWithoutFK();
        for (String associatedTableName : associatedModelMap.keySet()) {
            values.put(this.getForeignKeyColumnName(associatedTableName), associatedModelMap.get(associatedTableName));
        }
    }

    private void updateAssociatedTableWithFK(DataSupport baseObj) {
        Map<String, Set<Long>> associatedModelMap = baseObj.getAssociatedModelsMapWithFK();
        ContentValues values = new ContentValues();
        for (String associatedTableName : associatedModelMap.keySet()) {
            values.clear();
            String fkName = this.getForeignKeyColumnName(baseObj.getTableName());
            values.put(fkName, Long.valueOf(baseObj.getBaseObjId()));
            Set<Long> ids = associatedModelMap.get(associatedTableName);
            if (ids == null || ids.isEmpty()) continue;
            this.mDatabase.update(associatedTableName, values, this.getWhereOfIdsWithOr(ids), null);
        }
    }

    private void clearFKValueInAssociatedTable(DataSupport baseObj) {
        List<String> associatedTableNames = baseObj.getListToClearAssociatedFK();
        for (String associatedTableName : associatedTableNames) {
            String fkColumnName = this.getForeignKeyColumnName(baseObj.getTableName());
            ContentValues values = new ContentValues();
            values.putNull(fkColumnName);
            String whereClause = fkColumnName + " = " + baseObj.getBaseObjId();
            this.mDatabase.update(associatedTableName, values, whereClause, null);
        }
    }

    private void insertIntermediateJoinTableValue(DataSupport baseObj, boolean isUpdate) {
        Map<String, Set<Long>> associatedIdsM2M = baseObj.getAssociatedModelsMapForJoinTable();
        ContentValues values = new ContentValues();
        for (String associatedTableName : associatedIdsM2M.keySet()) {
            String joinTableName = this.getIntermediateTableName(baseObj, associatedTableName);
            if (isUpdate) {
                this.mDatabase.delete(joinTableName, this.getWhereForJoinTableToDelete(baseObj), new String[]{String.valueOf(baseObj.getBaseObjId())});
            }
            Set<Long> associatedIdsM2MSet = associatedIdsM2M.get(associatedTableName);
            for (long associatedId : associatedIdsM2MSet) {
                values.clear();
                values.put(this.getForeignKeyColumnName(baseObj.getTableName()), Long.valueOf(baseObj.getBaseObjId()));
                values.put(this.getForeignKeyColumnName(associatedTableName), Long.valueOf(associatedId));
                this.mDatabase.insert(joinTableName, null, values);
            }
        }
    }

    private String getWhereForJoinTableToDelete(DataSupport baseObj) {
        StringBuilder where = new StringBuilder();
        where.append(this.getForeignKeyColumnName(baseObj.getTableName()));
        where.append(" = ?");
        return where.toString();
    }

    private boolean shouldGiveModelIdValue(String idName, Class<?> idType, long id2) {
        return idName != null && idType != null && id2 > 0L;
    }

    private void updateGenericTables(DataSupport baseObj, List<Field> supportedGenericFields, long id2) throws IllegalAccessException, InvocationTargetException {
        for (Field field : supportedGenericFields) {
            Encrypt annotation = field.getAnnotation(Encrypt.class);
            String algorithm = null;
            if (annotation != null && "java.lang.String".equals(this.getGenericTypeName(field))) {
                algorithm = annotation.algorithm();
            }
            field.setAccessible(true);
            Collection collection = (Collection)field.get(baseObj);
            if (collection == null) continue;
            String tableName = DBUtility.getGenericTableName(baseObj.getClassName(), field.getName());
            String genericValueIdColumnName = DBUtility.getGenericValueIdColumnName(baseObj.getClassName());
            this.mDatabase.delete(tableName, genericValueIdColumnName + " = ?", new String[]{String.valueOf(id2)});
            for (Object object : collection) {
                ContentValues values = new ContentValues();
                values.put(genericValueIdColumnName, Long.valueOf(id2));
                object = this.encryptValue(algorithm, object);
                Object[] parameters = new Object[]{BaseUtility.changeCase(DBUtility.convertToValidColumnName(field.getName())), object};
                Class[] parameterTypes = new Class[]{String.class, this.getGenericTypeClass(field)};
                DynamicExecutor.send(values, "put", parameters, values.getClass(), parameterTypes);
                this.mDatabase.insert(tableName, null, values);
            }
        }
    }
}

