/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.litepal.crud;

import com.komect.network.litepal.crud.DataSupport;
import com.komect.network.litepal.exceptions.DataSupportException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class DynamicExecutor {
    private DynamicExecutor() {
    }

    static Object send(Object object, String methodName, Object[] parameters, Class<?> objectClass, Class<?>[] parameterTypes) throws SecurityException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        try {
            if (parameters == null) {
                parameters = new Object[]{};
            }
            if (parameterTypes == null) {
                parameterTypes = new Class[]{};
            }
            Method method = objectClass.getDeclaredMethod(methodName, parameterTypes);
            method.setAccessible(true);
            return method.invoke(object, parameters);
        }
        catch (NoSuchMethodException e) {
            throw new DataSupportException(DataSupportException.noSuchMethodException(objectClass.getSimpleName(), methodName), e);
        }
    }

    static void set(Object object, String fieldName, Object value, Class<?> objectClass) throws SecurityException, IllegalArgumentException, IllegalAccessException, NoSuchFieldException {
        Field objectField = objectClass.getDeclaredField(fieldName);
        objectField.setAccessible(true);
        objectField.set(object, value);
    }

    static void setField(Object object, String fieldName, Object value, Class<?> objectClass) throws SecurityException, IllegalArgumentException, IllegalAccessException {
        if (objectClass == DataSupport.class || objectClass == Object.class) {
            throw new DataSupportException(DataSupportException.noSuchFieldExceptioin(objectClass.getSimpleName(), fieldName));
        }
        try {
            DynamicExecutor.set(object, fieldName, value, objectClass);
        }
        catch (NoSuchFieldException e) {
            DynamicExecutor.setField(object, fieldName, value, objectClass.getSuperclass());
        }
    }

    static Object getField(Object object, String fieldName, Class<?> objectClass) throws IllegalArgumentException, IllegalAccessException {
        if (objectClass == DataSupport.class || objectClass == Object.class) {
            throw new DataSupportException(DataSupportException.noSuchFieldExceptioin(objectClass.getSimpleName(), fieldName));
        }
        try {
            Field objectField = objectClass.getDeclaredField(fieldName);
            objectField.setAccessible(true);
            return objectField.get(object);
        }
        catch (NoSuchFieldException e) {
            return DynamicExecutor.getField(object, fieldName, objectClass.getSuperclass());
        }
    }
}

