/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.litepal.crud;

import android.database.sqlite.SQLiteDatabase;
import com.komect.network.litepal.crud.DataHandler;
import com.komect.network.litepal.crud.DataSupport;
import com.komect.network.litepal.crud.model.AssociationsInfo;
import com.komect.network.litepal.exceptions.DataSupportException;
import com.komect.network.litepal.util.BaseUtility;
import com.komect.network.litepal.util.DBUtility;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

class DeleteHandler
extends DataHandler {
    private List<String> foreignKeyTableToDelete;

    DeleteHandler(SQLiteDatabase db) {
        this.mDatabase = db;
    }

    int onDelete(DataSupport baseObj) {
        if (baseObj.isSaved()) {
            List<Field> supportedGenericFields = this.getSupportedGenericFields(baseObj.getClassName());
            this.deleteGenericData(baseObj.getClass(), supportedGenericFields, baseObj.getBaseObjId());
            Collection<AssociationsInfo> associationInfos = this.analyzeAssociations(baseObj);
            int rowsAffected = this.deleteCascade(baseObj);
            this.clearAssociatedModelSaveState(baseObj, associationInfos);
            return rowsAffected += this.mDatabase.delete(baseObj.getTableName(), "id = " + baseObj.getBaseObjId(), null);
        }
        return 0;
    }

    int onDelete(Class<?> modelClass, long id2) {
        List<Field> supportedGenericFields = this.getSupportedGenericFields(modelClass.getName());
        this.deleteGenericData(modelClass, supportedGenericFields, id2);
        this.analyzeAssociations(modelClass);
        int rowsAffected = this.deleteCascade(modelClass, id2);
        this.getForeignKeyTableToDelete().clear();
        return rowsAffected += this.mDatabase.delete(this.getTableName(modelClass), "id = " + id2, null);
    }

    int onDeleteAll(String tableName, String ... conditions) {
        BaseUtility.checkConditionsCorrect(conditions);
        if (conditions != null && conditions.length > 0) {
            conditions[0] = DBUtility.convertWhereClauseToColumnName(conditions[0]);
        }
        return this.mDatabase.delete(tableName, this.getWhereClause(conditions), this.getWhereArgs(conditions));
    }

    int onDeleteAll(Class<?> modelClass, String ... conditions) {
        List<?> list;
        List<Field> supportedGenericFields;
        BaseUtility.checkConditionsCorrect(conditions);
        if (conditions != null && conditions.length > 0) {
            conditions[0] = DBUtility.convertWhereClauseToColumnName(conditions[0]);
        }
        if (!(supportedGenericFields = this.getSupportedGenericFields(modelClass.getName())).isEmpty() && (list = DataSupport.select("id").where(conditions).find(modelClass)).size() > 0) {
            long[] ids = new long[list.size()];
            for (int i = 0; i < ids.length; ++i) {
                DataSupport dataSupport = (DataSupport)list.get(i);
                ids[i] = dataSupport.getBaseObjId();
            }
            this.deleteGenericData(modelClass, supportedGenericFields, ids);
        }
        this.analyzeAssociations(modelClass);
        int rowsAffected = this.deleteAllCascade(modelClass, conditions);
        this.getForeignKeyTableToDelete().clear();
        return rowsAffected += this.mDatabase.delete(this.getTableName(modelClass), this.getWhereClause(conditions), this.getWhereArgs(conditions));
    }

    private void analyzeAssociations(Class<?> modelClass) {
        Collection<AssociationsInfo> associationInfos = this.getAssociationInfo(modelClass.getName());
        for (AssociationsInfo associationInfo : associationInfos) {
            String associatedTableName = DBUtility.getTableNameByClassName(associationInfo.getAssociatedClassName());
            if (associationInfo.getAssociationType() == 2 || associationInfo.getAssociationType() == 1) {
                String classHoldsForeignKey = associationInfo.getClassHoldsForeignKey();
                if (modelClass.getName().equals(classHoldsForeignKey)) continue;
                this.getForeignKeyTableToDelete().add(associatedTableName);
                continue;
            }
            if (associationInfo.getAssociationType() != 3) continue;
            String joinTableName = DBUtility.getIntermediateTableName(this.getTableName(modelClass), associatedTableName);
            joinTableName = BaseUtility.changeCase(joinTableName);
            this.getForeignKeyTableToDelete().add(joinTableName);
        }
    }

    private int deleteCascade(Class<?> modelClass, long id2) {
        int rowsAffected = 0;
        for (String associatedTableName : this.getForeignKeyTableToDelete()) {
            String fkName = this.getForeignKeyColumnName(this.getTableName(modelClass));
            rowsAffected += this.mDatabase.delete(associatedTableName, fkName + " = " + id2, null);
        }
        return rowsAffected;
    }

    private int deleteAllCascade(Class<?> modelClass, String ... conditions) {
        int rowsAffected = 0;
        for (String associatedTableName : this.getForeignKeyTableToDelete()) {
            String tableName = this.getTableName(modelClass);
            String fkName = this.getForeignKeyColumnName(tableName);
            StringBuilder whereClause = new StringBuilder();
            whereClause.append(fkName).append(" in (select id from ");
            whereClause.append(tableName);
            if (conditions != null && conditions.length > 0) {
                whereClause.append(" where ").append(this.buildConditionString(conditions));
            }
            whereClause.append(")");
            rowsAffected += this.mDatabase.delete(associatedTableName, BaseUtility.changeCase(whereClause.toString()), null);
        }
        return rowsAffected;
    }

    private String buildConditionString(String ... conditions) {
        int argCount = conditions.length - 1;
        String whereClause = conditions[0];
        for (int i = 0; i < argCount; ++i) {
            whereClause = whereClause.replaceFirst("\\?", "'" + conditions[i + 1] + "'");
        }
        return whereClause;
    }

    private Collection<AssociationsInfo> analyzeAssociations(DataSupport baseObj) {
        try {
            Collection<AssociationsInfo> associationInfos = this.getAssociationInfo(baseObj.getClassName());
            this.analyzeAssociatedModels(baseObj, associationInfos);
            return associationInfos;
        }
        catch (Exception e) {
            throw new DataSupportException(e.getMessage(), e);
        }
    }

    private void clearAssociatedModelSaveState(DataSupport baseObj, Collection<AssociationsInfo> associationInfos) {
        try {
            for (AssociationsInfo associationInfo : associationInfos) {
                DataSupport model;
                if (associationInfo.getAssociationType() == 2 && !baseObj.getClassName().equals(associationInfo.getClassHoldsForeignKey())) {
                    Collection<DataSupport> associatedModels = this.getAssociatedModels(baseObj, associationInfo);
                    if (associatedModels == null || associatedModels.isEmpty()) continue;
                    for (DataSupport model2 : associatedModels) {
                        if (model2 == null) continue;
                        model2.clearSavedState();
                    }
                    continue;
                }
                if (associationInfo.getAssociationType() != 1 || (model = this.getAssociatedModel(baseObj, associationInfo)) == null) continue;
                model.clearSavedState();
            }
        }
        catch (Exception e) {
            throw new DataSupportException(e.getMessage(), e);
        }
    }

    private int deleteCascade(DataSupport baseObj) {
        int rowsAffected = this.deleteAssociatedForeignKeyRows(baseObj);
        return rowsAffected += this.deleteAssociatedJoinTableRows(baseObj);
    }

    private int deleteAssociatedForeignKeyRows(DataSupport baseObj) {
        int rowsAffected = 0;
        Map<String, Set<Long>> associatedModelMap = baseObj.getAssociatedModelsMapWithFK();
        for (String associatedTableName : associatedModelMap.keySet()) {
            String fkName = this.getForeignKeyColumnName(baseObj.getTableName());
            rowsAffected += this.mDatabase.delete(associatedTableName, fkName + " = " + baseObj.getBaseObjId(), null);
        }
        return rowsAffected;
    }

    private int deleteAssociatedJoinTableRows(DataSupport baseObj) {
        int rowsAffected = 0;
        Set<String> associatedTableNames = baseObj.getAssociatedModelsMapForJoinTable().keySet();
        for (String associatedTableName : associatedTableNames) {
            String joinTableName = DBUtility.getIntermediateTableName(baseObj.getTableName(), associatedTableName);
            String fkName = this.getForeignKeyColumnName(baseObj.getTableName());
            rowsAffected += this.mDatabase.delete(joinTableName, fkName + " = " + baseObj.getBaseObjId(), null);
        }
        return rowsAffected;
    }

    private List<String> getForeignKeyTableToDelete() {
        if (this.foreignKeyTableToDelete == null) {
            this.foreignKeyTableToDelete = new ArrayList<String>();
        }
        return this.foreignKeyTableToDelete;
    }

    private void deleteGenericData(Class<?> modelClass, List<Field> supportedGenericFields, long ... ids) {
        for (Field field : supportedGenericFields) {
            String tableName = DBUtility.getGenericTableName(modelClass.getName(), field.getName());
            String genericValueIdColumnName = DBUtility.getGenericValueIdColumnName(modelClass.getName());
            StringBuilder whereClause = new StringBuilder();
            boolean needOr = false;
            for (long id2 : ids) {
                if (needOr) {
                    whereClause.append(" or ");
                }
                whereClause.append(genericValueIdColumnName).append(" = ").append(id2);
                needOr = true;
            }
            this.mDatabase.delete(tableName, whereClause.toString(), null);
        }
    }
}

