/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.litepal.crud;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.komect.network.litepal.LitePal;
import com.komect.network.litepal.crud.ClusterQuery;
import com.komect.network.litepal.crud.DeleteHandler;
import com.komect.network.litepal.crud.QueryHandler;
import com.komect.network.litepal.crud.SaveHandler;
import com.komect.network.litepal.crud.UpdateHandler;
import com.komect.network.litepal.crud.async.AverageExecutor;
import com.komect.network.litepal.crud.async.CountExecutor;
import com.komect.network.litepal.crud.async.FindExecutor;
import com.komect.network.litepal.crud.async.FindMultiExecutor;
import com.komect.network.litepal.crud.async.SaveExecutor;
import com.komect.network.litepal.crud.async.UpdateOrDeleteExecutor;
import com.komect.network.litepal.exceptions.DataSupportException;
import com.komect.network.litepal.tablemanager.Connector;
import com.komect.network.litepal.util.BaseUtility;
import com.komect.network.litepal.util.DBUtility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DataSupport {
    protected static final String MD5 = "MD5";
    protected static final String AES = "AES";
    private long baseObjId;
    private Map<String, Set<Long>> associatedModelsMapWithFK;
    private Map<String, Long> associatedModelsMapWithoutFK;
    private Map<String, Set<Long>> associatedModelsMapForJoinTable;
    private List<String> listToClearSelfFK;
    private List<String> listToClearAssociatedFK;
    private List<String> fieldsToSetToDefault;

    public static synchronized ClusterQuery select(String ... columns) {
        ClusterQuery cQuery = new ClusterQuery();
        cQuery.mColumns = columns;
        return cQuery;
    }

    public static synchronized ClusterQuery where(String ... conditions) {
        ClusterQuery cQuery = new ClusterQuery();
        cQuery.mConditions = conditions;
        return cQuery;
    }

    public static synchronized ClusterQuery order(String column) {
        ClusterQuery cQuery = new ClusterQuery();
        cQuery.mOrderBy = column;
        return cQuery;
    }

    public static synchronized ClusterQuery limit(int value) {
        ClusterQuery cQuery = new ClusterQuery();
        cQuery.mLimit = String.valueOf(value);
        return cQuery;
    }

    public static synchronized ClusterQuery offset(int value) {
        ClusterQuery cQuery = new ClusterQuery();
        cQuery.mOffset = String.valueOf(value);
        return cQuery;
    }

    public static synchronized int count(Class<?> modelClass) {
        return DataSupport.count(BaseUtility.changeCase(DBUtility.getTableNameByClassName(modelClass.getName())));
    }

    public static CountExecutor countAsync(Class<?> modelClass) {
        return DataSupport.countAsync(BaseUtility.changeCase(DBUtility.getTableNameByClassName(modelClass.getName())));
    }

    public static synchronized int count(String tableName) {
        ClusterQuery cQuery = new ClusterQuery();
        return cQuery.count(tableName);
    }

    public static CountExecutor countAsync(final String tableName) {
        final CountExecutor executor = new CountExecutor();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<DataSupport> clazz = DataSupport.class;
                synchronized (DataSupport.class) {
                    final int count = DataSupport.count(tableName);
                    if (executor.getListener() != null) {
                        LitePal.getHandler().post(new Runnable(){

                            @Override
                            public void run() {
                                executor.getListener().onFinish(count);
                            }
                        });
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        };
        executor.submit(runnable);
        return executor;
    }

    public static synchronized double average(Class<?> modelClass, String column) {
        return DataSupport.average(BaseUtility.changeCase(DBUtility.getTableNameByClassName(modelClass.getName())), column);
    }

    public static AverageExecutor averageAsync(Class<?> modelClass, String column) {
        return DataSupport.averageAsync(BaseUtility.changeCase(DBUtility.getTableNameByClassName(modelClass.getName())), column);
    }

    public static synchronized double average(String tableName, String column) {
        ClusterQuery cQuery = new ClusterQuery();
        return cQuery.average(tableName, column);
    }

    public static AverageExecutor averageAsync(final String tableName, final String column) {
        final AverageExecutor executor = new AverageExecutor();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<DataSupport> clazz = DataSupport.class;
                synchronized (DataSupport.class) {
                    final double average = DataSupport.average(tableName, column);
                    if (executor.getListener() != null) {
                        LitePal.getHandler().post(new Runnable(){

                            @Override
                            public void run() {
                                executor.getListener().onFinish(average);
                            }
                        });
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        };
        executor.submit(runnable);
        return executor;
    }

    public static synchronized <T> T max(Class<?> modelClass, String columnName, Class<T> columnType) {
        return DataSupport.max(BaseUtility.changeCase(DBUtility.getTableNameByClassName(modelClass.getName())), columnName, columnType);
    }

    public static <T> FindExecutor maxAsync(Class<?> modelClass, String columnName, Class<T> columnType) {
        return DataSupport.maxAsync(BaseUtility.changeCase(DBUtility.getTableNameByClassName(modelClass.getName())), columnName, columnType);
    }

    public static synchronized <T> T max(String tableName, String columnName, Class<T> columnType) {
        ClusterQuery cQuery = new ClusterQuery();
        return cQuery.max(tableName, columnName, columnType);
    }

    public static <T> FindExecutor maxAsync(final String tableName, final String columnName, final Class<T> columnType) {
        final FindExecutor executor = new FindExecutor();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<DataSupport> clazz = DataSupport.class;
                synchronized (DataSupport.class) {
                    final Object t = DataSupport.max(tableName, columnName, columnType);
                    if (executor.getListener() != null) {
                        LitePal.getHandler().post(new Runnable(){

                            @Override
                            public void run() {
                                executor.getListener().onFinish(t);
                            }
                        });
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        };
        executor.submit(runnable);
        return executor;
    }

    public static synchronized <T> T min(Class<?> modelClass, String columnName, Class<T> columnType) {
        return DataSupport.min(BaseUtility.changeCase(DBUtility.getTableNameByClassName(modelClass.getName())), columnName, columnType);
    }

    public static <T> FindExecutor minAsync(Class<?> modelClass, String columnName, Class<T> columnType) {
        return DataSupport.minAsync(BaseUtility.changeCase(DBUtility.getTableNameByClassName(modelClass.getName())), columnName, columnType);
    }

    public static synchronized <T> T min(String tableName, String columnName, Class<T> columnType) {
        ClusterQuery cQuery = new ClusterQuery();
        return cQuery.min(tableName, columnName, columnType);
    }

    public static <T> FindExecutor minAsync(final String tableName, final String columnName, final Class<T> columnType) {
        final FindExecutor executor = new FindExecutor();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<DataSupport> clazz = DataSupport.class;
                synchronized (DataSupport.class) {
                    final Object t = DataSupport.min(tableName, columnName, columnType);
                    if (executor.getListener() != null) {
                        LitePal.getHandler().post(new Runnable(){

                            @Override
                            public void run() {
                                executor.getListener().onFinish(t);
                            }
                        });
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        };
        executor.submit(runnable);
        return executor;
    }

    public static synchronized <T> T sum(Class<?> modelClass, String columnName, Class<T> columnType) {
        return DataSupport.sum(BaseUtility.changeCase(DBUtility.getTableNameByClassName(modelClass.getName())), columnName, columnType);
    }

    public static <T> FindExecutor sumAsync(Class<?> modelClass, String columnName, Class<T> columnType) {
        return DataSupport.sumAsync(BaseUtility.changeCase(DBUtility.getTableNameByClassName(modelClass.getName())), columnName, columnType);
    }

    public static synchronized <T> T sum(String tableName, String columnName, Class<T> columnType) {
        ClusterQuery cQuery = new ClusterQuery();
        return cQuery.sum(tableName, columnName, columnType);
    }

    public static <T> FindExecutor sumAsync(final String tableName, final String columnName, final Class<T> columnType) {
        final FindExecutor executor = new FindExecutor();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<DataSupport> clazz = DataSupport.class;
                synchronized (DataSupport.class) {
                    final Object t = DataSupport.sum(tableName, columnName, columnType);
                    if (executor.getListener() != null) {
                        LitePal.getHandler().post(new Runnable(){

                            @Override
                            public void run() {
                                executor.getListener().onFinish(t);
                            }
                        });
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        };
        executor.submit(runnable);
        return executor;
    }

    public static synchronized <T> T find(Class<T> modelClass, long id2) {
        return DataSupport.find(modelClass, id2, false);
    }

    public static <T> FindExecutor findAsync(Class<T> modelClass, long id2) {
        return DataSupport.findAsync(modelClass, id2, false);
    }

    public static synchronized <T> T find(Class<T> modelClass, long id2, boolean isEager) {
        QueryHandler queryHandler = new QueryHandler(Connector.getDatabase());
        return queryHandler.onFind(modelClass, id2, isEager);
    }

    public static <T> FindExecutor findAsync(final Class<T> modelClass, final long id2, final boolean isEager) {
        final FindExecutor executor = new FindExecutor();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<DataSupport> clazz = DataSupport.class;
                synchronized (DataSupport.class) {
                    final Object t = DataSupport.find(modelClass, id2, isEager);
                    if (executor.getListener() != null) {
                        LitePal.getHandler().post(new Runnable(){

                            @Override
                            public void run() {
                                executor.getListener().onFinish(t);
                            }
                        });
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        };
        executor.submit(runnable);
        return executor;
    }

    public static synchronized <T> T findFirst(Class<T> modelClass) {
        return DataSupport.findFirst(modelClass, false);
    }

    public static <T> FindExecutor findFirstAsync(Class<T> modelClass) {
        return DataSupport.findFirstAsync(modelClass, false);
    }

    public static synchronized <T> T findFirst(Class<T> modelClass, boolean isEager) {
        QueryHandler queryHandler = new QueryHandler(Connector.getDatabase());
        return queryHandler.onFindFirst(modelClass, isEager);
    }

    public static <T> FindExecutor findFirstAsync(final Class<T> modelClass, final boolean isEager) {
        final FindExecutor executor = new FindExecutor();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<DataSupport> clazz = DataSupport.class;
                synchronized (DataSupport.class) {
                    final Object t = DataSupport.findFirst(modelClass, isEager);
                    if (executor.getListener() != null) {
                        LitePal.getHandler().post(new Runnable(){

                            @Override
                            public void run() {
                                executor.getListener().onFinish(t);
                            }
                        });
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        };
        executor.submit(runnable);
        return executor;
    }

    public static synchronized <T> T findLast(Class<T> modelClass) {
        return DataSupport.findLast(modelClass, false);
    }

    public static <T> FindExecutor findLastAsync(Class<T> modelClass) {
        return DataSupport.findLastAsync(modelClass, false);
    }

    public static synchronized <T> T findLast(Class<T> modelClass, boolean isEager) {
        QueryHandler queryHandler = new QueryHandler(Connector.getDatabase());
        return queryHandler.onFindLast(modelClass, isEager);
    }

    public static <T> FindExecutor findLastAsync(final Class<T> modelClass, final boolean isEager) {
        final FindExecutor executor = new FindExecutor();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<DataSupport> clazz = DataSupport.class;
                synchronized (DataSupport.class) {
                    final Object t = DataSupport.findLast(modelClass, isEager);
                    if (executor.getListener() != null) {
                        LitePal.getHandler().post(new Runnable(){

                            @Override
                            public void run() {
                                executor.getListener().onFinish(t);
                            }
                        });
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        };
        executor.submit(runnable);
        return executor;
    }

    public static synchronized <T> List<T> findAll(Class<T> modelClass, long ... ids) {
        return DataSupport.findAll(modelClass, false, ids);
    }

    public static <T> FindMultiExecutor findAllAsync(Class<T> modelClass, long ... ids) {
        return DataSupport.findAllAsync(modelClass, false, ids);
    }

    public static synchronized <T> List<T> findAll(Class<T> modelClass, boolean isEager, long ... ids) {
        QueryHandler queryHandler = new QueryHandler(Connector.getDatabase());
        return queryHandler.onFindAll(modelClass, isEager, ids);
    }

    public static <T> FindMultiExecutor findAllAsync(final Class<T> modelClass, final boolean isEager, final long ... ids) {
        final FindMultiExecutor executor = new FindMultiExecutor();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<DataSupport> clazz = DataSupport.class;
                synchronized (DataSupport.class) {
                    final List t = DataSupport.findAll(modelClass, isEager, ids);
                    if (executor.getListener() != null) {
                        LitePal.getHandler().post(new Runnable(){

                            @Override
                            public void run() {
                                executor.getListener().onFinish(t);
                            }
                        });
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        };
        executor.submit(runnable);
        return executor;
    }

    public static synchronized Cursor findBySQL(String ... sql) {
        String[] selectionArgs;
        BaseUtility.checkConditionsCorrect(sql);
        if (sql == null) {
            return null;
        }
        if (sql.length <= 0) {
            return null;
        }
        if (sql.length == 1) {
            selectionArgs = null;
        } else {
            selectionArgs = new String[sql.length - 1];
            System.arraycopy(sql, 1, selectionArgs, 0, sql.length - 1);
        }
        return Connector.getDatabase().rawQuery(sql[0], selectionArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized int delete(Class<?> modelClass, long id2) {
        int rowsAffected = 0;
        SQLiteDatabase db = Connector.getDatabase();
        db.beginTransaction();
        try {
            DeleteHandler deleteHandler = new DeleteHandler(db);
            rowsAffected = deleteHandler.onDelete(modelClass, id2);
            db.setTransactionSuccessful();
            int n = rowsAffected;
            return n;
        }
        finally {
            db.endTransaction();
        }
    }

    public static UpdateOrDeleteExecutor deleteAsync(final Class<?> modelClass, final long id2) {
        final UpdateOrDeleteExecutor executor = new UpdateOrDeleteExecutor();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<DataSupport> clazz = DataSupport.class;
                synchronized (DataSupport.class) {
                    final int rowsAffected = DataSupport.delete(modelClass, id2);
                    if (executor.getListener() != null) {
                        LitePal.getHandler().post(new Runnable(){

                            @Override
                            public void run() {
                                executor.getListener().onFinish(rowsAffected);
                            }
                        });
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        };
        executor.submit(runnable);
        return executor;
    }

    public static synchronized int deleteAll(Class<?> modelClass, String ... conditions) {
        DeleteHandler deleteHandler = new DeleteHandler(Connector.getDatabase());
        return deleteHandler.onDeleteAll(modelClass, conditions);
    }

    public static UpdateOrDeleteExecutor deleteAllAsync(final Class<?> modelClass, final String ... conditions) {
        final UpdateOrDeleteExecutor executor = new UpdateOrDeleteExecutor();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<DataSupport> clazz = DataSupport.class;
                synchronized (DataSupport.class) {
                    final int rowsAffected = DataSupport.deleteAll(modelClass, conditions);
                    if (executor.getListener() != null) {
                        LitePal.getHandler().post(new Runnable(){

                            @Override
                            public void run() {
                                executor.getListener().onFinish(rowsAffected);
                            }
                        });
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        };
        executor.submit(runnable);
        return executor;
    }

    public static synchronized int deleteAll(String tableName, String ... conditions) {
        DeleteHandler deleteHandler = new DeleteHandler(Connector.getDatabase());
        return deleteHandler.onDeleteAll(tableName, conditions);
    }

    public static UpdateOrDeleteExecutor deleteAllAsync(final String tableName, final String ... conditions) {
        final UpdateOrDeleteExecutor executor = new UpdateOrDeleteExecutor();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<DataSupport> clazz = DataSupport.class;
                synchronized (DataSupport.class) {
                    final int rowsAffected = DataSupport.deleteAll(tableName, conditions);
                    if (executor.getListener() != null) {
                        LitePal.getHandler().post(new Runnable(){

                            @Override
                            public void run() {
                                executor.getListener().onFinish(rowsAffected);
                            }
                        });
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        };
        executor.submit(runnable);
        return executor;
    }

    public static synchronized int update(Class<?> modelClass, ContentValues values, long id2) {
        UpdateHandler updateHandler = new UpdateHandler(Connector.getDatabase());
        return updateHandler.onUpdate(modelClass, id2, values);
    }

    public static UpdateOrDeleteExecutor updateAsync(final Class<?> modelClass, final ContentValues values, final long id2) {
        final UpdateOrDeleteExecutor executor = new UpdateOrDeleteExecutor();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<DataSupport> clazz = DataSupport.class;
                synchronized (DataSupport.class) {
                    final int rowsAffected = DataSupport.update(modelClass, values, id2);
                    if (executor.getListener() != null) {
                        LitePal.getHandler().post(new Runnable(){

                            @Override
                            public void run() {
                                executor.getListener().onFinish(rowsAffected);
                            }
                        });
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        };
        executor.submit(runnable);
        return executor;
    }

    public static synchronized int updateAll(Class<?> modelClass, ContentValues values, String ... conditions) {
        return DataSupport.updateAll(BaseUtility.changeCase(DBUtility.getTableNameByClassName(modelClass.getName())), values, conditions);
    }

    public static UpdateOrDeleteExecutor updateAllAsync(Class<?> modelClass, ContentValues values, String ... conditions) {
        return DataSupport.updateAllAsync(BaseUtility.changeCase(DBUtility.getTableNameByClassName(modelClass.getName())), values, conditions);
    }

    public static synchronized int updateAll(String tableName, ContentValues values, String ... conditions) {
        UpdateHandler updateHandler = new UpdateHandler(Connector.getDatabase());
        return updateHandler.onUpdateAll(tableName, values, conditions);
    }

    public static UpdateOrDeleteExecutor updateAllAsync(final String tableName, final ContentValues values, final String ... conditions) {
        final UpdateOrDeleteExecutor executor = new UpdateOrDeleteExecutor();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<DataSupport> clazz = DataSupport.class;
                synchronized (DataSupport.class) {
                    final int rowsAffected = DataSupport.updateAll(tableName, values, conditions);
                    if (executor.getListener() != null) {
                        LitePal.getHandler().post(new Runnable(){

                            @Override
                            public void run() {
                                executor.getListener().onFinish(rowsAffected);
                            }
                        });
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        };
        executor.submit(runnable);
        return executor;
    }

    public static synchronized <T extends DataSupport> void saveAll(Collection<T> collection) {
        SQLiteDatabase db = Connector.getDatabase();
        db.beginTransaction();
        try {
            SaveHandler saveHandler = new SaveHandler(db);
            saveHandler.onSaveAll(collection);
            db.setTransactionSuccessful();
        }
        catch (Exception e) {
            throw new DataSupportException(e.getMessage(), e);
        }
        finally {
            db.endTransaction();
        }
    }

    public static <T extends DataSupport> SaveExecutor saveAllAsync(final Collection<T> collection) {
        final SaveExecutor executor = new SaveExecutor();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<DataSupport> clazz = DataSupport.class;
                synchronized (DataSupport.class) {
                    boolean success;
                    try {
                        DataSupport.saveAll(collection);
                        success = true;
                    }
                    catch (Exception e) {
                        success = false;
                    }
                    final boolean result = success;
                    if (executor.getListener() != null) {
                        LitePal.getHandler().post(new Runnable(){

                            @Override
                            public void run() {
                                executor.getListener().onFinish(result);
                            }
                        });
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        };
        executor.submit(runnable);
        return executor;
    }

    public static <T extends DataSupport> void markAsDeleted(Collection<T> collection) {
        for (DataSupport t : collection) {
            t.clearSavedState();
        }
    }

    public static <T> boolean isExist(Class<T> modelClass, String ... conditions) {
        if (conditions == null) {
            return false;
        }
        return DataSupport.where(conditions).count(modelClass) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int delete() {
        SQLiteDatabase db = Connector.getDatabase();
        db.beginTransaction();
        try {
            DeleteHandler deleteHandler = new DeleteHandler(db);
            int rowsAffected = deleteHandler.onDelete(this);
            this.baseObjId = 0L;
            db.setTransactionSuccessful();
            int n = rowsAffected;
            return n;
        }
        finally {
            db.endTransaction();
        }
    }

    public UpdateOrDeleteExecutor deleteAsync() {
        final UpdateOrDeleteExecutor executor = new UpdateOrDeleteExecutor();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<DataSupport> clazz = DataSupport.class;
                synchronized (DataSupport.class) {
                    final int rowsAffected = DataSupport.this.delete();
                    if (executor.getListener() != null) {
                        LitePal.getHandler().post(new Runnable(){

                            @Override
                            public void run() {
                                executor.getListener().onFinish(rowsAffected);
                            }
                        });
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        };
        executor.submit(runnable);
        return executor;
    }

    public synchronized int update(long id2) {
        try {
            UpdateHandler updateHandler = new UpdateHandler(Connector.getDatabase());
            int rowsAffected = updateHandler.onUpdate(this, id2);
            this.getFieldsToSetToDefault().clear();
            return rowsAffected;
        }
        catch (Exception e) {
            throw new DataSupportException(e.getMessage(), e);
        }
    }

    public UpdateOrDeleteExecutor updateAsync(final long id2) {
        final UpdateOrDeleteExecutor executor = new UpdateOrDeleteExecutor();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<DataSupport> clazz = DataSupport.class;
                synchronized (DataSupport.class) {
                    final int rowsAffected = DataSupport.this.update(id2);
                    if (executor.getListener() != null) {
                        LitePal.getHandler().post(new Runnable(){

                            @Override
                            public void run() {
                                executor.getListener().onFinish(rowsAffected);
                            }
                        });
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        };
        executor.submit(runnable);
        return executor;
    }

    public synchronized int updateAll(String ... conditions) {
        try {
            UpdateHandler updateHandler = new UpdateHandler(Connector.getDatabase());
            int rowsAffected = updateHandler.onUpdateAll(this, conditions);
            this.getFieldsToSetToDefault().clear();
            return rowsAffected;
        }
        catch (Exception e) {
            throw new DataSupportException(e.getMessage(), e);
        }
    }

    public UpdateOrDeleteExecutor updateAllAsync(final String ... conditions) {
        final UpdateOrDeleteExecutor executor = new UpdateOrDeleteExecutor();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<DataSupport> clazz = DataSupport.class;
                synchronized (DataSupport.class) {
                    final int rowsAffected = DataSupport.this.updateAll(conditions);
                    if (executor.getListener() != null) {
                        LitePal.getHandler().post(new Runnable(){

                            @Override
                            public void run() {
                                executor.getListener().onFinish(rowsAffected);
                            }
                        });
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        };
        executor.submit(runnable);
        return executor;
    }

    public synchronized boolean save() {
        try {
            this.saveThrows();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public SaveExecutor saveAsync() {
        final SaveExecutor executor = new SaveExecutor();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<DataSupport> clazz = DataSupport.class;
                synchronized (DataSupport.class) {
                    final boolean success = DataSupport.this.save();
                    if (executor.getListener() != null) {
                        LitePal.getHandler().post(new Runnable(){

                            @Override
                            public void run() {
                                executor.getListener().onFinish(success);
                            }
                        });
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        };
        executor.submit(runnable);
        return executor;
    }

    public synchronized void saveThrows() {
        SQLiteDatabase db = Connector.getDatabase();
        db.beginTransaction();
        try {
            SaveHandler saveHandler = new SaveHandler(db);
            saveHandler.onSave(this);
            this.clearAssociatedData();
            db.setTransactionSuccessful();
        }
        catch (Exception e) {
            throw new DataSupportException(e.getMessage(), e);
        }
        finally {
            db.endTransaction();
        }
    }

    @Deprecated
    public synchronized boolean saveIfNotExist(String ... conditions) {
        if (!DataSupport.isExist(this.getClass(), conditions)) {
            return this.save();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean saveOrUpdate(String ... conditions) {
        if (conditions == null) {
            return this.save();
        }
        List<?> list = DataSupport.where(conditions).find(this.getClass());
        if (list.isEmpty()) {
            return this.save();
        }
        SQLiteDatabase db = Connector.getDatabase();
        db.beginTransaction();
        try {
            for (DataSupport dataSupport : list) {
                this.baseObjId = dataSupport.getBaseObjId();
                SaveHandler saveHandler = new SaveHandler(db);
                saveHandler.onSave(this);
                this.clearAssociatedData();
            }
            db.setTransactionSuccessful();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            db.endTransaction();
        }
    }

    public SaveExecutor saveOrUpdateAsync(final String ... conditions) {
        final SaveExecutor executor = new SaveExecutor();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<DataSupport> clazz = DataSupport.class;
                synchronized (DataSupport.class) {
                    final boolean success = DataSupport.this.saveOrUpdate(conditions);
                    if (executor.getListener() != null) {
                        LitePal.getHandler().post(new Runnable(){

                            @Override
                            public void run() {
                                executor.getListener().onFinish(success);
                            }
                        });
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        };
        executor.submit(runnable);
        return executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public synchronized boolean saveFast() {
        SQLiteDatabase db = Connector.getDatabase();
        db.beginTransaction();
        try {
            SaveHandler saveHandler = new SaveHandler(db);
            saveHandler.onSaveFast(this);
            db.setTransactionSuccessful();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            db.endTransaction();
        }
    }

    public boolean isSaved() {
        return this.baseObjId > 0L;
    }

    public void clearSavedState() {
        this.baseObjId = 0L;
    }

    public void setToDefault(String fieldName) {
        this.getFieldsToSetToDefault().add(fieldName);
    }

    public void assignBaseObjId(int baseObjId) {
        this.baseObjId = baseObjId;
    }

    protected DataSupport() {
    }

    protected long getBaseObjId() {
        return this.baseObjId;
    }

    protected String getClassName() {
        return this.getClass().getName();
    }

    protected String getTableName() {
        return BaseUtility.changeCase(DBUtility.getTableNameByClassName(this.getClassName()));
    }

    List<String> getFieldsToSetToDefault() {
        if (this.fieldsToSetToDefault == null) {
            this.fieldsToSetToDefault = new ArrayList<String>();
        }
        return this.fieldsToSetToDefault;
    }

    void addAssociatedModelWithFK(String associatedTableName, long associatedId) {
        Set<Long> associatedIdsWithFKSet = this.getAssociatedModelsMapWithFK().get(associatedTableName);
        if (associatedIdsWithFKSet == null) {
            associatedIdsWithFKSet = new HashSet<Long>();
            associatedIdsWithFKSet.add(associatedId);
            this.associatedModelsMapWithFK.put(associatedTableName, associatedIdsWithFKSet);
        } else {
            associatedIdsWithFKSet.add(associatedId);
        }
    }

    Map<String, Set<Long>> getAssociatedModelsMapWithFK() {
        if (this.associatedModelsMapWithFK == null) {
            this.associatedModelsMapWithFK = new HashMap<String, Set<Long>>();
        }
        return this.associatedModelsMapWithFK;
    }

    void addAssociatedModelForJoinTable(String associatedModelName, long associatedId) {
        Set<Long> associatedIdsM2MSet = this.getAssociatedModelsMapForJoinTable().get(associatedModelName);
        if (associatedIdsM2MSet == null) {
            associatedIdsM2MSet = new HashSet<Long>();
            associatedIdsM2MSet.add(associatedId);
            this.associatedModelsMapForJoinTable.put(associatedModelName, associatedIdsM2MSet);
        } else {
            associatedIdsM2MSet.add(associatedId);
        }
    }

    void addEmptyModelForJoinTable(String associatedModelName) {
        Set<Long> associatedIdsM2MSet = this.getAssociatedModelsMapForJoinTable().get(associatedModelName);
        if (associatedIdsM2MSet == null) {
            associatedIdsM2MSet = new HashSet<Long>();
            this.associatedModelsMapForJoinTable.put(associatedModelName, associatedIdsM2MSet);
        }
    }

    Map<String, Set<Long>> getAssociatedModelsMapForJoinTable() {
        if (this.associatedModelsMapForJoinTable == null) {
            this.associatedModelsMapForJoinTable = new HashMap<String, Set<Long>>();
        }
        return this.associatedModelsMapForJoinTable;
    }

    void addAssociatedModelWithoutFK(String associatedTableName, long associatedId) {
        this.getAssociatedModelsMapWithoutFK().put(associatedTableName, associatedId);
    }

    Map<String, Long> getAssociatedModelsMapWithoutFK() {
        if (this.associatedModelsMapWithoutFK == null) {
            this.associatedModelsMapWithoutFK = new HashMap<String, Long>();
        }
        return this.associatedModelsMapWithoutFK;
    }

    void addFKNameToClearSelf(String foreignKeyName) {
        List<String> list = this.getListToClearSelfFK();
        if (!list.contains(foreignKeyName)) {
            list.add(foreignKeyName);
        }
    }

    List<String> getListToClearSelfFK() {
        if (this.listToClearSelfFK == null) {
            this.listToClearSelfFK = new ArrayList<String>();
        }
        return this.listToClearSelfFK;
    }

    void addAssociatedTableNameToClearFK(String associatedTableName) {
        List<String> list = this.getListToClearAssociatedFK();
        if (!list.contains(associatedTableName)) {
            list.add(associatedTableName);
        }
    }

    List<String> getListToClearAssociatedFK() {
        if (this.listToClearAssociatedFK == null) {
            this.listToClearAssociatedFK = new ArrayList<String>();
        }
        return this.listToClearAssociatedFK;
    }

    void clearAssociatedData() {
        this.clearIdOfModelWithFK();
        this.clearIdOfModelWithoutFK();
        this.clearIdOfModelForJoinTable();
        this.clearFKNameList();
    }

    private void clearIdOfModelWithFK() {
        for (String associatedModelName : this.getAssociatedModelsMapWithFK().keySet()) {
            this.associatedModelsMapWithFK.get(associatedModelName).clear();
        }
        this.associatedModelsMapWithFK.clear();
    }

    private void clearIdOfModelWithoutFK() {
        this.getAssociatedModelsMapWithoutFK().clear();
    }

    private void clearIdOfModelForJoinTable() {
        for (String associatedModelName : this.getAssociatedModelsMapForJoinTable().keySet()) {
            this.associatedModelsMapForJoinTable.get(associatedModelName).clear();
        }
        this.associatedModelsMapForJoinTable.clear();
    }

    private void clearFKNameList() {
        this.getListToClearSelfFK().clear();
        this.getListToClearAssociatedFK().clear();
    }
}

