/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.litepal.crud;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.util.SparseArray;
import com.komect.network.litepal.LitePalBase;
import com.komect.network.litepal.annotation.Encrypt;
import com.komect.network.litepal.crud.DataSupport;
import com.komect.network.litepal.crud.DynamicExecutor;
import com.komect.network.litepal.crud.Many2ManyAnalyzer;
import com.komect.network.litepal.crud.Many2OneAnalyzer;
import com.komect.network.litepal.crud.One2OneAnalyzer;
import com.komect.network.litepal.crud.SaveHandler;
import com.komect.network.litepal.crud.UpdateHandler;
import com.komect.network.litepal.crud.model.AssociationsInfo;
import com.komect.network.litepal.exceptions.DataSupportException;
import com.komect.network.litepal.exceptions.DatabaseGenerateException;
import com.komect.network.litepal.tablemanager.model.GenericModel;
import com.komect.network.litepal.util.BaseUtility;
import com.komect.network.litepal.util.DBUtility;
import com.komect.network.litepal.util.cipher.CipherUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

abstract class DataHandler
extends LitePalBase {
    public static final String TAG = "DataHandler";
    SQLiteDatabase mDatabase;
    private DataSupport tempEmptyModel;
    private List<AssociationsInfo> fkInCurrentModel;
    private List<AssociationsInfo> fkInOtherModel;

    DataHandler() {
    }

    protected <T> List<T> query(Class<T> modelClass, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit, List<AssociationsInfo> foreignKeyAssociations) {
        ArrayList<Object> dataList = new ArrayList<Object>();
        try (Cursor cursor = null;){
            List<Field> supportedFields = this.getSupportedFields(modelClass.getName());
            List<Field> supportedGenericFields = this.getSupportedGenericFields(modelClass.getName());
            String[] customizedColumns = DBUtility.convertSelectClauseToValidNames(this.getCustomizedColumns(columns, supportedGenericFields, foreignKeyAssociations));
            String tableName = this.getTableName(modelClass);
            cursor = this.mDatabase.query(tableName, customizedColumns, selection, selectionArgs, groupBy, having, orderBy, limit);
            if (cursor.moveToFirst()) {
                SparseArray queryInfoCacheSparseArray = new SparseArray();
                HashMap<Field, GenericModel> genericModelMap = new HashMap<Field, GenericModel>();
                do {
                    Object modelInstance = this.createInstanceFromClass(modelClass);
                    this.giveBaseObjIdValue((DataSupport)modelInstance, cursor.getLong(cursor.getColumnIndexOrThrow("id")));
                    this.setValueToModel(modelInstance, supportedFields, foreignKeyAssociations, cursor, (SparseArray<QueryInfoCache>)queryInfoCacheSparseArray);
                    this.setGenericValueToModel((DataSupport)modelInstance, supportedGenericFields, genericModelMap);
                    if (foreignKeyAssociations != null) {
                        this.setAssociatedModel((DataSupport)modelInstance);
                    }
                    dataList.add(modelInstance);
                } while (cursor.moveToNext());
                queryInfoCacheSparseArray.clear();
                genericModelMap.clear();
            }
            ArrayList<Object> arrayList = dataList;
            return arrayList;
        }
    }

    protected <T> T mathQuery(String tableName, String[] columns, String[] conditions, Class<T> type) {
        BaseUtility.checkConditionsCorrect(conditions);
        Object result = null;
        try (Cursor cursor = null;){
            cursor = this.mDatabase.query(tableName, columns, this.getWhereClause(conditions), this.getWhereArgs(conditions), null, null, null);
            if (cursor.moveToFirst()) {
                Class<?> cursorClass = cursor.getClass();
                Method method = cursorClass.getMethod(this.genGetColumnMethod(type), Integer.TYPE);
                result = method.invoke((Object)cursor, 0);
            }
        }
        return (T)result;
    }

    protected void giveBaseObjIdValue(DataSupport baseObj, long id2) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        if (id2 > 0L) {
            DynamicExecutor.set(baseObj, "baseObjId", id2, DataSupport.class);
        }
    }

    protected void putFieldsValue(DataSupport baseObj, List<Field> supportedFields, ContentValues values) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        for (Field field : supportedFields) {
            if (this.isIdColumn(field.getName())) continue;
            this.putFieldsValueDependsOnSaveOrUpdate(baseObj, field, values);
        }
    }

    protected void putContentValuesForSave(DataSupport baseObj, Field field, ContentValues values) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object fieldValue = DynamicExecutor.getField(baseObj, field.getName(), baseObj.getClass());
        if (fieldValue != null) {
            Encrypt annotation;
            if ("java.util.Date".equals(field.getType().getName())) {
                Date date = (Date)fieldValue;
                fieldValue = date.getTime();
            }
            if ((annotation = field.getAnnotation(Encrypt.class)) != null && "java.lang.String".equals(field.getType().getName())) {
                fieldValue = this.encryptValue(annotation.algorithm(), fieldValue);
            }
            Object[] parameters = new Object[]{BaseUtility.changeCase(DBUtility.convertToValidColumnName(field.getName())), fieldValue};
            Class<?>[] parameterTypes = this.getParameterTypes(field, fieldValue, parameters);
            DynamicExecutor.send(values, "put", parameters, values.getClass(), parameterTypes);
        }
    }

    protected void putContentValuesForUpdate(DataSupport baseObj, Field field, ContentValues values) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Encrypt annotation;
        Object fieldValue = this.getFieldValue(baseObj, field);
        if ("java.util.Date".equals(field.getType().getName()) && fieldValue != null) {
            Date date = (Date)fieldValue;
            fieldValue = date.getTime();
        }
        if ((annotation = field.getAnnotation(Encrypt.class)) != null && "java.lang.String".equals(field.getType().getName())) {
            fieldValue = this.encryptValue(annotation.algorithm(), fieldValue);
        }
        Object[] parameters = new Object[]{BaseUtility.changeCase(DBUtility.convertToValidColumnName(field.getName())), fieldValue};
        Class<?>[] parameterTypes = this.getParameterTypes(field, fieldValue, parameters);
        DynamicExecutor.send(values, "put", parameters, values.getClass(), parameterTypes);
    }

    protected Object encryptValue(String algorithm, Object fieldValue) {
        if (algorithm != null && fieldValue != null) {
            if ("AES".equalsIgnoreCase(algorithm)) {
                fieldValue = CipherUtil.aesEncrypt((String)fieldValue);
            } else if ("MD5".equalsIgnoreCase(algorithm)) {
                fieldValue = CipherUtil.md5Encrypt((String)fieldValue);
            }
        }
        return fieldValue;
    }

    protected Object getFieldValue(DataSupport dataSupport, Field field) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (this.shouldGetOrSet(dataSupport, field)) {
            return DynamicExecutor.getField(dataSupport, field.getName(), dataSupport.getClass());
        }
        return null;
    }

    protected void setFieldValue(DataSupport dataSupport, Field field, Object parameter) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (this.shouldGetOrSet(dataSupport, field)) {
            DynamicExecutor.setField(dataSupport, field.getName(), parameter, dataSupport.getClass());
        }
    }

    protected void analyzeAssociatedModels(DataSupport baseObj, Collection<AssociationsInfo> associationInfos) {
        try {
            for (AssociationsInfo associationInfo : associationInfos) {
                if (associationInfo.getAssociationType() == 2) {
                    new Many2OneAnalyzer().analyze(baseObj, associationInfo);
                    continue;
                }
                if (associationInfo.getAssociationType() == 1) {
                    new One2OneAnalyzer().analyze(baseObj, associationInfo);
                    continue;
                }
                if (associationInfo.getAssociationType() != 3) continue;
                new Many2ManyAnalyzer().analyze(baseObj, associationInfo);
            }
        }
        catch (Exception e) {
            throw new DataSupportException(e.getMessage(), e);
        }
    }

    protected DataSupport getAssociatedModel(DataSupport baseObj, AssociationsInfo associationInfo) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return (DataSupport)this.getFieldValue(baseObj, associationInfo.getAssociateOtherModelFromSelf());
    }

    protected Collection<DataSupport> getAssociatedModels(DataSupport baseObj, AssociationsInfo associationInfo) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return (Collection)this.getFieldValue(baseObj, associationInfo.getAssociateOtherModelFromSelf());
    }

    protected DataSupport getEmptyModel(DataSupport baseObj) {
        if (this.tempEmptyModel != null) {
            return this.tempEmptyModel;
        }
        String className = null;
        try {
            className = baseObj.getClassName();
            Class<?> modelClass = Class.forName(className);
            this.tempEmptyModel = (DataSupport)modelClass.newInstance();
            return this.tempEmptyModel;
        }
        catch (ClassNotFoundException e) {
            throw new DatabaseGenerateException("can not find a class named " + className);
        }
        catch (InstantiationException e) {
            throw new DataSupportException(className + " needs a default constructor.", e);
        }
        catch (Exception e) {
            throw new DataSupportException(e.getMessage(), e);
        }
    }

    protected String getWhereClause(String ... conditions) {
        if (this.isAffectAllLines(new Object[]{conditions})) {
            return null;
        }
        if (conditions != null && conditions.length > 0) {
            return conditions[0];
        }
        return null;
    }

    protected String[] getWhereArgs(String ... conditions) {
        if (this.isAffectAllLines(new Object[]{conditions})) {
            return null;
        }
        if (conditions != null && conditions.length > 1) {
            String[] whereArgs = new String[conditions.length - 1];
            System.arraycopy(conditions, 1, whereArgs, 0, conditions.length - 1);
            return whereArgs;
        }
        return null;
    }

    protected boolean isAffectAllLines(Object ... conditions) {
        return conditions != null && conditions.length == 0;
    }

    protected String getWhereOfIdsWithOr(Collection<Long> ids) {
        StringBuilder whereClause = new StringBuilder();
        boolean needOr = false;
        for (long id2 : ids) {
            if (needOr) {
                whereClause.append(" or ");
            }
            needOr = true;
            whereClause.append("id = ");
            whereClause.append(id2);
        }
        return BaseUtility.changeCase(whereClause.toString());
    }

    protected String getWhereOfIdsWithOr(long ... ids) {
        StringBuilder whereClause = new StringBuilder();
        boolean needOr = false;
        for (long id2 : ids) {
            if (needOr) {
                whereClause.append(" or ");
            }
            needOr = true;
            whereClause.append("id = ");
            whereClause.append(id2);
        }
        return BaseUtility.changeCase(whereClause.toString());
    }

    protected boolean shouldGetOrSet(DataSupport dataSupport, Field field) {
        return dataSupport != null && field != null;
    }

    protected String getIntermediateTableName(DataSupport baseObj, String associatedTableName) {
        return BaseUtility.changeCase(DBUtility.getIntermediateTableName(baseObj.getTableName(), associatedTableName));
    }

    protected String getTableName(Class<?> modelClass) {
        return BaseUtility.changeCase(DBUtility.getTableNameByClassName(modelClass.getName()));
    }

    protected Object createInstanceFromClass(Class<?> modelClass) {
        try {
            Constructor<?> constructor = this.findBestSuitConstructor(modelClass);
            return constructor.newInstance(this.getConstructorParams(modelClass, constructor));
        }
        catch (Exception e) {
            throw new DataSupportException(e.getMessage(), e);
        }
    }

    protected Constructor<?> findBestSuitConstructor(Class<?> modelClass) {
        Constructor<?>[] constructors = modelClass.getDeclaredConstructors();
        SparseArray map = new SparseArray();
        int minKey = Integer.MAX_VALUE;
        for (Constructor<?> constructor : constructors) {
            Class<?>[] types;
            int key = constructor.getParameterTypes().length;
            for (Class<?> parameterType : types = constructor.getParameterTypes()) {
                if (parameterType == modelClass) {
                    key += 10000;
                    continue;
                }
                if (!parameterType.getName().equals("com.android.tools.fd.runtime.InstantReloadException")) continue;
                key += 10000;
            }
            if (map.get(key) == null) {
                map.put(key, constructor);
            }
            if (key >= minKey) continue;
            minKey = key;
        }
        Constructor bestSuitConstructor = (Constructor)map.get(minKey);
        if (bestSuitConstructor != null) {
            bestSuitConstructor.setAccessible(true);
        }
        return bestSuitConstructor;
    }

    protected Object[] getConstructorParams(Class<?> modelClass, Constructor<?> constructor) {
        Class<?>[] paramTypes = constructor.getParameterTypes();
        Object[] params = new Object[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            params[i] = this.getInitParamValue(modelClass, paramTypes[i]);
        }
        return params;
    }

    protected void setValueToModel(Object modelInstance, List<Field> supportedFields, List<AssociationsInfo> foreignKeyAssociations, Cursor cursor, SparseArray<QueryInfoCache> sparseArray) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        int cacheSize = sparseArray.size();
        if (cacheSize > 0) {
            for (int i = 0; i < cacheSize; ++i) {
                int columnIndex = sparseArray.keyAt(i);
                QueryInfoCache cache = (QueryInfoCache)sparseArray.get(columnIndex);
                this.setToModelByReflection(modelInstance, cache.field, columnIndex, cache.getMethodName, cursor);
            }
        } else {
            for (Field field : supportedFields) {
                String getMethodName = this.genGetColumnMethod(field);
                String columnName = this.isIdColumn(field.getName()) ? "id" : DBUtility.convertToValidColumnName(field.getName());
                int columnIndex = cursor.getColumnIndex(BaseUtility.changeCase(columnName));
                if (columnIndex == -1) continue;
                this.setToModelByReflection(modelInstance, field, columnIndex, getMethodName, cursor);
                QueryInfoCache cache = new QueryInfoCache();
                cache.getMethodName = getMethodName;
                cache.field = field;
                sparseArray.put(columnIndex, (Object)cache);
            }
        }
        if (foreignKeyAssociations != null) {
            for (AssociationsInfo associationInfo : foreignKeyAssociations) {
                String foreignKeyColumn = this.getForeignKeyColumnName(DBUtility.getTableNameByClassName(associationInfo.getAssociatedClassName()));
                int columnIndex = cursor.getColumnIndex(foreignKeyColumn);
                if (columnIndex == -1) continue;
                long associatedClassId = cursor.getLong(columnIndex);
                try {
                    DataSupport associatedObj = (DataSupport)DataSupport.find(Class.forName(associationInfo.getAssociatedClassName()), associatedClassId);
                    if (associatedObj == null) continue;
                    this.setFieldValue((DataSupport)modelInstance, associationInfo.getAssociateOtherModelFromSelf(), associatedObj);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setGenericValueToModel(DataSupport baseObj, List<Field> supportedGenericFields, Map<Field, GenericModel> genericModelMap) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        for (Field field : supportedGenericFields) {
            String getMethodName;
            String genericValueIdColumnName;
            String genericValueColumnName;
            String tableName;
            Cursor cursor = null;
            GenericModel genericModel = genericModelMap.get(field);
            if (genericModel == null) {
                tableName = DBUtility.getGenericTableName(baseObj.getClassName(), field.getName());
                genericValueColumnName = DBUtility.convertToValidColumnName(field.getName());
                genericValueIdColumnName = DBUtility.getGenericValueIdColumnName(baseObj.getClassName());
                getMethodName = this.genGetColumnMethod(field);
                GenericModel model = new GenericModel();
                model.setTableName(tableName);
                model.setValueColumnName(genericValueColumnName);
                model.setValueIdColumnName(genericValueIdColumnName);
                model.setGetMethodName(getMethodName);
                genericModelMap.put(field, model);
            } else {
                tableName = genericModel.getTableName();
                genericValueColumnName = genericModel.getValueColumnName();
                genericValueIdColumnName = genericModel.getValueIdColumnName();
                getMethodName = genericModel.getGetMethodName();
            }
            try {
                cursor = this.mDatabase.query(tableName, null, genericValueIdColumnName + " = ?", new String[]{String.valueOf(baseObj.getBaseObjId())}, null, null, null);
                if (!cursor.moveToFirst()) continue;
                do {
                    int columnIndex;
                    if ((columnIndex = cursor.getColumnIndex(BaseUtility.changeCase(genericValueColumnName))) == -1) continue;
                    this.setToModelByReflection(baseObj, field, columnIndex, getMethodName, cursor);
                } while (cursor.moveToNext());
            }
            finally {
                if (cursor == null) continue;
                cursor.close();
            }
        }
    }

    protected List<AssociationsInfo> getForeignKeyAssociations(String className, boolean isEager) {
        if (isEager) {
            this.analyzeAssociations(className);
            return this.fkInCurrentModel;
        }
        return null;
    }

    protected Class<?>[] getParameterTypes(Field field, Object fieldValue, Object[] parameters) {
        Class[] parameterTypes;
        if (this.isCharType(field)) {
            parameters[1] = String.valueOf(fieldValue);
            parameterTypes = new Class[]{String.class, String.class};
        } else {
            parameterTypes = field.getType().isPrimitive() ? new Class[]{String.class, this.getObjectType(field.getType())} : ("java.util.Date".equals(field.getType().getName()) ? new Class[]{String.class, Long.class} : new Class[]{String.class, field.getType()});
        }
        return parameterTypes;
    }

    private Class<?> getObjectType(Class<?> primitiveType) {
        if (primitiveType != null && primitiveType.isPrimitive()) {
            String basicTypeName = primitiveType.getName();
            if ("int".equals(basicTypeName)) {
                return Integer.class;
            }
            if ("short".equals(basicTypeName)) {
                return Short.class;
            }
            if ("long".equals(basicTypeName)) {
                return Long.class;
            }
            if ("float".equals(basicTypeName)) {
                return Float.class;
            }
            if ("double".equals(basicTypeName)) {
                return Double.class;
            }
            if ("boolean".equals(basicTypeName)) {
                return Boolean.class;
            }
            if ("char".equals(basicTypeName)) {
                return Character.class;
            }
        }
        return null;
    }

    private Object getInitParamValue(Class<?> modelClass, Class<?> paramType) {
        String paramTypeName = paramType.getName();
        if ("boolean".equals(paramTypeName) || "java.lang.Boolean".equals(paramTypeName)) {
            return false;
        }
        if ("float".equals(paramTypeName) || "java.lang.Float".equals(paramTypeName)) {
            return Float.valueOf(0.0f);
        }
        if ("double".equals(paramTypeName) || "java.lang.Double".equals(paramTypeName)) {
            return 0.0;
        }
        if ("int".equals(paramTypeName) || "java.lang.Integer".equals(paramTypeName)) {
            return 0;
        }
        if ("long".equals(paramTypeName) || "java.lang.Long".equals(paramTypeName)) {
            return 0L;
        }
        if ("short".equals(paramTypeName) || "java.lang.Short".equals(paramTypeName)) {
            return 0;
        }
        if ("char".equals(paramTypeName) || "java.lang.Character".equals(paramTypeName)) {
            return Character.valueOf(' ');
        }
        if ("[B".equals(paramTypeName) || "[Ljava.lang.Byte;".equals(paramTypeName)) {
            return new byte[0];
        }
        if ("java.lang.String".equals(paramTypeName)) {
            return "";
        }
        if (modelClass == paramType) {
            return null;
        }
        return this.createInstanceFromClass(paramType);
    }

    private boolean isCharType(Field field) {
        String type = field.getType().getName();
        return type.equals("char") || type.endsWith("Character");
    }

    private boolean isPrimitiveBooleanType(Field field) {
        Class<?> fieldType = field.getType();
        return "boolean".equals(fieldType.getName());
    }

    private void putFieldsValueDependsOnSaveOrUpdate(DataSupport baseObj, Field field, ContentValues values) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (this.isUpdating()) {
            if (!this.isFieldWithDefaultValue(baseObj, field)) {
                this.putContentValuesForUpdate(baseObj, field, values);
            }
        } else if (this.isSaving()) {
            this.putContentValuesForSave(baseObj, field, values);
        }
    }

    private boolean isUpdating() {
        return UpdateHandler.class.getName().equals(this.getClass().getName());
    }

    private boolean isSaving() {
        return SaveHandler.class.getName().equals(this.getClass().getName());
    }

    private boolean isFieldWithDefaultValue(DataSupport baseObj, Field field) throws IllegalAccessException, SecurityException, IllegalArgumentException, NoSuchMethodException, InvocationTargetException {
        DataSupport emptyModel = this.getEmptyModel(baseObj);
        Object realReturn = this.getFieldValue(baseObj, field);
        Object defaultReturn = this.getFieldValue(emptyModel, field);
        if (realReturn != null && defaultReturn != null) {
            String realFieldValue = realReturn.toString();
            String defaultFieldValue = defaultReturn.toString();
            return realFieldValue.equals(defaultFieldValue);
        }
        return realReturn == defaultReturn;
    }

    private String makeGetterMethodName(Field field) {
        String getterMethodPrefix;
        String fieldName = field.getName();
        if (this.isPrimitiveBooleanType(field)) {
            if (fieldName.matches("^is[A-Z]{1}.*$")) {
                fieldName = fieldName.substring(2);
            }
            getterMethodPrefix = "is";
        } else {
            getterMethodPrefix = "get";
        }
        if (fieldName.matches("^[a-z]{1}[A-Z]{1}.*")) {
            return getterMethodPrefix + fieldName;
        }
        return getterMethodPrefix + BaseUtility.capitalize(fieldName);
    }

    private String makeSetterMethodName(Field field) {
        String setterMethodPrefix = "set";
        String setterMethodName = this.isPrimitiveBooleanType(field) && field.getName().matches("^is[A-Z]{1}.*$") ? setterMethodPrefix + field.getName().substring(2) : (field.getName().matches("^[a-z]{1}[A-Z]{1}.*") ? setterMethodPrefix + field.getName() : setterMethodPrefix + BaseUtility.capitalize(field.getName()));
        return setterMethodName;
    }

    private String genGetColumnMethod(Field field) {
        Class<?> fieldType = this.isCollection(field.getType()) ? this.getGenericTypeClass(field) : field.getType();
        return this.genGetColumnMethod(fieldType);
    }

    private String genGetColumnMethod(Class<?> fieldType) {
        String typeName = fieldType.isPrimitive() ? BaseUtility.capitalize(fieldType.getName()) : fieldType.getSimpleName();
        String methodName = "get" + typeName;
        if ("getBoolean".equals(methodName)) {
            methodName = "getInt";
        } else if ("getChar".equals(methodName) || "getCharacter".equals(methodName)) {
            methodName = "getString";
        } else if ("getDate".equals(methodName)) {
            methodName = "getLong";
        } else if ("getInteger".equals(methodName)) {
            methodName = "getInt";
        } else if ("getbyte[]".equalsIgnoreCase(methodName)) {
            methodName = "getBlob";
        }
        return methodName;
    }

    private String[] getCustomizedColumns(String[] columns, List<Field> supportedGenericFields, List<AssociationsInfo> foreignKeyAssociations) {
        if (columns != null && columns.length > 0) {
            int i;
            boolean columnsContainsId = false;
            List<String> convertList = Arrays.asList(columns);
            ArrayList<String> columnList = new ArrayList<String>(convertList);
            ArrayList<String> supportedGenericFieldNames = new ArrayList<String>();
            ArrayList<Integer> columnToRemove = new ArrayList<Integer>();
            ArrayList<String> genericColumnsForQuery = new ArrayList<String>();
            ArrayList<Field> tempSupportedGenericFields = new ArrayList<Field>();
            for (Field supportedGenericField : supportedGenericFields) {
                supportedGenericFieldNames.add(supportedGenericField.getName());
            }
            for (i = 0; i < columnList.size(); ++i) {
                String columnName = (String)columnList.get(i);
                if (BaseUtility.containsIgnoreCases(supportedGenericFieldNames, columnName)) {
                    columnToRemove.add(i);
                    continue;
                }
                if (!this.isIdColumn(columnName)) continue;
                columnsContainsId = true;
                if (!"_id".equalsIgnoreCase(columnName)) continue;
                columnList.set(i, BaseUtility.changeCase("id"));
            }
            for (i = columnToRemove.size() - 1; i >= 0; --i) {
                int index = (Integer)columnToRemove.get(i);
                String genericColumn = (String)columnList.remove(index);
                genericColumnsForQuery.add(genericColumn);
            }
            for (Field supportedGenericField : supportedGenericFields) {
                String fieldName = supportedGenericField.getName();
                if (!BaseUtility.containsIgnoreCases(genericColumnsForQuery, fieldName)) continue;
                tempSupportedGenericFields.add(supportedGenericField);
            }
            supportedGenericFields.clear();
            supportedGenericFields.addAll(tempSupportedGenericFields);
            if (foreignKeyAssociations != null && foreignKeyAssociations.size() > 0) {
                for (int i2 = 0; i2 < foreignKeyAssociations.size(); ++i2) {
                    String associatedTable = DBUtility.getTableNameByClassName(foreignKeyAssociations.get(i2).getAssociatedClassName());
                    columnList.add(this.getForeignKeyColumnName(associatedTable));
                }
            }
            if (!columnsContainsId) {
                columnList.add(BaseUtility.changeCase("id"));
            }
            return columnList.toArray(new String[columnList.size()]);
        }
        return null;
    }

    private void analyzeAssociations(String className) {
        Collection<AssociationsInfo> associationInfos = this.getAssociationInfo(className);
        if (this.fkInCurrentModel == null) {
            this.fkInCurrentModel = new ArrayList<AssociationsInfo>();
        } else {
            this.fkInCurrentModel.clear();
        }
        if (this.fkInOtherModel == null) {
            this.fkInOtherModel = new ArrayList<AssociationsInfo>();
        } else {
            this.fkInOtherModel.clear();
        }
        for (AssociationsInfo associationInfo : associationInfos) {
            if (associationInfo.getAssociationType() == 2 || associationInfo.getAssociationType() == 1) {
                if (associationInfo.getClassHoldsForeignKey().equals(className)) {
                    this.fkInCurrentModel.add(associationInfo);
                    continue;
                }
                this.fkInOtherModel.add(associationInfo);
                continue;
            }
            if (associationInfo.getAssociationType() != 3) continue;
            this.fkInOtherModel.add(associationInfo);
        }
    }

    private void setAssociatedModel(DataSupport baseObj) {
        if (this.fkInOtherModel == null) {
            return;
        }
        for (AssociationsInfo info : this.fkInOtherModel) {
            Cursor cursor = null;
            String associatedClassName = info.getAssociatedClassName();
            boolean isM2M = info.getAssociationType() == 3;
            try {
                String associatedTableName;
                List<Field> supportedFields = this.getSupportedFields(associatedClassName);
                List<Field> supportedGenericFields = this.getSupportedGenericFields(associatedClassName);
                if (isM2M) {
                    String tableName = baseObj.getTableName();
                    associatedTableName = DBUtility.getTableNameByClassName(associatedClassName);
                    String intermediateTableName = DBUtility.getIntermediateTableName(tableName, associatedTableName);
                    StringBuilder sql = new StringBuilder();
                    sql.append("select * from ").append(associatedTableName).append(" a inner join ").append(intermediateTableName).append(" b on a.id = b.").append(associatedTableName + "_id").append(" where b.").append(tableName).append("_id = ?");
                    cursor = DataSupport.findBySQL(BaseUtility.changeCase(sql.toString()), String.valueOf(baseObj.getBaseObjId()));
                } else {
                    String foreignKeyColumn = this.getForeignKeyColumnName(DBUtility.getTableNameByClassName(info.getSelfClassName()));
                    associatedTableName = DBUtility.getTableNameByClassName(associatedClassName);
                    cursor = this.mDatabase.query(BaseUtility.changeCase(associatedTableName), null, foreignKeyColumn + "=?", new String[]{String.valueOf(baseObj.getBaseObjId())}, null, null, null, null);
                }
                if (cursor == null || !cursor.moveToFirst()) continue;
                SparseArray queryInfoCacheSparseArray = new SparseArray();
                HashMap<Field, GenericModel> genericModelMap = new HashMap<Field, GenericModel>();
                do {
                    DataSupport modelInstance = (DataSupport)this.createInstanceFromClass(Class.forName(associatedClassName));
                    this.giveBaseObjIdValue(modelInstance, cursor.getLong(cursor.getColumnIndexOrThrow("id")));
                    this.setValueToModel(modelInstance, supportedFields, null, cursor, (SparseArray<QueryInfoCache>)queryInfoCacheSparseArray);
                    this.setGenericValueToModel(modelInstance, supportedGenericFields, genericModelMap);
                    if (info.getAssociationType() == 2 || isM2M) {
                        Field field = info.getAssociateOtherModelFromSelf();
                        AbstractCollection collection = (ArrayList<DataSupport>)this.getFieldValue(baseObj, field);
                        if (collection == null) {
                            collection = this.isList(field.getType()) ? new ArrayList<DataSupport>() : new HashSet();
                            DynamicExecutor.setField(baseObj, field.getName(), collection, baseObj.getClass());
                        }
                        collection.add(modelInstance);
                        continue;
                    }
                    if (info.getAssociationType() != 1) continue;
                    this.setFieldValue(baseObj, info.getAssociateOtherModelFromSelf(), modelInstance);
                } while (cursor.moveToNext());
                queryInfoCacheSparseArray.clear();
                genericModelMap.clear();
            }
            catch (Exception e) {
                throw new DataSupportException(e.getMessage(), e);
            }
            finally {
                if (cursor == null) continue;
                cursor.close();
            }
        }
    }

    private void setToModelByReflection(Object modelInstance, Field field, int columnIndex, String getMethodName, Cursor cursor) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> cursorClass = cursor.getClass();
        Method method = cursorClass.getMethod(getMethodName, Integer.TYPE);
        Object value = method.invoke((Object)cursor, columnIndex);
        if (field.getType() == Boolean.TYPE || field.getType() == Boolean.class) {
            if ("0".equals(String.valueOf(value))) {
                value = false;
            } else if ("1".equals(String.valueOf(value))) {
                value = true;
            }
        } else if (field.getType() == Character.TYPE || field.getType() == Character.class) {
            value = Character.valueOf(((String)value).charAt(0));
        } else if (field.getType() == Date.class) {
            long date = (Long)value;
            value = date <= 0L ? null : new Date(date);
        }
        if (this.isCollection(field.getType())) {
            Encrypt annotation;
            AbstractCollection collection = (ArrayList<Object>)DynamicExecutor.getField(modelInstance, field.getName(), modelInstance.getClass());
            if (collection == null) {
                collection = this.isList(field.getType()) ? new ArrayList<Object>() : new HashSet();
                DynamicExecutor.setField(modelInstance, field.getName(), collection, modelInstance.getClass());
            }
            if ((annotation = field.getAnnotation(Encrypt.class)) != null && "java.lang.String".equals(this.getGenericTypeName(field))) {
                value = this.decryptValue(annotation.algorithm(), value);
            }
            collection.add(value);
        } else {
            Encrypt annotation = field.getAnnotation(Encrypt.class);
            if (annotation != null && "java.lang.String".equals(field.getType().getName())) {
                value = this.decryptValue(annotation.algorithm(), value);
            }
            DynamicExecutor.setField(modelInstance, field.getName(), value, modelInstance.getClass());
        }
    }

    protected Object decryptValue(String algorithm, Object fieldValue) {
        if (algorithm != null && fieldValue != null && "AES".equalsIgnoreCase(algorithm)) {
            fieldValue = CipherUtil.aesDecrypt((String)fieldValue);
        }
        return fieldValue;
    }

    class QueryInfoCache {
        String getMethodName;
        Field field;

        QueryInfoCache() {
        }
    }
}

