/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.litepal.crud;

import com.komect.network.litepal.crud.DataHandler;
import com.komect.network.litepal.crud.DataSupport;
import com.komect.network.litepal.crud.model.AssociationsInfo;
import com.komect.network.litepal.exceptions.DataSupportException;
import com.komect.network.litepal.util.DBUtility;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

abstract class AssociationsAnalyzer
extends DataHandler {
    AssociationsAnalyzer() {
    }

    protected Collection<DataSupport> getReverseAssociatedModels(DataSupport associatedModel, AssociationsInfo associationInfo) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return (Collection)this.getFieldValue(associatedModel, associationInfo.getAssociateSelfFromOtherModel());
    }

    protected void setReverseAssociatedModels(DataSupport associatedModel, AssociationsInfo associationInfo, Collection<DataSupport> associatedModelCollection) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        this.setFieldValue(associatedModel, associationInfo.getAssociateSelfFromOtherModel(), associatedModelCollection);
    }

    protected Collection<DataSupport> checkAssociatedModelCollection(Collection<DataSupport> associatedModelCollection, Field associatedField) {
        AbstractCollection collection = null;
        if (this.isList(associatedField.getType())) {
            collection = new ArrayList<DataSupport>();
        } else if (this.isSet(associatedField.getType())) {
            collection = new HashSet();
        } else {
            throw new DataSupportException("The field to declare many2one or many2many associations should be List or Set.");
        }
        if (associatedModelCollection != null) {
            collection.addAll(associatedModelCollection);
        }
        return collection;
    }

    protected void buildBidirectionalAssociations(DataSupport baseObj, DataSupport associatedModel, AssociationsInfo associationInfo) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        this.setFieldValue(associatedModel, associationInfo.getAssociateSelfFromOtherModel(), baseObj);
    }

    protected void dealsAssociationsOnTheSideWithoutFK(DataSupport baseObj, DataSupport associatedModel) {
        if (associatedModel != null) {
            if (associatedModel.isSaved()) {
                baseObj.addAssociatedModelWithFK(associatedModel.getTableName(), associatedModel.getBaseObjId());
            } else if (baseObj.isSaved()) {
                associatedModel.addAssociatedModelWithoutFK(baseObj.getTableName(), baseObj.getBaseObjId());
            }
        }
    }

    protected void mightClearFKValue(DataSupport baseObj, AssociationsInfo associationInfo) {
        baseObj.addFKNameToClearSelf(this.getForeignKeyName(associationInfo));
    }

    private String getForeignKeyName(AssociationsInfo associationInfo) {
        return this.getForeignKeyColumnName(DBUtility.getTableNameByClassName(associationInfo.getAssociatedClassName()));
    }
}

