/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.litepal;

import com.komect.network.litepal.parser.LitePalConfig;
import com.komect.network.litepal.parser.LitePalParser;
import java.util.ArrayList;
import java.util.List;

public class LitePalDB {
    private int version;
    private String dbName;
    private String storage;
    private boolean isExternalStorage = false;
    private List<String> classNames;

    public static LitePalDB fromDefault(String dbName) {
        LitePalConfig config = LitePalParser.parseLitePalConfiguration();
        LitePalDB litePalDB = new LitePalDB(dbName, config.getVersion());
        litePalDB.setStorage(config.getStorage());
        litePalDB.setClassNames(config.getClassNames());
        return litePalDB;
    }

    public LitePalDB(String dbName, int version) {
        this.dbName = dbName;
        this.version = version;
    }

    public int getVersion() {
        return this.version;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getStorage() {
        return this.storage;
    }

    public void setStorage(String storage) {
        this.storage = storage;
    }

    public boolean isExternalStorage() {
        return this.isExternalStorage;
    }

    public void setExternalStorage(boolean isExternalStorage) {
        this.isExternalStorage = isExternalStorage;
    }

    public List<String> getClassNames() {
        if (this.classNames == null) {
            this.classNames = new ArrayList<String>();
            this.classNames.add("com.komect.network.litepal.model.Table_Schema");
        } else if (this.classNames.isEmpty()) {
            this.classNames.add("com.komect.network.litepal.model.Table_Schema");
        }
        return this.classNames;
    }

    public void addClassName(String className) {
        this.getClassNames().add(className);
    }

    void setClassNames(List<String> className) {
        this.classNames = className;
    }
}

