/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.litepal;

import com.komect.network.litepal.annotation.Column;
import com.komect.network.litepal.crud.DataSupport;
import com.komect.network.litepal.crud.model.AssociationsInfo;
import com.komect.network.litepal.exceptions.DatabaseGenerateException;
import com.komect.network.litepal.parser.LitePalAttr;
import com.komect.network.litepal.tablemanager.model.AssociationsModel;
import com.komect.network.litepal.tablemanager.model.ColumnModel;
import com.komect.network.litepal.tablemanager.model.GenericModel;
import com.komect.network.litepal.tablemanager.model.TableModel;
import com.komect.network.litepal.tablemanager.typechange.BlobOrm;
import com.komect.network.litepal.tablemanager.typechange.BooleanOrm;
import com.komect.network.litepal.tablemanager.typechange.DateOrm;
import com.komect.network.litepal.tablemanager.typechange.DecimalOrm;
import com.komect.network.litepal.tablemanager.typechange.NumericOrm;
import com.komect.network.litepal.tablemanager.typechange.OrmChange;
import com.komect.network.litepal.tablemanager.typechange.TextOrm;
import com.komect.network.litepal.util.BaseUtility;
import com.komect.network.litepal.util.DBUtility;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class LitePalBase {
    public static final String TAG = "LitePalBase";
    private static final int GET_ASSOCIATIONS_ACTION = 1;
    private static final int GET_ASSOCIATION_INFO_ACTION = 2;
    private OrmChange[] typeChangeRules = new OrmChange[]{new NumericOrm(), new TextOrm(), new BooleanOrm(), new DecimalOrm(), new DateOrm(), new BlobOrm()};
    private Map<String, List<Field>> classFieldsMap = new HashMap<String, List<Field>>();
    private Map<String, List<Field>> classGenericFieldsMap = new HashMap<String, List<Field>>();
    private Collection<AssociationsModel> mAssociationModels;
    private Collection<AssociationsInfo> mAssociationInfos;
    private Collection<GenericModel> mGenericModels;

    protected TableModel getTableModel(String className) {
        String tableName = DBUtility.getTableNameByClassName(className);
        TableModel tableModel = new TableModel();
        tableModel.setTableName(tableName);
        tableModel.setClassName(className);
        List<Field> supportedFields = this.getSupportedFields(className);
        for (Field field : supportedFields) {
            ColumnModel columnModel = this.convertFieldToColumnModel(field);
            tableModel.addColumnModel(columnModel);
        }
        return tableModel;
    }

    protected Collection<AssociationsModel> getAssociations(List<String> classNames) {
        if (this.mAssociationModels == null) {
            this.mAssociationModels = new HashSet<AssociationsModel>();
        }
        if (this.mGenericModels == null) {
            this.mGenericModels = new HashSet<GenericModel>();
        }
        this.mAssociationModels.clear();
        this.mGenericModels.clear();
        for (String className : classNames) {
            this.analyzeClassFields(className, 1);
        }
        return this.mAssociationModels;
    }

    protected Collection<GenericModel> getGenericModels() {
        return this.mGenericModels;
    }

    protected Collection<AssociationsInfo> getAssociationInfo(String className) {
        if (this.mAssociationInfos == null) {
            this.mAssociationInfos = new HashSet<AssociationsInfo>();
        }
        this.mAssociationInfos.clear();
        this.analyzeClassFields(className, 2);
        return this.mAssociationInfos;
    }

    protected List<Field> getSupportedFields(String className) {
        List<Field> fieldList = this.classFieldsMap.get(className);
        if (fieldList == null) {
            Class<?> clazz;
            ArrayList<Field> supportedFields = new ArrayList<Field>();
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new DatabaseGenerateException("can not find a class named " + className);
            }
            this.recursiveSupportedFields(clazz, supportedFields);
            this.classFieldsMap.put(className, supportedFields);
            return supportedFields;
        }
        return fieldList;
    }

    protected List<Field> getSupportedGenericFields(String className) {
        List<Field> genericFieldList = this.classGenericFieldsMap.get(className);
        if (genericFieldList == null) {
            Class<?> clazz;
            ArrayList<Field> supportedGenericFields = new ArrayList<Field>();
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new DatabaseGenerateException("can not find a class named " + className);
            }
            this.recursiveSupportedGenericFields(clazz, supportedGenericFields);
            this.classGenericFieldsMap.put(className, supportedGenericFields);
            return supportedGenericFields;
        }
        return genericFieldList;
    }

    protected boolean isCollection(Class<?> fieldType) {
        return this.isList(fieldType) || this.isSet(fieldType);
    }

    protected boolean isList(Class<?> fieldType) {
        return List.class.isAssignableFrom(fieldType);
    }

    protected boolean isSet(Class<?> fieldType) {
        return Set.class.isAssignableFrom(fieldType);
    }

    protected boolean isIdColumn(String columnName) {
        return "_id".equalsIgnoreCase(columnName) || "id".equalsIgnoreCase(columnName);
    }

    protected String getForeignKeyColumnName(String associatedTableName) {
        return BaseUtility.changeCase(associatedTableName + "_id");
    }

    protected String getColumnType(String fieldType) {
        for (OrmChange ormChange : this.typeChangeRules) {
            String columnType = ormChange.object2Relation(fieldType);
            if (columnType == null) continue;
            return columnType;
        }
        return null;
    }

    protected Class<?> getGenericTypeClass(Field field) {
        Type genericType = field.getGenericType();
        if (genericType != null && genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            return (Class)parameterizedType.getActualTypeArguments()[0];
        }
        return null;
    }

    private void recursiveSupportedFields(Class<?> clazz, List<Field> supportedFields) {
        if (clazz == DataSupport.class || clazz == Object.class) {
            return;
        }
        Field[] fields = clazz.getDeclaredFields();
        if (fields != null && fields.length > 0) {
            for (Field field : fields) {
                Class<?> fieldTypeClass;
                String fieldType;
                int modifiers;
                Column annotation = field.getAnnotation(Column.class);
                if (annotation != null && annotation.ignore() || Modifier.isStatic(modifiers = field.getModifiers()) || !BaseUtility.isFieldTypeSupported(fieldType = (fieldTypeClass = field.getType()).getName())) continue;
                supportedFields.add(field);
            }
        }
        this.recursiveSupportedFields(clazz.getSuperclass(), supportedFields);
    }

    private void recursiveSupportedGenericFields(Class<?> clazz, List<Field> supportedGenericFields) {
        if (clazz == DataSupport.class || clazz == Object.class) {
            return;
        }
        Field[] fields = clazz.getDeclaredFields();
        if (fields != null && fields.length > 0) {
            for (Field field : fields) {
                String genericTypeName;
                int modifiers;
                Column annotation = field.getAnnotation(Column.class);
                if (annotation != null && annotation.ignore() || Modifier.isStatic(modifiers = field.getModifiers()) || !this.isCollection(field.getType()) || !BaseUtility.isGenericTypeSupported(genericTypeName = this.getGenericTypeName(field))) continue;
                supportedGenericFields.add(field);
            }
        }
        this.recursiveSupportedGenericFields(clazz.getSuperclass(), supportedGenericFields);
    }

    private void analyzeClassFields(String className, int action) {
        try {
            Field[] fields;
            Class<?> dynamicClass = Class.forName(className);
            for (Field field : fields = dynamicClass.getDeclaredFields()) {
                Column annotation;
                if (!this.isNonPrimitive(field) || (annotation = field.getAnnotation(Column.class)) != null && annotation.ignore()) continue;
                this.oneToAnyConditions(className, field, action);
                this.manyToAnyConditions(className, field, action);
            }
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
            throw new DatabaseGenerateException("can not find a class named " + className);
        }
    }

    private boolean isNonPrimitive(Field field) {
        return !field.getType().isPrimitive();
    }

    private boolean isPrivate(Field field) {
        return Modifier.isPrivate(field.getModifiers());
    }

    private void oneToAnyConditions(String className, Field field, int action) throws ClassNotFoundException {
        Class<?> fieldTypeClass = field.getType();
        if (LitePalAttr.getInstance().getClassNames().contains(fieldTypeClass.getName())) {
            Class<?> reverseDynamicClass = Class.forName(fieldTypeClass.getName());
            Field[] reverseFields = reverseDynamicClass.getDeclaredFields();
            boolean reverseAssociations = false;
            for (int i = 0; i < reverseFields.length; ++i) {
                String genericTypeName;
                Field reverseField = reverseFields[i];
                if (Modifier.isStatic(reverseField.getModifiers())) continue;
                Class<?> reverseFieldTypeClass = reverseField.getType();
                if (className.equals(reverseFieldTypeClass.getName())) {
                    if (action == 1) {
                        this.addIntoAssociationModelCollection(className, fieldTypeClass.getName(), fieldTypeClass.getName(), 1);
                    } else if (action == 2) {
                        this.addIntoAssociationInfoCollection(className, fieldTypeClass.getName(), fieldTypeClass.getName(), field, reverseField, 1);
                    }
                    reverseAssociations = true;
                    continue;
                }
                if (!this.isCollection(reverseFieldTypeClass) || !className.equals(genericTypeName = this.getGenericTypeName(reverseField))) continue;
                if (action == 1) {
                    this.addIntoAssociationModelCollection(className, fieldTypeClass.getName(), className, 2);
                } else if (action == 2) {
                    this.addIntoAssociationInfoCollection(className, fieldTypeClass.getName(), className, field, reverseField, 2);
                }
                reverseAssociations = true;
            }
            if (!reverseAssociations) {
                if (action == 1) {
                    this.addIntoAssociationModelCollection(className, fieldTypeClass.getName(), fieldTypeClass.getName(), 1);
                } else if (action == 2) {
                    this.addIntoAssociationInfoCollection(className, fieldTypeClass.getName(), fieldTypeClass.getName(), field, null, 1);
                }
            }
        }
    }

    private void manyToAnyConditions(String className, Field field, int action) throws ClassNotFoundException {
        if (this.isCollection(field.getType())) {
            String genericTypeName = this.getGenericTypeName(field);
            if (LitePalAttr.getInstance().getClassNames().contains(genericTypeName)) {
                Class<?> reverseDynamicClass = Class.forName(genericTypeName);
                Field[] reverseFields = reverseDynamicClass.getDeclaredFields();
                boolean reverseAssociations = false;
                for (int i = 0; i < reverseFields.length; ++i) {
                    String reverseGenericTypeName;
                    Field reverseField = reverseFields[i];
                    if (Modifier.isStatic(reverseField.getModifiers())) continue;
                    Class<?> reverseFieldTypeClass = reverseField.getType();
                    if (className.equals(reverseFieldTypeClass.getName())) {
                        if (action == 1) {
                            this.addIntoAssociationModelCollection(className, genericTypeName, genericTypeName, 2);
                        } else if (action == 2) {
                            this.addIntoAssociationInfoCollection(className, genericTypeName, genericTypeName, field, reverseField, 2);
                        }
                        reverseAssociations = true;
                        continue;
                    }
                    if (!this.isCollection(reverseFieldTypeClass) || !className.equals(reverseGenericTypeName = this.getGenericTypeName(reverseField))) continue;
                    if (action == 1) {
                        this.addIntoAssociationModelCollection(className, genericTypeName, null, 3);
                    } else if (action == 2) {
                        this.addIntoAssociationInfoCollection(className, genericTypeName, null, field, reverseField, 3);
                    }
                    reverseAssociations = true;
                }
                if (!reverseAssociations) {
                    if (action == 1) {
                        this.addIntoAssociationModelCollection(className, genericTypeName, genericTypeName, 2);
                    } else if (action == 2) {
                        this.addIntoAssociationInfoCollection(className, genericTypeName, genericTypeName, field, null, 2);
                    }
                }
            } else if (BaseUtility.isGenericTypeSupported(genericTypeName) && action == 1) {
                Column annotation = field.getAnnotation(Column.class);
                if (annotation != null && annotation.ignore()) {
                    return;
                }
                GenericModel genericModel = new GenericModel();
                genericModel.setTableName(DBUtility.getGenericTableName(className, field.getName()));
                genericModel.setValueColumnName(DBUtility.convertToValidColumnName(field.getName()));
                genericModel.setValueColumnType(this.getColumnType(genericTypeName));
                genericModel.setValueIdColumnName(DBUtility.getGenericValueIdColumnName(className));
                this.mGenericModels.add(genericModel);
            }
        }
    }

    private void addIntoAssociationModelCollection(String className, String associatedClassName, String classHoldsForeignKey, int associationType) {
        AssociationsModel associationModel = new AssociationsModel();
        associationModel.setTableName(DBUtility.getTableNameByClassName(className));
        associationModel.setAssociatedTableName(DBUtility.getTableNameByClassName(associatedClassName));
        associationModel.setTableHoldsForeignKey(DBUtility.getTableNameByClassName(classHoldsForeignKey));
        associationModel.setAssociationType(associationType);
        this.mAssociationModels.add(associationModel);
    }

    private void addIntoAssociationInfoCollection(String selfClassName, String associatedClassName, String classHoldsForeignKey, Field associateOtherModelFromSelf, Field associateSelfFromOtherModel, int associationType) {
        AssociationsInfo associationInfo = new AssociationsInfo();
        associationInfo.setSelfClassName(selfClassName);
        associationInfo.setAssociatedClassName(associatedClassName);
        associationInfo.setClassHoldsForeignKey(classHoldsForeignKey);
        associationInfo.setAssociateOtherModelFromSelf(associateOtherModelFromSelf);
        associationInfo.setAssociateSelfFromOtherModel(associateSelfFromOtherModel);
        associationInfo.setAssociationType(associationType);
        this.mAssociationInfos.add(associationInfo);
    }

    protected String getGenericTypeName(Field field) {
        Class<?> genericTypeClass = this.getGenericTypeClass(field);
        if (genericTypeClass != null) {
            return genericTypeClass.getName();
        }
        return null;
    }

    private ColumnModel convertFieldToColumnModel(Field field) {
        String fieldType = field.getType().getName();
        String columnType = this.getColumnType(fieldType);
        boolean nullable = true;
        boolean unique = false;
        String defaultValue = "";
        Column annotation = field.getAnnotation(Column.class);
        if (annotation != null) {
            nullable = annotation.nullable();
            unique = annotation.unique();
            defaultValue = annotation.defaultValue();
        }
        ColumnModel columnModel = new ColumnModel();
        columnModel.setColumnName(DBUtility.convertToValidColumnName(field.getName()));
        columnModel.setColumnType(columnType);
        columnModel.setNullable(nullable);
        columnModel.setUnique(unique);
        columnModel.setDefaultValue(defaultValue);
        return columnModel;
    }
}

