/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.litepal;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.komect.network.litepal.LitePalApplication;
import com.komect.network.litepal.LitePalDB;
import com.komect.network.litepal.parser.LitePalAttr;
import com.komect.network.litepal.parser.LitePalConfig;
import com.komect.network.litepal.parser.LitePalParser;
import com.komect.network.litepal.tablemanager.Connector;
import com.komect.network.litepal.util.BaseUtility;
import com.komect.network.litepal.util.SharedUtil;
import com.komect.network.litepal.util.cipher.CipherUtil;
import java.io.File;

public class LitePal {
    private static Handler handler = new Handler(Looper.getMainLooper());

    public static void initialize(Context context) {
        LitePalApplication.sContext = context;
    }

    public static SQLiteDatabase getDatabase() {
        return Connector.getDatabase();
    }

    public static Handler getHandler() {
        return handler;
    }

    public static void use(LitePalDB litePalDB) {
        LitePalAttr litePalAttr = LitePalAttr.getInstance();
        litePalAttr.setDbName(litePalDB.getDbName());
        litePalAttr.setVersion(litePalDB.getVersion());
        litePalAttr.setStorage(litePalDB.getStorage());
        litePalAttr.setClassNames(litePalDB.getClassNames());
        if (!LitePal.isDefaultDatabase(litePalDB.getDbName())) {
            litePalAttr.setExtraKeyName(litePalDB.getDbName());
            litePalAttr.setCases("lower");
        }
        Connector.clearLitePalOpenHelperInstance();
    }

    public static void useDefault() {
        LitePalAttr.clearInstance();
        Connector.clearLitePalOpenHelperInstance();
    }

    public static boolean deleteDatabase(String dbName) {
        if (!TextUtils.isEmpty((CharSequence)dbName)) {
            File dbFile;
            if (!dbName.endsWith(".db")) {
                dbName = dbName + ".db";
            }
            if ((dbFile = LitePalApplication.getContext().getDatabasePath(dbName)).exists()) {
                boolean result = dbFile.delete();
                if (result) {
                    LitePal.removeVersionInSharedPreferences(dbName);
                    Connector.clearLitePalOpenHelperInstance();
                }
                return result;
            }
            String path = LitePalApplication.getContext().getExternalFilesDir("") + "/databases/";
            dbFile = new File(path + dbName);
            boolean result = dbFile.delete();
            if (result) {
                LitePal.removeVersionInSharedPreferences(dbName);
                Connector.clearLitePalOpenHelperInstance();
            }
            return result;
        }
        return false;
    }

    public static void aesKey(String key) {
        CipherUtil.aesKey = key;
    }

    private static void removeVersionInSharedPreferences(String dbName) {
        if (LitePal.isDefaultDatabase(dbName)) {
            SharedUtil.removeVersion(null);
        } else {
            SharedUtil.removeVersion(dbName);
        }
    }

    private static boolean isDefaultDatabase(String dbName) {
        if (BaseUtility.isLitePalXMLExists()) {
            LitePalConfig config;
            String defaultDbName;
            if (!dbName.endsWith(".db")) {
                dbName = dbName + ".db";
            }
            if (!(defaultDbName = (config = LitePalParser.parseLitePalConfiguration()).getDbName()).endsWith(".db")) {
                defaultDbName = defaultDbName + ".db";
            }
            return dbName.equalsIgnoreCase(defaultDbName);
        }
        return false;
    }
}

