/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.komectinnet.utils;

import android.text.TextUtils;
import com.komect.network.komectinnet.utils.EmptyUtils;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    private static final String IDCARD = "((11|12|13|14|15|21|22|23|31|32|33|34|35|36|37|41|42|43|44|45|46|50|51|52|53|54|61|62|63|64|65)[0-9]{4})(([1|2][0-9]{3}[0|1][0-9][0-3][0-9][0-9]{3}[Xx0-9])|([0-9]{2}[0|1][0-9][0-3][0-9][0-9]{3}))";

    public static boolean equals(CharSequence a, CharSequence b) {
        int length;
        if (a == b) {
            return true;
        }
        if (a != null && b != null && (length = a.length()) == b.length()) {
            if (a instanceof String && b instanceof String) {
                return a.equals(b);
            }
            for (int i = 0; i < length; ++i) {
                if (a.charAt(i) == b.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean inGroup(CharSequence a, String ... group) {
        if (!TextUtils.isEmpty((CharSequence)a) && !EmptyUtils.isEmpty(group)) {
            for (String string2 : group) {
                if (!TextUtils.equals((CharSequence)a, (CharSequence)string2)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isMobile(String phone) {
        if (EmptyUtils.isEmpty(phone)) {
            return false;
        }
        boolean result = phone.matches("^(13[0-9]|14[5|7]|15[0|1|2|3|5|6|7|8|9]|18[0|1|2|3|5|6|7|8|9])\\d{8}$");
        boolean lengthMatch = phone.length() >= 7 && phone.length() <= 11;
        return lengthMatch && result;
    }

    public static boolean checkPwdSecurity(String pwd) {
        if (EmptyUtils.isEmpty(pwd)) {
            return false;
        }
        return pwd.matches("^(?![A-Z]+$)(?![a-z]+$)(?!\\d+$)(?![\\W_]+$)\\S{6,16}$");
    }

    public static boolean isRightPhone(String phoneNum) {
        if (EmptyUtils.isEmpty(phoneNum)) {
            return false;
        }
        String phoneReg = "1\\d{10}";
        return phoneNum.matches(phoneReg);
    }

    public static String toURLEncoded(String paramString) {
        if (paramString == null || "".equals(paramString)) {
            return "";
        }
        try {
            String str = new String(paramString.getBytes(), "UTF-8");
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static boolean pswStringNum(String psw) {
        boolean flag = false;
        try {
            String reg = "^[^\\s]{6,18}$";
            Pattern p = Pattern.compile(reg);
            Matcher m = p.matcher(psw);
            flag = m.matches();
        }
        catch (Exception e) {
            flag = false;
        }
        return flag;
    }

    public static boolean isRightEmail(String email) {
        if (EmptyUtils.isEmpty(email)) {
            return false;
        }
        String emailFilter = "^[a-zA-Z0-9_-]+@[a-zA-Z0-9_-]+(\\.[a-zA-Z0-9_-]+)+$";
        return email.matches(emailFilter);
    }

    public static boolean isRightPwd(String pwd) {
        if (EmptyUtils.isEmpty(pwd)) {
            return false;
        }
        int len = pwd.length();
        return len >= 6 && len <= 16;
    }

    public static boolean isRightTempSmsPwd(String smsPwd) {
        if (EmptyUtils.isEmpty(smsPwd)) {
            return false;
        }
        String lengthReg = "\\d{6}";
        return smsPwd.matches(lengthReg);
    }

    public static boolean isIdCard(String string2) {
        if (EmptyUtils.isEmpty(string2)) {
            return false;
        }
        return string2.trim().length() == 15 || string2.trim().length() == 18;
    }
}

