/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.komectinnet.utils;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Point;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class AppUtil {
    private static String sApkChannel = null;

    public static String getCurrentVersionName(Context context) {
        String curVersionName = "?.?.?";
        try {
            PackageInfo info = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            curVersionName = info.versionName;
            curVersionName = curVersionName.substring(0, curVersionName.lastIndexOf("."));
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace(System.err);
        }
        return curVersionName;
    }

    public static String getPackageName(Context context) {
        String pkgName = "";
        ApplicationInfo appInfo = context.getApplicationInfo();
        if (appInfo != null) {
            pkgName = appInfo.packageName;
        }
        return pkgName;
    }

    public static String getPhoneIp() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> enumIPAddre = intf.getInetAddresses();
                while (enumIPAddre.hasMoreElements()) {
                    InetAddress inetAddress = enumIPAddre.nextElement();
                    if (inetAddress.isLoopbackAddress()) continue;
                    return inetAddress.getHostAddress().toLowerCase();
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return "127.0.0.1";
    }

    public static String getSubNetWorkType(Context context) {
        ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
        manager.getActiveNetworkInfo();
        NetworkInfo info = manager.getNetworkInfo(1);
        NetworkInfo.State wifiState = null;
        NetworkInfo.State mobileState = null;
        if (info != null) {
            wifiState = info.getState();
        }
        if ((info = manager.getNetworkInfo(0)) != null) {
            Log.d((String)"network ", (String)(" info.getSubtype()  " + info.getSubtype() + " info.getSubtypeName" + "() =  " + info.getSubtypeName()));
            mobileState = info.getState();
        }
        if (wifiState != null && mobileState != null && NetworkInfo.State.CONNECTED != wifiState && NetworkInfo.State.CONNECTED == mobileState) {
            TelephonyManager teleMan = (TelephonyManager)context.getSystemService("phone");
            int networkType = teleMan.getNetworkType();
            switch (networkType) {
                case 7: {
                    return "1xRTT";
                }
                case 4: {
                    return "CDMA";
                }
                case 2: {
                    return "EDGE";
                }
                case 14: {
                    return "eHRPD";
                }
                case 5: {
                    return "EVDO rev. 0";
                }
                case 6: {
                    return "EVDO rev. A";
                }
                case 12: {
                    return "EVDO rev. B";
                }
                case 1: {
                    return "GPRS";
                }
                case 8: {
                    return "HSDPA";
                }
                case 10: {
                    return "HSPA";
                }
                case 15: {
                    return "HSPA+";
                }
                case 9: {
                    return "HSUPA";
                }
                case 11: {
                    return "iDen";
                }
                case 13: {
                    return "LTE";
                }
                case 3: {
                    return "UMTS";
                }
            }
            return "Unknown";
        }
        if (wifiState != null && mobileState != null && NetworkInfo.State.CONNECTED != wifiState && NetworkInfo.State.CONNECTED != mobileState) {
            return "offline";
        }
        if (wifiState != null && NetworkInfo.State.CONNECTED == wifiState) {
            return "wifi";
        }
        return "offline";
    }

    public static Point getScreenSize(Context context) {
        Point p = new Point();
        DisplayMetrics dm = context.getResources().getDisplayMetrics();
        int width = dm.widthPixels;
        int height = dm.heightPixels;
        p.set(width, height);
        return p;
    }

    public static double getScreenInches(Context context) {
        DisplayMetrics dm = context.getResources().getDisplayMetrics();
        int width = dm.widthPixels;
        int height = dm.heightPixels;
        double x = Math.pow(width, 2.0);
        double y = Math.pow(height, 2.0);
        double diagonal = Math.sqrt(x + y);
        int dens = dm.densityDpi;
        double screenInches = diagonal / (double)dens;
        Log.d((String)"context", (String)("The screenInches " + screenInches));
        return screenInches;
    }

    public static String getAppName(Context context) {
        String appName = "";
        PackageManager pm = context.getPackageManager();
        try {
            appName = pm.getApplicationInfo(context.getPackageName(), 0).loadLabel(pm).toString();
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            appName = context.getPackageName();
        }
        return appName;
    }

    public static String getChannelFromApk(Context context) {
        return AppUtil.getChannelFromApk(context, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getChannelFromApk(Context context, String keyStr, String splitStr, String defaultMetaDataKeyString) {
        long sT = System.nanoTime();
        if (TextUtils.isEmpty((CharSequence)sApkChannel)) {
            String[] split;
            if (TextUtils.isEmpty((CharSequence)keyStr)) {
                keyStr = "dtchannels";
            }
            ApplicationInfo appinfo = context.getApplicationInfo();
            String sourceDir = appinfo.sourceDir;
            String key = "META-INF/" + keyStr;
            String ret = "";
            ZipFile zipfile = null;
            try {
                zipfile = new ZipFile(sourceDir);
                Enumeration<? extends ZipEntry> entries = zipfile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    String entryName = entry.getName();
                    if (!entryName.startsWith(key)) continue;
                    ret = entryName;
                    break;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (zipfile != null) {
                    try {
                        zipfile.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (TextUtils.isEmpty((CharSequence)splitStr)) {
                splitStr = "_";
            }
            if ((split = ret.split(splitStr)) != null && split.length >= 2) {
                sApkChannel = ret.substring(split[0].length() + 1);
            }
            if (TextUtils.isEmpty((CharSequence)defaultMetaDataKeyString)) {
                defaultMetaDataKeyString = "DUOTIN_CHANNEL";
            }
            if (TextUtils.isEmpty((CharSequence)sApkChannel)) {
                sApkChannel = AppUtil.getAppMetaData(context, defaultMetaDataKeyString);
            }
            if (TextUtils.isEmpty((CharSequence)sApkChannel)) {
                sApkChannel = AppUtil.getAppMetaData(context, "UMENG_CHANNEL");
            }
        }
        return sApkChannel;
    }

    public static String getAppMetaData(Context context, String metaTagStr) {
        ApplicationInfo appInfo = null;
        try {
            appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        String value = "";
        if (appInfo != null) {
            value = appInfo.metaData.getString(metaTagStr);
        }
        return value;
    }

    public static int getCurrentVersionCode(Context context) {
        int versionCode = 0;
        try {
            PackageInfo info = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            versionCode = info.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace(System.err);
        }
        return versionCode;
    }

    public static String getWifiMac(Context context) {
        String wifiMac = "";
        try {
            WifiManager wifi = (WifiManager)context.getSystemService("wifi");
            WifiInfo info = wifi.getConnectionInfo();
            wifiMac = info.getMacAddress();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return wifiMac;
    }

    public static String getDeviceId(Context context) {
        String imei = "";
        try {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            imei = telephonyManager.getDeviceId();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return imei;
    }

    public static String getDeviceKey(Context context) {
        String key = "";
        if (!AppUtil.checkDeviceKey(key)) {
            key = AppUtil.getDeviceId(context);
            if (!AppUtil.checkDeviceKey(key)) {
                key = AppUtil.getWifiMac(context);
            }
            if (!AppUtil.checkDeviceKey(key)) {
                key = UUID.randomUUID().toString();
            }
        }
        return key;
    }

    private static boolean checkDeviceKey(String key) {
        if ("00:00:00:00:00:00".equals(key)) {
            return false;
        }
        return !TextUtils.isEmpty((CharSequence)key) && key.length() >= 6;
    }

    public static boolean isApkDebugable(Context context, String packageName) {
        try {
            PackageInfo pkginfo = context.getPackageManager().getPackageInfo(packageName, 1);
            if (pkginfo != null) {
                ApplicationInfo info = pkginfo.applicationInfo;
                return (info.flags & 2) != 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }
}

