/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.komectinnet.sdk;

import android.content.Context;
import android.support.annotation.NonNull;
import com.komect.network.komectinnet.event.GlobalMsgEvent;
import com.komect.network.komectinnet.sdk.HTTPSTrustManager;
import com.komect.network.komectinnet.sdk.UserService;
import com.komect.network.komectinnet.utils.AppUtil;
import com.komect.network.komectinnet.utils.EmptyUtils;
import com.komect.network.komectinnet.utils.NetworkUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class UserManager {
    private final Context mContext;
    private final UserService mUserService;
    private String token;
    private static UserManager instance;

    public static Builder builder() {
        return new Builder();
    }

    public static synchronized UserManager getInstance() {
        return instance;
    }

    private UserManager(Context context, UserService userService) {
        this.mContext = context;
        this.mUserService = userService;
    }

    public synchronized void setToken(String token) {
        this.token = token;
    }

    public synchronized String getToken() {
        return this.token;
    }

    public UserService getUserService() {
        if (NetworkUtils.isNetworkEnable(this.mContext)) {
            return this.mUserService;
        }
        new GlobalMsgEvent().setDisplayType(GlobalMsgEvent.DisplayType.Dialog).setMsg("\u65e0\u6cd5\u8fde\u63a5\u5230\u7f51\u7edc\uff0c\u8bf7\u7a0d\u5019\u518d\u8bd5").send();
        return null;
    }

    public static class Builder {
        private String baseUrl;
        private String certificatesFileName;
        private SSLSocketFactory sslSocketFactory;
        private OkHttpClient.Builder builder;

        public Builder setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder setCertificates(String certificatesFileName) {
            this.certificatesFileName = certificatesFileName;
            return this;
        }

        public UserManager build(@NonNull Context application) {
            this.initSslSocketFactory(application);
            this.initOkHttpBuilder(application);
            instance = new UserManager(application, this.initRetrofitService());
            return instance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initSslSocketFactory(Context context) {
            InputStream inputStream = null;
            try {
                if (!EmptyUtils.isEmpty(this.certificatesFileName)) {
                    inputStream = context.getAssets().open(this.certificatesFileName);
                    if (inputStream != null) {
                        this.sslSocketFactory = HTTPSTrustManager.buildSSLSocketFactory(inputStream);
                    }
                } else {
                    this.sslSocketFactory = HTTPSTrustManager.allowAllSSLSocketFactory();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        private void initOkHttpBuilder(Context application) {
            Interceptor headInterceptor = new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Request request = chain.request().newBuilder().addHeader("Content-Type", "application/octet-stream;charset=UTF-8").build();
                    return chain.proceed(request);
                }
            };
            this.builder = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).addInterceptor(headInterceptor).hostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
            if (AppUtil.isApkDebugable(application, application.getPackageName())) {
                this.builder.addInterceptor((Interceptor)new HttpLoggingInterceptor().setLevel(HttpLoggingInterceptor.Level.NONE));
            }
            if (this.sslSocketFactory != null) {
                this.builder.sslSocketFactory(this.sslSocketFactory, (X509TrustManager)new HTTPSTrustManager());
            }
        }

        private UserService initRetrofitService() {
            OkHttpClient okHttpClient = this.builder.build();
            if (okHttpClient != null) {
                Retrofit retrofit = new Retrofit.Builder().client(okHttpClient).baseUrl(this.baseUrl).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
                return (UserService)retrofit.create(UserService.class);
            }
            return null;
        }
    }
}

