/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.databinding;

import com.google.gson.Gson;
import com.komect.network.bean.NetworkDevice;
import com.komect.network.komectinnet.bean.request.RouterEntity;
import com.komect.network.komectinnet.bean.request.RouterList;
import com.komect.network.komectinnet.bean.response.WiFiCoverEntity;
import com.komect.network.komectinnet.sdk.KomectManager;
import com.komect.network.komectinnet.sdk.RetrofitService;
import com.komect.network.komectinnet.utils.EncryptUtil;
import com.komect.network.utils.UnitUtil;
import java.util.ArrayList;
import java.util.List;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class WifiCoverPresenter {
    private String mockWifiCoverResponse = "{\n    \"recode\":200,\n    \"msg\":\"msg\",\n    \"data\":{\n        \"wifiMap\":\"http://qhyxpic.oss.kujiale.com/wifiWLjjwgp1KDkGPQAAAAo.png\",\n        \"reliableRate\":0.7886331\n    }\n}";

    private RouterEntity deviceToRouter(NetworkDevice device) {
        double power = Double.parseDouble(device.getPower());
        RouterEntity entity = new RouterEntity();
        double y = UnitUtil.ratioInParent(device.getParentHeight(), device.getY());
        double x = UnitUtil.ratioInParent(device.getParentWitdh(), device.getX());
        entity.setX(x);
        entity.setY(y);
        entity.setPower(UnitUtil.dBm2Power(power));
        return entity;
    }

    public List<RouterEntity> getRouters(List<NetworkDevice> devices) {
        ArrayList<RouterEntity> routers = new ArrayList<RouterEntity>();
        for (NetworkDevice device : devices) {
            routers.add(this.deviceToRouter(device));
        }
        return routers;
    }

    public void getWifiCover(String obsPlanId, List<NetworkDevice> devices) {
        long timestamp = System.currentTimeMillis();
        String sign = EncryptUtil.MD5("crAB00NhhIuwvaHpj9mD7Kec5oRaucmWFnkPaR4GWx" + timestamp);
        RouterList routerList = new RouterList().setRouters(this.getRouters(devices));
        RetrofitService retrofitService = KomectManager.getInstance().getRetrofitService();
        if (retrofitService == null) {
            return;
        }
        retrofitService.wificover(obsPlanId, "FnkPaR4GWx", timestamp, sign, new Gson().toJson((Object)routerList)).enqueue((Callback)new Callback<WiFiCoverEntity>(){

            public void onResponse(Call<WiFiCoverEntity> call, Response<WiFiCoverEntity> response) {
                WiFiCoverEntity wiFiCoverEvent = (WiFiCoverEntity)response.body();
                wiFiCoverEvent.send();
            }

            public void onFailure(Call<WiFiCoverEntity> call, Throwable t) {
            }
        });
    }
}

