/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.databinding;

import com.komect.network.bean.LoginBean;
import com.komect.network.komectinnet.bean.response.AccountDataEntity;
import com.komect.network.komectinnet.bean.response.LoginResult;
import com.komect.network.komectinnet.event.GlobalMsgEvent;
import com.komect.network.komectinnet.sdk.UserManager;
import com.komect.network.komectinnet.sdk.UserService;
import com.komect.network.komectinnet.utils.StringUtil;
import com.komect.network.utils.SimpleCacheUtil;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class LoginPresenter {
    private SimpleCacheUtil cacheUtil;

    public SimpleCacheUtil getCacheUtil() {
        return this.cacheUtil;
    }

    public void setCacheUtil(SimpleCacheUtil cacheUtil) {
        this.cacheUtil = cacheUtil;
    }

    public void onLoginClick(LoginBean login) {
        UserService userService = UserManager.getInstance().getUserService();
        if (userService == null) {
            return;
        }
        if (!StringUtil.isMobile(login.getPhone())) {
            new GlobalMsgEvent().setMsg("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u624b\u673a\u53f7").send();
            return;
        }
        userService.login(login.getPhone(), login.getPassword(), "3").enqueue((Callback)new Callback<LoginResult>(){

            public void onResponse(Call<LoginResult> call, Response<LoginResult> response) {
                LoginResult loginResult = (LoginResult)response.body();
                loginResult.send();
                if (loginResult.getRecode() == 200 && loginResult.getData() != null) {
                    LoginPresenter.this.saveAccountInfo(loginResult.getData());
                }
            }

            public void onFailure(Call<LoginResult> call, Throwable t) {
                new GlobalMsgEvent().setMsg("\u670d\u52a1\u5668\u54cd\u5e94\u5f02\u5e38").send();
            }
        });
    }

    public void onGetCode(LoginBean login) {
        UserService userService = UserManager.getInstance().getUserService();
        if (userService == null) {
            return;
        }
        if (!StringUtil.isMobile(login.getPhone())) {
            new GlobalMsgEvent().setMsg("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u624b\u673a\u53f7").send();
            return;
        }
    }

    private void saveAccountInfo(AccountDataEntity account) {
        this.cacheUtil.put("cache_account_info", account);
    }
}

