/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.databinding;

import android.databinding.BindingAdapter;
import android.util.Log;
import android.widget.ImageView;
import android.widget.TextView;
import com.komect.network.R;
import com.komect.network.komectinnet.utils.EmptyUtils;
import com.komect.network.utils.GlideImageUtil;

public class BindConverters {
    @BindingAdapter(value={"bind:imageUrl", "bind:error"})
    public static void deviceloadImage(ImageView view, String url, int error) {
        if (!EmptyUtils.isEmpty(url)) {
            Log.d((String)"BindConverters", (String)("loadImage " + url));
            GlideImageUtil.displayImage(view.getContext(), url, error, view);
        }
    }

    @BindingAdapter(value={"bind:imageUrl"})
    public static void showImage(ImageView view, String url) {
        if (!EmptyUtils.isEmpty(url)) {
            Log.d((String)"BindConverters", (String)("loadImage " + url));
            GlideImageUtil.displayImage(view.getContext(), url, view);
        }
    }

    @BindingAdapter(value={"bind:level"})
    public static void loadWifilevel(TextView view, int level) {
        if (level < -80) {
            view.setTextColor(view.getContext().getResources().getColor(R.color.nw_red));
        } else if (level >= -60) {
            view.setTextColor(view.getContext().getResources().getColor(R.color.nw_green));
        } else {
            view.setTextColor(view.getContext().getResources().getColor(R.color.nw_yellow));
        }
    }

    @BindingAdapter(value={"bind:imageLevel"})
    public static void loadImagelevel(ImageView view, int level) {
        if (level < -80) {
            view.setBackground(view.getContext().getResources().getDrawable(R.drawable.ic_wifi_red));
        } else if (level >= -60) {
            view.setBackground(view.getContext().getResources().getDrawable(R.drawable.ic_wifi_green));
        } else {
            view.setBackground(view.getContext().getResources().getDrawable(R.drawable.ic_wifi_yellow));
        }
    }

    @BindingAdapter(value={"bind:coverage"})
    public static void loadImage(ImageView view, double coverage) {
        if (coverage < 0.4) {
            view.setImageResource(R.drawable.icon_bad);
        } else if (coverage >= 0.8) {
            view.setImageResource(R.drawable.icon_good);
        } else if (coverage >= 0.6) {
            view.setImageResource(R.drawable.icon_will);
        } else if (coverage >= 0.4) {
            view.setImageResource(R.drawable.icon_common);
        }
    }
}

