/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.database;

import com.komect.network.bean.NetworkDevice;
import com.komect.network.bean.TestPoint;
import com.komect.network.bean.WiFiCoverage;
import com.komect.network.database.HistoryLog;
import com.komect.network.database.OrderEntity;
import com.komect.network.komectinnet.bean.response.FamilyEntity;
import com.komect.network.komectinnet.utils.StringUtil;
import com.komect.network.litepal.crud.DataSupport;
import java.util.List;

public class DbManager
extends DataSupport {
    private String userId;
    private static DbManager manager;
    private Integer orderId;

    private DbManager(String userId) {
        this.userId = userId;
    }

    public static DbManager initialize(String userId) {
        if (manager == null || !StringUtil.equals(DbManager.manager.userId, userId)) {
            manager = new DbManager(userId);
        }
        return manager;
    }

    public static DbManager getManager() {
        return manager;
    }

    public void saveHistory(String keyword, int hisType) {
        String[] condition = new String[]{"userId=? and keyword=? and histype=?", this.userId, keyword, hisType + ""};
        HistoryLog historyLog = new HistoryLog().setUserId(this.userId).setKeyword(keyword).setHisType(hisType).setTime(System.currentTimeMillis());
        if (DataSupport.isExist(HistoryLog.class, condition)) {
            historyLog.updateAll(condition);
        } else {
            List<HistoryLog> historyLogList = this.getHistoryList(hisType);
            if (historyLogList.size() >= 5) {
                HistoryLog lastHistoryLog = historyLogList.get(4);
                lastHistoryLog.delete();
                historyLog.save();
            } else {
                historyLog.save();
            }
        }
    }

    public List<HistoryLog> getHistoryList(int hisType) {
        return DataSupport.where("userId = ? and histype=?", this.userId, hisType + "").order("time desc").find(HistoryLog.class);
    }

    public void clearHistoryList(int hisType) {
        String[] condition = new String[]{"userId=? and histype=?", this.userId, hisType + ""};
        DataSupport.deleteAll(HistoryLog.class, condition);
    }

    public void saveOrderEntity(OrderEntity orderEntity) {
        orderEntity.setUserId(this.userId);
        orderEntity.save();
        this.orderId = DataSupport.findLast(OrderEntity.class).getId();
    }

    public void updateOrderEntityWithBuildingInfo(FamilyEntity familyEntity) {
        OrderEntity currentEntity = DataSupport.findLast(OrderEntity.class);
        currentEntity.setSpecName(familyEntity.getSpecName());
        currentEntity.setPlanCity(familyEntity.getPlanCity());
        currentEntity.setArea(familyEntity.getArea());
        currentEntity.setPics(familyEntity.getPics());
        currentEntity.setObsPlanId(familyEntity.getObsPlanId());
        currentEntity.setCommName(familyEntity.getCommName());
        currentEntity.update(this.orderId.intValue());
    }

    public void updateOrderEntityRemoveBuildingInfo() {
        OrderEntity currentEntity = DataSupport.findLast(OrderEntity.class);
        currentEntity.setToDefault("planCity");
        currentEntity.setToDefault("obsPlanId");
        currentEntity.setToDefault("commName");
        currentEntity.update(this.orderId.intValue());
    }

    public void updateOrderEntityToSave() {
        OrderEntity currentEntity = DataSupport.findLast(OrderEntity.class);
        currentEntity.setSaved(true);
        currentEntity.update(this.orderId.intValue());
    }

    public List<OrderEntity> getAllOrderEntity() {
        return DataSupport.where("userId = ? and isSaved = 1", this.userId).order("id desc").find(OrderEntity.class);
    }

    public List<OrderEntity> getOrderEntityByKeyword(String keyword) {
        return DataSupport.where("userId = ? and isSaved = 1 and (broadbandAccount like ? or orderNumber like ? or username like ? or mobile like ? or planCity like ?or commName like ?)", this.userId, "%" + keyword + "%", "%" + keyword + "%", "%" + keyword + "%", "%" + keyword + "%", "%" + keyword + "%", "%" + keyword + "%").order("id desc").find(OrderEntity.class);
    }

    public Integer getOrderId() {
        return this.orderId;
    }

    public void setOrderId(Integer orderId) {
        this.orderId = orderId;
    }

    public void saveDevice(NetworkDevice device, int dataType) {
        try {
            NetworkDevice networkDevice = (NetworkDevice)device.clone();
            networkDevice.setDataType(dataType);
            networkDevice.setForeignKey(this.getOrderId());
            networkDevice.save();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
    }

    public void updateDevice(NetworkDevice device, int dataType) {
        device.setDataType(dataType);
        device.setForeignKey(this.getOrderId());
        device.updateAll("foreignkey = ? and datatype = ?", this.getOrderId() + "", dataType + "");
    }

    public void saveCoverage(WiFiCoverage coverage, int dataType) {
        try {
            WiFiCoverage wiFiCoverage = (WiFiCoverage)coverage.clone();
            wiFiCoverage.setDataType(dataType);
            wiFiCoverage.setForeignKey(this.getOrderId());
            wiFiCoverage.save();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
    }

    public void updateCoverage(WiFiCoverage coverage, int dataType) {
        coverage.setDataType(dataType);
        coverage.setForeignKey(this.getOrderId());
        coverage.updateAll("foreignkey = ? and datatype = ?", this.getOrderId() + "", dataType + "");
    }

    public List<WiFiCoverage> getCoverages(int dataType) {
        return DataSupport.where("foreignkey = ? and datatype = ?", this.getOrderId() + "", dataType + "").find(WiFiCoverage.class);
    }

    public WiFiCoverage getCoverage(int dataType) {
        List<WiFiCoverage> list = DataSupport.where("foreignkey = ? and datatype = ?", this.getOrderId() + "", dataType + "").find(WiFiCoverage.class);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public void saveTP(TestPoint tp, int dataType) {
        try {
            TestPoint testPoint = (TestPoint)tp.clone();
            testPoint.setDataType(dataType);
            testPoint.setForeignKey(this.getOrderId());
            testPoint.save();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
    }

    public void updateTP(TestPoint tp, int dataType) {
        tp.setDataType(dataType);
        tp.setForeignKey(this.getOrderId());
        tp.updateAll("foreignkey = ?", this.getOrderId() + "");
    }

    public List<NetworkDevice> getDeviceList(int dataType) {
        return DataSupport.where("foreignkey = ? and datatype = ?", this.getOrderId() + "", dataType + "").find(NetworkDevice.class);
    }

    public List<TestPoint> getTestPoint(int dataType) {
        return DataSupport.where("foreignkey = ? and datatype = ?", this.getOrderId() + "", dataType + "").find(TestPoint.class);
    }

    public void deleteAllDevice(int dataType) {
        DataSupport.deleteAll(NetworkDevice.class, "foreignkey = ? and datatype = ?", this.getOrderId() + "", dataType + "");
    }

    public void deleteAllTP(int dataType) {
        DataSupport.deleteAll(TestPoint.class, "foreignkey = ? and datatype = ?", this.getOrderId() + "", dataType + "");
    }

    public void deleteAllCoverage(int dataType) {
        DataSupport.deleteAll(WiFiCoverage.class, "foreignkey = ? and datatype = ?", this.getOrderId() + "", dataType + "");
    }

    public void deleteAll(int dataType) {
        this.deleteAllDevice(dataType);
        this.deleteAllTP(dataType);
        this.deleteAllCoverage(dataType);
    }
}

