/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.database;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.os.Environment;
import com.github.promeg.pinyinhelper.Pinyin;
import com.komect.network.komectinnet.bean.request.City;
import com.komect.network.komectinnet.bean.response.CityEntity;
import com.komect.network.komectinnet.bean.response.CityListEntity;
import com.komect.network.komectinnet.event.ListResultEvent;
import java.io.File;
import java.util.List;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

public class CityDbManager {
    private String dbPath;
    private static final String DB_NAME = "china_cities.db";

    public CityDbManager(Context context) {
        this.dbPath = File.separator + "data" + Environment.getDataDirectory().getAbsolutePath() + File.separator + context.getPackageName() + File.separator + "databases" + File.separator;
        EventBus.getDefault().register((Object)this);
    }

    public void createDBFile() {
        File dbFile = new File(this.dbPath + DB_NAME);
        if (!dbFile.exists()) {
            new City().post();
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void getCityList(ListResultEvent event) {
        File dbFile;
        List<?> list = event.getList();
        File dir = new File(this.dbPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!(dbFile = new File(this.dbPath + DB_NAME)).exists()) {
            SQLiteDatabase db = SQLiteDatabase.openOrCreateDatabase((String)(this.dbPath + DB_NAME), null);
            String sqlNew = "CREATE TABLE City(cityid Interger,name Text,pinyin Text)";
            db.execSQL(sqlNew);
            String sqlUpdate = "INSERT INTO City(cityid,name,pinyin) VALUES (?,?,?)";
            for (int i = 0; i < list.size(); ++i) {
                List<CityEntity> listEntity = ((CityListEntity)list.get(i)).getCities();
                for (int j = 0; j < listEntity.size(); ++j) {
                    db.execSQL(sqlUpdate, new Object[]{listEntity.get(j).getCityid(), listEntity.get(j).getName(), Pinyin.toPinyin((String)listEntity.get(j).getName(), (String)"")});
                }
            }
        }
    }

    public void onStop() {
        EventBus.getDefault().unregister((Object)this);
    }
}

