/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.connectionclass;

class ExponentialGeometricAverage {
    private final double mDecayConstant;
    private final int mCutover;
    private double mValue = -1.0;
    private int mCount;

    public ExponentialGeometricAverage(double decayConstant) {
        this.mDecayConstant = decayConstant;
        this.mCutover = decayConstant == 0.0 ? Integer.MAX_VALUE : (int)Math.ceil(1.0 / decayConstant);
    }

    public void addMeasurement(double measurement) {
        double keepConstant = 1.0 - this.mDecayConstant;
        if (this.mCount > this.mCutover) {
            this.mValue = Math.exp(keepConstant * Math.log(this.mValue) + this.mDecayConstant * Math.log(measurement));
        } else if (this.mCount > 0) {
            double retained = keepConstant * (double)this.mCount / ((double)this.mCount + 1.0);
            double newcomer = 1.0 - retained;
            this.mValue = Math.exp(retained * Math.log(this.mValue) + newcomer * Math.log(measurement));
        } else {
            this.mValue = measurement;
        }
        ++this.mCount;
    }

    public double getAverage() {
        return this.mValue;
    }

    public void reset() {
        this.mValue = -1.0;
        this.mCount = 0;
    }
}

