/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.connectionclass;

import android.net.TrafficStats;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import com.komect.network.connectionclass.ConnectionClassManager;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;

public class DeviceBandwidthSampler {
    private final ConnectionClassManager mConnectionClassManager;
    private AtomicInteger mSamplingCounter;
    private SamplingHandler mHandler;
    private HandlerThread mThread;
    private long mLastTimeReading;
    private static long sPreviousBytes = -1L;

    @Nonnull
    public static DeviceBandwidthSampler getInstance() {
        return DeviceBandwidthSamplerHolder.instance;
    }

    private DeviceBandwidthSampler(ConnectionClassManager connectionClassManager) {
        this.mConnectionClassManager = connectionClassManager;
        this.mSamplingCounter = new AtomicInteger();
        this.mThread = new HandlerThread("ParseThread");
        this.mThread.start();
        this.mHandler = new SamplingHandler(this.mThread.getLooper());
    }

    public void startSampling() {
        if (this.mSamplingCounter.getAndIncrement() == 0) {
            this.mHandler.startSamplingThread();
            this.mLastTimeReading = SystemClock.elapsedRealtime();
        }
    }

    public void stopSampling() {
        if (this.mSamplingCounter.decrementAndGet() == 0) {
            this.mHandler.stopSamplingThread();
            this.addFinalSample();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSample() {
        long newBytes = TrafficStats.getTotalRxBytes();
        long byteDiff = newBytes - sPreviousBytes;
        if (sPreviousBytes >= 0L) {
            DeviceBandwidthSampler deviceBandwidthSampler = this;
            synchronized (deviceBandwidthSampler) {
                long curTimeReading = SystemClock.elapsedRealtime();
                this.mConnectionClassManager.addBandwidth(byteDiff, curTimeReading - this.mLastTimeReading);
                this.mLastTimeReading = curTimeReading;
            }
        }
        sPreviousBytes = newBytes;
    }

    protected void addFinalSample() {
        this.addSample();
        sPreviousBytes = -1L;
    }

    public boolean isSampling() {
        return this.mSamplingCounter.get() != 0;
    }

    private class SamplingHandler
    extends Handler {
        static final long SAMPLE_TIME = 1000L;
        private static final int MSG_START = 1;

        public SamplingHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    DeviceBandwidthSampler.this.addSample();
                    this.sendEmptyMessageDelayed(1, 1000L);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown what=" + msg.what);
                }
            }
        }

        public void startSamplingThread() {
            this.sendEmptyMessage(1);
        }

        public void stopSamplingThread() {
            this.removeMessages(1);
        }
    }

    private static class DeviceBandwidthSamplerHolder {
        public static final DeviceBandwidthSampler instance = new DeviceBandwidthSampler(ConnectionClassManager.getInstance());

        private DeviceBandwidthSamplerHolder() {
        }
    }
}

