/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.connectionclass;

import com.komect.network.connectionclass.ConnectionQuality;
import com.komect.network.connectionclass.ExponentialGeometricAverage;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;

public class ConnectionClassManager {
    static final double DEFAULT_SAMPLES_TO_QUALITY_CHANGE = 5.0;
    private static final int BYTES_TO_BITS = 8;
    static final int DEFAULT_POOR_BANDWIDTH = 150;
    static final int DEFAULT_MODERATE_BANDWIDTH = 550;
    static final int DEFAULT_GOOD_BANDWIDTH = 2000;
    static final long DEFAULT_HYSTERESIS_PERCENT = 20L;
    private static final double HYSTERESIS_TOP_MULTIPLIER = 1.25;
    private static final double HYSTERESIS_BOTTOM_MULTIPLIER = 0.8;
    private static final double DEFAULT_DECAY_CONSTANT = 0.05;
    private ExponentialGeometricAverage mDownloadBandwidth = new ExponentialGeometricAverage(0.05);
    private volatile boolean mInitiateStateChange = false;
    private AtomicReference<ConnectionQuality> mCurrentBandwidthConnectionQuality = new AtomicReference<ConnectionQuality>(ConnectionQuality.UNKNOWN);
    private AtomicReference<ConnectionQuality> mNextBandwidthConnectionQuality;
    private ArrayList<ConnectionClassStateChangeListener> mListenerList = new ArrayList();
    private int mSampleCounter;
    static final long BANDWIDTH_LOWER_BOUND = 10L;

    @Nonnull
    public static ConnectionClassManager getInstance() {
        return ConnectionClassManagerHolder.instance;
    }

    private ConnectionClassManager() {
    }

    public synchronized void addBandwidth(long bytes, long timeInMs) {
        if (timeInMs == 0L || (double)bytes * 1.0 / (double)timeInMs * 8.0 < 10.0) {
            return;
        }
        double bandwidth = (double)bytes * 1.0 / (double)timeInMs * 8.0;
        this.mDownloadBandwidth.addMeasurement(bandwidth);
        if (this.mInitiateStateChange) {
            ++this.mSampleCounter;
            if (this.getCurrentBandwidthQuality() != this.mNextBandwidthConnectionQuality.get()) {
                this.mInitiateStateChange = false;
                this.mSampleCounter = 1;
            }
            if ((double)this.mSampleCounter >= 5.0 && this.significantlyOutsideCurrentBand()) {
                this.mInitiateStateChange = false;
                this.mSampleCounter = 1;
                this.mCurrentBandwidthConnectionQuality.set(this.mNextBandwidthConnectionQuality.get());
                this.notifyListeners();
            }
            return;
        }
        if (this.mCurrentBandwidthConnectionQuality.get() != this.getCurrentBandwidthQuality()) {
            this.mInitiateStateChange = true;
            this.mNextBandwidthConnectionQuality = new AtomicReference<ConnectionQuality>(this.getCurrentBandwidthQuality());
        }
    }

    private boolean significantlyOutsideCurrentBand() {
        double topOfBand;
        double bottomOfBand;
        if (this.mDownloadBandwidth == null) {
            return false;
        }
        ConnectionQuality currentQuality = this.mCurrentBandwidthConnectionQuality.get();
        switch (currentQuality) {
            case POOR: {
                bottomOfBand = 0.0;
                topOfBand = 150.0;
                break;
            }
            case MODERATE: {
                bottomOfBand = 150.0;
                topOfBand = 550.0;
                break;
            }
            case GOOD: {
                bottomOfBand = 550.0;
                topOfBand = 2000.0;
                break;
            }
            case EXCELLENT: {
                bottomOfBand = 2000.0;
                topOfBand = 3.4028234663852886E38;
                break;
            }
            default: {
                return true;
            }
        }
        double average = this.mDownloadBandwidth.getAverage();
        return average > topOfBand ? average > topOfBand * 1.25 : average < bottomOfBand * 0.8;
    }

    public void reset() {
        if (this.mDownloadBandwidth != null) {
            this.mDownloadBandwidth.reset();
        }
        this.mCurrentBandwidthConnectionQuality.set(ConnectionQuality.UNKNOWN);
    }

    public synchronized ConnectionQuality getCurrentBandwidthQuality() {
        if (this.mDownloadBandwidth == null) {
            return ConnectionQuality.UNKNOWN;
        }
        return this.mapBandwidthQuality(this.mDownloadBandwidth.getAverage());
    }

    private ConnectionQuality mapBandwidthQuality(double average) {
        if (average < 0.0) {
            return ConnectionQuality.UNKNOWN;
        }
        if (average < 150.0) {
            return ConnectionQuality.POOR;
        }
        if (average < 550.0) {
            return ConnectionQuality.MODERATE;
        }
        if (average < 2000.0) {
            return ConnectionQuality.GOOD;
        }
        return ConnectionQuality.EXCELLENT;
    }

    public synchronized double getDownloadKBitsPerSecond() {
        return this.mDownloadBandwidth == null ? -1.0 : this.mDownloadBandwidth.getAverage();
    }

    public ConnectionQuality register(ConnectionClassStateChangeListener listener) {
        if (listener != null) {
            this.mListenerList.add(listener);
        }
        return this.mCurrentBandwidthConnectionQuality.get();
    }

    public void remove(ConnectionClassStateChangeListener listener) {
        if (listener != null) {
            this.mListenerList.remove(listener);
        }
    }

    private void notifyListeners() {
        int size = this.mListenerList.size();
        for (int i = 0; i < size; ++i) {
            this.mListenerList.get(i).onBandwidthStateChange(this.mCurrentBandwidthConnectionQuality.get());
        }
    }

    public static interface ConnectionClassStateChangeListener {
        public void onBandwidthStateChange(ConnectionQuality var1);
    }

    private static class ConnectionClassManagerHolder {
        public static final ConnectionClassManager instance = new ConnectionClassManager();

        private ConnectionClassManagerHolder() {
        }
    }
}

