/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.connectionclass;

import java.util.NoSuchElementException;
import javax.annotation.Nullable;

class ByteArrayScanner {
    @Nullable
    private byte[] mData;
    private int mCurrentOffset;
    private int mTotalLength;
    private char mDelimiter;
    private boolean mDelimiterSet;

    ByteArrayScanner() {
    }

    public ByteArrayScanner reset(byte[] buffer, int length) {
        this.mData = buffer;
        this.mCurrentOffset = 0;
        this.mTotalLength = length;
        this.mDelimiterSet = false;
        return this;
    }

    public ByteArrayScanner useDelimiter(char delimiter) {
        this.throwIfNotReset();
        this.mDelimiter = delimiter;
        this.mDelimiterSet = true;
        return this;
    }

    private void throwIfNotReset() {
        if (this.mData == null) {
            throw new IllegalStateException("Must call reset first");
        }
    }

    private void throwIfDelimiterNotSet() {
        if (!this.mDelimiterSet) {
            throw new IllegalStateException("Must call useDelimiter first");
        }
    }

    public String nextString() throws NoSuchElementException {
        this.throwIfNotReset();
        this.throwIfDelimiterNotSet();
        int offset = this.mCurrentOffset;
        int length = this.advance();
        return new String(this.mData, offset, length);
    }

    public boolean nextStringEquals(String str) throws NoSuchElementException {
        int offset = this.mCurrentOffset;
        int length = this.advance();
        if (str.length() != length) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != this.mData[offset]) {
                return false;
            }
            ++offset;
        }
        return true;
    }

    public int nextInt() throws NoSuchElementException {
        this.throwIfNotReset();
        this.throwIfDelimiterNotSet();
        int offset = this.mCurrentOffset;
        int length = this.advance();
        int value = ByteArrayScanner.parseInt(this.mData, offset, offset + length);
        return value;
    }

    public void skip() throws NoSuchElementException {
        this.throwIfNotReset();
        this.throwIfDelimiterNotSet();
        this.advance();
    }

    private int advance() throws NoSuchElementException {
        this.throwIfNotReset();
        this.throwIfDelimiterNotSet();
        if (this.mTotalLength <= this.mCurrentOffset) {
            throw new NoSuchElementException("Reading past end of input stream at " + this.mCurrentOffset + ".");
        }
        int index = ByteArrayScanner.indexOf(this.mData, this.mCurrentOffset, this.mTotalLength, this.mDelimiter);
        if (index == -1) {
            int length = this.mTotalLength - this.mCurrentOffset;
            this.mCurrentOffset = this.mTotalLength;
            return length;
        }
        int length = index - this.mCurrentOffset;
        this.mCurrentOffset = index + 1;
        return length;
    }

    private static int parseInt(byte[] buffer, int start, int end) throws NumberFormatException {
        int radix = 10;
        int result = 0;
        while (start < end) {
            int next;
            int digit;
            if ((digit = buffer[start++] - 48) < 0 || digit > 9) {
                throw new NumberFormatException("Invalid int in buffer at " + (start - 1) + ".");
            }
            result = next = result * radix + digit;
        }
        return result;
    }

    private static int indexOf(byte[] data, int start, int end, char ch) {
        for (int i = start; i < end; ++i) {
            if (data[i] != ch) continue;
            return i;
        }
        return -1;
    }
}

