/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.common;

import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.support.v7.app.AlertDialog;
import android.widget.Toast;
import com.komect.network.common.BasePresenter;
import com.komect.network.event.ActivityStartEvent;
import com.komect.network.komectinnet.event.GlobalMsgEvent;
import com.komect.network.komectinnet.utils.EmptyUtils;
import com.zhy.autolayout.AutoLayoutActivity;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

public class BaseActivity
extends AutoLayoutActivity {
    protected static final String EXTRA_BUNDLE = "bundle";
    private ProgressDialog mProgressDialog;
    private AlertDialog mAlertDialog;
    private BasePresenter[] mPresenters;

    protected void onResume() {
        super.onResume();
        EventBus.getDefault().register((Object)this);
        if (!EmptyUtils.isEmpty(this.mPresenters)) {
            for (BasePresenter presenter : this.mPresenters) {
                presenter.registerEventBus();
            }
        }
    }

    protected void onPause() {
        super.onPause();
        EventBus.getDefault().unregister((Object)this);
        if (!EmptyUtils.isEmpty(this.mPresenters)) {
            for (BasePresenter presenter : this.mPresenters) {
                presenter.unregisterEventBus();
            }
        }
    }

    public void onBackPressed() {
        this.dismissAlertDialog();
        this.dismissProgressDialog();
        super.onBackPressed();
    }

    protected void onDestroy() {
        if (!EmptyUtils.isEmpty(this.mPresenters)) {
            for (BasePresenter presenter : this.mPresenters) {
                presenter.cleanOnActivityDestory();
            }
        }
        super.onDestroy();
    }

    protected final void setPresenters(BasePresenter ... presenters) {
        this.mPresenters = presenters;
    }

    public void showProgressDialog(CharSequence msg) {
        if (this.mProgressDialog == null) {
            this.mProgressDialog = ProgressDialog.show((Context)this, null, (CharSequence)msg);
            this.mProgressDialog.setCancelable(true);
        } else {
            this.mProgressDialog.setMessage(msg);
            if (!this.mProgressDialog.isShowing()) {
                this.mProgressDialog.show();
            }
        }
    }

    public void dismissProgressDialog() {
        if (this.mProgressDialog != null && this.mProgressDialog.isShowing()) {
            this.mProgressDialog.dismiss();
        }
    }

    public void showAlertDialog(CharSequence msg) {
        if (this.mAlertDialog == null) {
            this.mAlertDialog = new AlertDialog.Builder((Context)this).setMessage(msg).setPositiveButton((CharSequence)"\u786e\u5b9a", null).create();
        } else {
            this.mAlertDialog.setMessage(msg);
        }
        this.mAlertDialog.show();
    }

    public void showAlertDialog(CharSequence msg, DialogInterface.OnClickListener onPositiveClick) {
        if (this.mAlertDialog == null) {
            this.mAlertDialog = new AlertDialog.Builder((Context)this).setMessage(msg).setPositiveButton((CharSequence)"\u786e\u5b9a", onPositiveClick).create();
        } else {
            this.mAlertDialog.setMessage(msg);
        }
        this.mAlertDialog.show();
    }

    public void dismissAlertDialog() {
        if (this.mAlertDialog != null && this.mAlertDialog.isShowing()) {
            this.mAlertDialog.dismiss();
        }
    }

    public void showAlertDialog(CharSequence title, CharSequence msg, DialogInterface.OnClickListener onPositiveClick) {
        if (this.mAlertDialog != null && this.mAlertDialog.isShowing()) {
            this.mAlertDialog.dismiss();
        }
        this.mAlertDialog = new AlertDialog.Builder((Context)this).setTitle(title).setMessage(msg).setPositiveButton((CharSequence)"\u786e\u5b9a", onPositiveClick).setNegativeButton((CharSequence)"\u53d6\u6d88", null).setCancelable(false).show();
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onGlobalMsg(GlobalMsgEvent event) {
        this.dismissProgressDialog();
        if (event.getDisplayType() == GlobalMsgEvent.DisplayType.Toast) {
            Toast.makeText((Context)this, (CharSequence)("" + event.getMsg()), (int)0).show();
        } else if (event.getDisplayType() == GlobalMsgEvent.DisplayType.Dialog) {
            if (event.isCloseDialog()) {
                this.dismissAlertDialog();
            } else {
                this.showAlertDialog(event.getMsg());
            }
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onActivityStartEvent(ActivityStartEvent event) {
        if (event == null) {
            return;
        }
        if (event.getTargetActivityCls() != null) {
            Intent intent = new Intent((Context)this, event.getTargetActivityCls());
            if (event.getIntentFlags() > 0) {
                intent.setFlags(event.getIntentFlags());
            }
            if (event.getBundle() != null) {
                intent.putExtra(EXTRA_BUNDLE, event.getBundle());
            }
            if (event.getRequestCode() > 0) {
                this.startActivityForResult(intent, event.getRequestCode());
            } else {
                this.startActivity(intent);
            }
        }
        if (event.isFinishCurrentActivity()) {
            if (event.getResult() == -1) {
                this.setResult(-1);
            }
            this.finish();
        }
    }
}

