/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.bean;

import com.komect.network.litepal.crud.DataSupport;
import java.text.NumberFormat;

public class WiFiCoverage
extends DataSupport
implements Cloneable {
    private int dataType;
    private Integer foreignKey;
    private double reliableRate;
    public String wifiMap;
    public String houseImg;

    public WiFiCoverage() {
    }

    public WiFiCoverage(double coverage, String heatMapUrl) {
        this.reliableRate = coverage;
        this.wifiMap = heatMapUrl;
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setDataType(int dataType) {
        this.dataType = dataType;
    }

    public Integer getForeignKey() {
        return this.foreignKey;
    }

    public void setForeignKey(Integer foreignKey) {
        this.foreignKey = foreignKey;
    }

    public double getReliableRate() {
        return this.reliableRate;
    }

    public void setReliableRate(double reliableRate) {
        this.reliableRate = reliableRate;
    }

    public String getCoverageStr() {
        NumberFormat nt = NumberFormat.getPercentInstance();
        nt.setMinimumFractionDigits(1);
        return String.format("\u8986\u76d6\u7387 %s", nt.format(this.reliableRate));
    }

    public String getWifiMap() {
        return this.wifiMap;
    }

    public void setWifiMap(String wifiMap) {
        this.wifiMap = wifiMap;
    }

    public String getHouseImg() {
        return this.houseImg;
    }

    public void setHouseImg(String houseImg) {
        this.houseImg = houseImg;
    }

    public WiFiCoverage reset() {
        this.setWifiMap(this.getHouseImg());
        this.setReliableRate(0.0);
        return this;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

