/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.app.widget.dropmenu;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.komect.network.R;
import com.komect.network.app.widget.dropmenu.DeviceUtils;
import java.util.List;

public class DropDownMenu
extends LinearLayout {
    private LinearLayout tabMenuView;
    private FrameLayout containerView;
    private FrameLayout popupMenuViews;
    private View maskView;
    private int current_tab_position = -1;
    private int dividerColor = -3355444;
    private int textSelectedColor = -7795579;
    private int textUnselectedColor = -15658735;
    private int maskColor = -2004318072;
    private int menuTextSize = 14;
    private int menuSelectedIcon;
    private int menuUnselectedIcon;
    private float menuHeighPercent = 0.5f;

    public DropDownMenu(Context context) {
        super(context, null);
    }

    public DropDownMenu(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DropDownMenu(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setOrientation(1);
        int menuBackgroundColor = -1;
        int underlineColor = -3355444;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.DropDownMenu);
        underlineColor = a.getColor(R.styleable.DropDownMenu_ddunderlineColor, underlineColor);
        this.dividerColor = a.getColor(R.styleable.DropDownMenu_dddividerColor, this.dividerColor);
        this.textSelectedColor = a.getColor(R.styleable.DropDownMenu_ddtextSelectedColor, this.textSelectedColor);
        this.textUnselectedColor = a.getColor(R.styleable.DropDownMenu_ddtextUnselectedColor, this.textUnselectedColor);
        menuBackgroundColor = a.getColor(R.styleable.DropDownMenu_ddmenuBackgroundColor, menuBackgroundColor);
        this.maskColor = a.getColor(R.styleable.DropDownMenu_ddmaskColor, this.maskColor);
        this.menuTextSize = a.getDimensionPixelSize(R.styleable.DropDownMenu_ddmenuTextSize, this.menuTextSize);
        this.menuSelectedIcon = a.getResourceId(R.styleable.DropDownMenu_ddmenuSelectedIcon, this.menuSelectedIcon);
        this.menuUnselectedIcon = a.getResourceId(R.styleable.DropDownMenu_ddmenuUnselectedIcon, this.menuUnselectedIcon);
        this.menuHeighPercent = a.getFloat(R.styleable.DropDownMenu_ddmenuMenuHeightPercent, this.menuHeighPercent);
        a.recycle();
        this.tabMenuView = new LinearLayout(context);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        this.tabMenuView.setOrientation(0);
        this.tabMenuView.setBackgroundColor(menuBackgroundColor);
        this.tabMenuView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.addView((View)this.tabMenuView, 0);
        View underLine = new View(this.getContext());
        underLine.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, this.dpTpPx(1.0f)));
        underLine.setBackgroundColor(underlineColor);
        this.addView(underLine, 1);
        this.containerView = new FrameLayout(context);
        this.containerView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.addView((View)this.containerView, 2);
    }

    public void setDropDownMenu(@NonNull List<String> tabTexts, @NonNull List<View> popupViews, @NonNull View contentView) {
        int i;
        if (tabTexts.size() != popupViews.size()) {
            throw new IllegalArgumentException("params not match, tabTexts.size() should be equal popupViews.size()");
        }
        for (i = 0; i < tabTexts.size(); ++i) {
            this.addTab(tabTexts, i);
        }
        this.containerView.addView(contentView, 0);
        this.maskView = new View(this.getContext());
        this.maskView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.maskView.setBackgroundColor(this.maskColor);
        this.maskView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DropDownMenu.this.closeMenu();
            }
        });
        this.containerView.addView(this.maskView, 1);
        this.maskView.setVisibility(8);
        if (this.containerView.getChildAt(2) != null) {
            this.containerView.removeViewAt(2);
        }
        this.popupMenuViews = new FrameLayout(this.getContext());
        this.popupMenuViews.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, (int)((float)DeviceUtils.getScreenSize((Context)this.getContext()).y * this.menuHeighPercent)));
        this.popupMenuViews.setVisibility(8);
        this.containerView.addView((View)this.popupMenuViews, 2);
        for (i = 0; i < popupViews.size(); ++i) {
            popupViews.get(i).setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
            this.popupMenuViews.addView(popupViews.get(i), i);
        }
    }

    private void addTab(@NonNull List<String> tabTexts, int i) {
        final TextView tab = new TextView(this.getContext());
        tab.setSingleLine();
        tab.setEllipsize(TextUtils.TruncateAt.END);
        tab.setGravity(17);
        tab.setTextSize(0, (float)this.menuTextSize);
        tab.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -2, 1.0f));
        tab.setTextColor(this.textUnselectedColor);
        tab.setCompoundDrawablesWithIntrinsicBounds(null, null, this.getResources().getDrawable(this.menuUnselectedIcon), null);
        tab.setText((CharSequence)tabTexts.get(i));
        tab.setPadding(this.dpTpPx(5.0f), this.dpTpPx(12.0f), this.dpTpPx(5.0f), this.dpTpPx(12.0f));
        tab.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DropDownMenu.this.switchMenu((View)tab);
            }
        });
        this.tabMenuView.addView((View)tab);
        if (i < tabTexts.size() - 1) {
            View view = new View(this.getContext());
            view.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(this.dpTpPx(0.5f), -1));
            view.setBackgroundColor(this.dividerColor);
            this.tabMenuView.addView(view);
        }
    }

    public void setTabText(String text) {
        if (this.current_tab_position != -1) {
            ((TextView)this.tabMenuView.getChildAt(this.current_tab_position)).setText((CharSequence)text);
        }
    }

    public void setTabClickable(boolean clickable) {
        for (int i = 0; i < this.tabMenuView.getChildCount(); i += 2) {
            this.tabMenuView.getChildAt(i).setClickable(clickable);
        }
    }

    public void closeMenu() {
        if (this.current_tab_position != -1) {
            ((TextView)this.tabMenuView.getChildAt(this.current_tab_position)).setTextColor(this.textUnselectedColor);
            ((TextView)this.tabMenuView.getChildAt(this.current_tab_position)).setCompoundDrawablesWithIntrinsicBounds(null, null, this.getResources().getDrawable(this.menuUnselectedIcon), null);
            this.popupMenuViews.setVisibility(8);
            this.popupMenuViews.setAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.dd_menu_out));
            this.maskView.setVisibility(8);
            this.maskView.setAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.dd_mask_out));
            this.current_tab_position = -1;
        }
    }

    public boolean isShowing() {
        return this.current_tab_position != -1;
    }

    private void switchMenu(View target) {
        System.out.println(this.current_tab_position);
        for (int i = 0; i < this.tabMenuView.getChildCount(); i += 2) {
            if (target == this.tabMenuView.getChildAt(i)) {
                if (this.current_tab_position == i) {
                    this.closeMenu();
                    continue;
                }
                if (this.current_tab_position == -1) {
                    this.popupMenuViews.setVisibility(0);
                    this.popupMenuViews.setAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.dd_menu_in));
                    this.maskView.setVisibility(0);
                    this.maskView.setAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.dd_mask_in));
                    this.popupMenuViews.getChildAt(i / 2).setVisibility(0);
                } else {
                    this.popupMenuViews.getChildAt(i / 2).setVisibility(0);
                }
                this.current_tab_position = i;
                ((TextView)this.tabMenuView.getChildAt(i)).setTextColor(this.textSelectedColor);
                ((TextView)this.tabMenuView.getChildAt(i)).setCompoundDrawablesWithIntrinsicBounds(null, null, this.getResources().getDrawable(this.menuSelectedIcon), null);
                continue;
            }
            ((TextView)this.tabMenuView.getChildAt(i)).setTextColor(this.textUnselectedColor);
            ((TextView)this.tabMenuView.getChildAt(i)).setCompoundDrawablesWithIntrinsicBounds(null, null, this.getResources().getDrawable(this.menuUnselectedIcon), null);
            this.popupMenuViews.getChildAt(i / 2).setVisibility(8);
        }
    }

    public int dpTpPx(float value) {
        DisplayMetrics dm = this.getResources().getDisplayMetrics();
        return (int)((double)TypedValue.applyDimension((int)1, (float)value, (DisplayMetrics)dm) + 0.5);
    }
}

