/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.app.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import com.komect.network.R;

public class VerticalScrollView
extends ScrollView {
    private LinearLayout contentLayout;
    private RelativeLayout heatmapLayout;
    private float mDownPosX = 0.0f;
    private float mDownPosY = 0.0f;

    public VerticalScrollView(Context context) {
        super(context);
    }

    public VerticalScrollView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public VerticalScrollView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public VerticalScrollView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        float x = ev.getX();
        float y = ev.getY();
        int action = ev.getAction();
        switch (action) {
            case 0: {
                this.mDownPosX = x;
                this.mDownPosY = y;
                break;
            }
            case 2: {
                ev.getRawY();
                float deltaX = Math.abs(x - this.mDownPosX);
                float deltaY = Math.abs(y - this.mDownPosY);
                if (deltaX > deltaY) {
                    return false;
                }
                if (!(this.mDownPosY < 1550.0f)) break;
                return false;
            }
        }
        return super.onInterceptTouchEvent(ev);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.heatmapLayout = (RelativeLayout)this.findViewById(R.id.ly_heat_map);
        this.contentLayout = (LinearLayout)this.findViewById(R.id.ly_content);
    }
}

