/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.app.widget;

import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.komect.network.R;
import com.komect.network.bean.StepEntity;

public class StepView
extends LinearLayout
implements View.OnClickListener {
    public static final int STEP_UNDO = -1;
    public static final int STEP_CURRENT = 1;
    public static final int STEP_COMPLETED = 2;
    public static final int STEP_NORMAL = 0;
    private ImageView preInstallImg;
    private TextView preInstallTxt;
    private TextView preInstallStep;
    private ImageView proDesignImg;
    private TextView proDesignTxt;
    private TextView proDesignStep;
    private ImageView postInstallImg;
    private TextView postInstallTxt;
    private TextView postInstallStep;
    private int currentIndex;
    private OnItemClickListener listener;

    public StepView(Context context) {
        super(context);
        this.init();
    }

    public StepView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public StepView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        View rootView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_step_indicator, (ViewGroup)this);
        this.preInstallImg = (ImageView)rootView.findViewById(R.id.img_pre_install);
        this.preInstallTxt = (TextView)rootView.findViewById(R.id.txt_pre_install);
        this.preInstallStep = (TextView)rootView.findViewById(R.id.step_one);
        this.preInstallStep.setOnClickListener((View.OnClickListener)this);
        this.proDesignImg = (ImageView)rootView.findViewById(R.id.img_project_design);
        this.proDesignTxt = (TextView)rootView.findViewById(R.id.txt_project_design);
        this.proDesignStep = (TextView)rootView.findViewById(R.id.step_two);
        this.proDesignStep.setOnClickListener((View.OnClickListener)this);
        this.postInstallImg = (ImageView)rootView.findViewById(R.id.img_post_install);
        this.postInstallTxt = (TextView)rootView.findViewById(R.id.txt_post_install);
        this.postInstallStep = (TextView)rootView.findViewById(R.id.step_three);
        this.postInstallStep.setOnClickListener((View.OnClickListener)this);
    }

    public StepView setOnItemClickListener(OnItemClickListener listener) {
        this.listener = listener;
        return this;
    }

    public StepView setCurrentIndex(int currentIndex) {
        this.currentIndex = currentIndex;
        return this;
    }

    public StepView setStepEntity(StepEntity stepEntity) {
        this.updateStatus(1, stepEntity.getStepOne());
        this.updateStatus(2, stepEntity.getStepTwo());
        this.updateStatus(3, stepEntity.getStepThree());
        return this;
    }

    private void updateStatus(int step, int status) {
        switch (step) {
            case 1: {
                this.updateStepOneStatus(status);
                break;
            }
            case 2: {
                this.updateStepTwoStatus(status);
                break;
            }
            case 3: {
                this.updateStepThreeStatus(status);
                break;
            }
        }
    }

    private void updateStepOneStatus(int status) {
        switch (status) {
            case 2: {
                this.preInstallTxt.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.nw_btnBlue));
                this.preInstallStep.setBackground(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.circle_blue_background));
                this.preInstallImg.setImageDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.icon_tick));
                break;
            }
            case 1: {
                this.preInstallTxt.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.nw_btnBlue));
                this.preInstallStep.setBackground(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.circle_blue_background));
                this.preInstallImg.setImageDrawable(null);
                break;
            }
            case -1: {
                this.preInstallTxt.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.nw_btnBlue));
                this.preInstallStep.setBackground(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.circle_blue_background));
                this.preInstallImg.setImageDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.icon_undone));
                break;
            }
            case 0: {
                this.preInstallTxt.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.nw_txtColorGrey));
                this.preInstallStep.setBackground(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.circle_gray_background));
                this.preInstallImg.setImageDrawable(null);
                break;
            }
        }
    }

    private void updateStepTwoStatus(int status) {
        switch (status) {
            case 2: {
                this.proDesignTxt.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.nw_btnBlue));
                this.proDesignStep.setBackground(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.circle_blue_background));
                this.proDesignImg.setImageDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.icon_tick));
                break;
            }
            case 1: {
                this.proDesignTxt.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.nw_btnBlue));
                this.proDesignStep.setBackground(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.circle_blue_background));
                this.proDesignImg.setImageDrawable(null);
                break;
            }
            case -1: {
                this.proDesignTxt.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.nw_btnBlue));
                this.proDesignStep.setBackground(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.circle_blue_background));
                this.proDesignImg.setImageDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.icon_undone));
                break;
            }
            case 0: {
                this.proDesignTxt.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.nw_txtColorGrey));
                this.proDesignStep.setBackground(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.circle_gray_background));
                this.proDesignImg.setImageDrawable(null);
                break;
            }
        }
    }

    private void updateStepThreeStatus(int status) {
        switch (status) {
            case 2: {
                this.postInstallTxt.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.nw_btnBlue));
                this.postInstallStep.setBackground(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.circle_blue_background));
                this.postInstallImg.setImageDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.icon_tick));
                break;
            }
            case 1: {
                this.postInstallTxt.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.nw_btnBlue));
                this.postInstallStep.setBackground(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.circle_blue_background));
                this.postInstallImg.setImageDrawable(null);
                break;
            }
            case -1: {
                this.postInstallTxt.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.nw_btnBlue));
                this.postInstallStep.setBackground(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.circle_blue_background));
                this.postInstallImg.setImageDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.icon_undone));
                break;
            }
            case 0: {
                this.postInstallTxt.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.nw_txtColorGrey));
                this.postInstallStep.setBackground(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.circle_gray_background));
                this.postInstallImg.setImageDrawable(null);
                break;
            }
        }
    }

    public void onClick(View view) {
        if (this.listener == null) {
            return;
        }
        int i = view.getId();
        if (i == R.id.step_one) {
            if (this.currentIndex != 1) {
                this.listener.onItemClick(view, 1);
            }
        } else if (i == R.id.step_two) {
            if (this.currentIndex != 2) {
                this.listener.onItemClick(view, 2);
            }
        } else if (i == R.id.step_three && this.currentIndex != 3) {
            this.listener.onItemClick(view, 3);
        }
    }

    public static interface OnItemClickListener {
        public void onItemClick(View var1, int var2);
    }
}

