/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.app.widget;

import android.content.Context;
import android.databinding.DataBindingUtil;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import com.komect.network.R;
import com.komect.network.app.adapter.NetworkDeviceAdapter;
import com.komect.network.app.adapter.TestPointAdapter;
import com.komect.network.app.widget.Marker;
import com.komect.network.bean.NetworkDevice;
import com.komect.network.bean.TestPoint;
import com.komect.network.databinding.LayoutNwReportBinding;
import com.komect.network.databinding.ReportConfig;
import com.komect.network.utils.MarkerUtil;
import com.zhy.autolayout.utils.AutoUtils;
import java.util.Collection;
import java.util.List;

public class ReportView
extends LinearLayout {
    private LayoutNwReportBinding binding;
    private NetworkDeviceAdapter mDeviceAdapter;
    private TestPointAdapter mPointAdapter;
    private Context context;

    public ReportView(Context context) {
        super(context);
        this.initContent(context);
    }

    public ReportView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initContent(context);
    }

    public ReportView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initContent(context);
    }

    private void initContent(Context context) {
        this.context = context;
        this.binding = (LayoutNwReportBinding)DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)context), (int)R.layout.layout_nw_report, (ViewGroup)this, (boolean)false);
        this.addView(this.binding.getRoot());
        AutoUtils.autoSize((View)this.binding.getRoot());
    }

    public void setConfig(ReportConfig config) {
        this.handleDeviceList(config.getDevices(), config.isHasFamily(), config.isNoShowDeviceTable());
        this.handleTpList(config.getTestPoints(), config.isHasFamily());
        this.binding.setConfig(config);
        this.binding.executePendingBindings();
    }

    private void handleDeviceList(List<NetworkDevice> list, boolean hasFamily, boolean noShowDeviceTable) {
        if (list != null && list.size() > 0) {
            if (!noShowDeviceTable) {
                this.binding.lyDeviceForm.setVisibility(0);
                this.mDeviceAdapter = new NetworkDeviceAdapter();
                this.binding.deviceListView.setAdapter((ListAdapter)this.mDeviceAdapter);
                this.mDeviceAdapter.setData((Collection<NetworkDevice>)list);
            }
            if (hasFamily) {
                for (NetworkDevice device : list) {
                    this.addDeviceMarker(device);
                }
            }
        } else {
            this.binding.lyDeviceForm.setVisibility(8);
        }
    }

    private void handleTpList(List<TestPoint> list, boolean hasFamily) {
        if (list != null) {
            this.binding.lyTpForm.setVisibility(0);
            this.mPointAdapter = new TestPointAdapter();
            this.binding.testListView.setAdapter((ListAdapter)this.mPointAdapter);
            if (list.size() > 0) {
                this.mPointAdapter.setData((Collection<TestPoint>)list);
                if (hasFamily) {
                    for (TestPoint point : list) {
                        this.addTpMarker(point);
                    }
                }
            }
        } else {
            this.binding.lyTpForm.setVisibility(8);
        }
    }

    private void addDeviceMarker(NetworkDevice device) {
        float x = device.getX();
        float y = device.getY();
        if (device.getDeviceType() != null) {
            Marker marker = MarkerUtil.getMaker(this.context, MarkerUtil.getResIdByDeviceType(device.getDeviceType()));
            marker.setMarkerType(2);
            marker.setIndex(Integer.parseInt(device.getSequence()));
            marker.setObject(device);
            this.binding.lyHeatMap.setPosition(marker, x, y);
        }
    }

    private void addTpMarker(TestPoint tp) {
        float x = tp.getX();
        float y = tp.getY();
        Marker marker = MarkerUtil.getMaker(this.context, R.drawable.test_marker);
        marker.setMarkerType(1);
        marker.setIndex(Integer.parseInt(tp.getSequence()));
        marker.setObject(tp);
        this.binding.lyHeatMap.setPosition(marker, x, y);
    }
}

