/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.app.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.AbsListView;
import android.widget.ListView;
import com.komect.network.R;

public class LoadMoreListView
extends ListView
implements AbsListView.OnScrollListener {
    private static final String TAG = "RefreshListView";
    private boolean isScrollToBottom;
    private View footerView;
    private int footerViewHeight;
    private boolean isLoadingMore = false;
    private OnRefreshListener mOnRefreshListener;

    public LoadMoreListView(Context context) {
        super(context);
    }

    public LoadMoreListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initFooterView();
        this.setOnScrollListener(this);
    }

    private void initFooterView() {
        this.footerView = View.inflate((Context)this.getContext(), (int)R.layout.footer_layout, null);
        this.footerView.measure(0, 0);
        this.footerViewHeight = this.footerView.getMeasuredHeight();
        this.footerView.setPadding(0, -this.footerViewHeight, 0, 0);
        this.addFooterView(this.footerView);
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
        if ((scrollState == 0 || scrollState == 2) && this.isScrollToBottom && !this.isLoadingMore) {
            this.isLoadingMore = true;
            this.footerView.setPadding(0, 0, 0, 0);
            this.setSelection(this.getCount());
            if (this.mOnRefreshListener != null) {
                this.mOnRefreshListener.onLoadingMore();
            }
        }
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        this.isScrollToBottom = this.getLastVisiblePosition() == totalItemCount - 1;
    }

    public void setOnRefreshListener(OnRefreshListener listener) {
        this.mOnRefreshListener = listener;
    }

    public void loadMoreComplete() {
        this.footerView.setPadding(0, -this.footerViewHeight, 0, 0);
        this.isLoadingMore = false;
    }

    public static interface OnRefreshListener {
        public void onLoadingMore();
    }
}

