/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.app.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.komect.network.R;
import com.komect.network.app.widget.Marker;
import java.util.ArrayList;

public class DragRelativeLayout
extends RelativeLayout
implements View.OnTouchListener {
    private int markerIndex;
    private int screenWidth;
    private boolean isIntercept = false;
    private int startDownX;
    private int startDownY;
    private int lastMoveX;
    private int lastMoveY;
    private ImageView heatImage;

    public DragRelativeLayout(Context context) {
        super(context);
        this.init();
    }

    public DragRelativeLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public DragRelativeLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        DisplayMetrics dm = this.getResources().getDisplayMetrics();
        this.screenWidth = dm.widthPixels;
    }

    public void addMarker(Marker marker) {
        ++this.markerIndex;
        marker.setText(String.valueOf(marker.getIndex()));
        marker.setOnTouchListener(this);
        this.addView((View)marker, this.markerIndex);
    }

    public void setPosition(Marker v, float x, float y) {
        ++this.markerIndex;
        v.setText(String.valueOf(v.getIndex()));
        this.addView((View)v, this.markerIndex);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.leftMargin = (int)x;
        params.topMargin = (int)y;
        params.setMargins((int)x, (int)y, 0, 0);
        v.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    public ArrayList<Marker> getChilds() {
        ArrayList<Marker> list = new ArrayList<Marker>();
        for (int i = 1; i < this.getChildCount(); ++i) {
            Marker marker = (Marker)this.getChildAt(i);
            list.add(marker);
        }
        return list;
    }

    public void removeMarkers() {
        if (this.getChildCount() > 1) {
            this.removeViews(1, this.getChildCount() - 1);
            this.markerIndex = 0;
        }
    }

    public void removeMarkers(int start) {
        if (start < this.getChildCount() - 1) {
            this.removeViews(start + 1, this.getChildCount() - start - 1);
            this.markerIndex = this.getChildCount() - 1;
        }
    }

    public boolean onTouch(View v, MotionEvent event) {
        int action = event.getAction();
        switch (action) {
            case 0: {
                this.startDownX = this.lastMoveX = (int)event.getRawX();
                this.startDownY = this.lastMoveY = (int)event.getRawY();
                break;
            }
            case 2: {
                int dx = (int)event.getRawX() - this.lastMoveX;
                int dy = (int)event.getRawY() - this.lastMoveY;
                int left = v.getLeft() + dx;
                int top = v.getTop() + dy;
                int right = v.getRight() + dx;
                int bottom = v.getBottom() + dy;
                if (left < 0) {
                    left = 0;
                    right = left + v.getWidth();
                }
                if (right > this.screenWidth) {
                    right = this.screenWidth;
                    left = right - v.getWidth();
                }
                if (top < 0) {
                    top = 0;
                    bottom = top + v.getHeight();
                }
                if (bottom > this.getHeight()) {
                    bottom = this.getHeight();
                    top = bottom - v.getHeight();
                }
                v.layout(left, top, right, bottom);
                this.lastMoveX = (int)event.getRawX();
                this.lastMoveY = (int)event.getRawY();
                break;
            }
            case 1: {
                int lastMoveDx = Math.abs((int)event.getRawX() - this.startDownX);
                int lastMoveDy = Math.abs((int)event.getRawY() - this.startDownY);
                this.isIntercept = 0 != lastMoveDx || 0 != lastMoveDy;
                RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
                params.leftMargin = v.getLeft();
                params.topMargin = v.getTop();
                params.setMargins(v.getLeft(), v.getTop(), 0, 0);
                v.setLayoutParams((ViewGroup.LayoutParams)params);
            }
        }
        return this.isIntercept;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.heatImage = (ImageView)this.findViewById(R.id.img_heat_map);
    }
}

