/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.app.fragment;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.databinding.DataBindingUtil;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ListAdapter;
import android.widget.Toast;
import com.komect.network.R;
import com.komect.network.app.activity.DeviceAddActivity;
import com.komect.network.app.activity.PostInstallActivity;
import com.komect.network.app.adapter.NetworkDeviceAdapter;
import com.komect.network.app.fragment.BaseFragment;
import com.komect.network.app.widget.StepView;
import com.komect.network.bean.NetworkDevice;
import com.komect.network.bean.StepEntity;
import com.komect.network.database.DbManager;
import com.komect.network.database.OrderEntity;
import com.komect.network.databinding.FragmentSimpProjectDesignBinding;
import com.komect.network.databinding.ReportConfig;
import com.komect.network.komectinnet.event.BaseEvent;
import com.komect.network.litepal.crud.DataSupport;
import com.komect.network.utils.SimpleCacheUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.greenrobot.eventbus.Subscribe;

public class SimpProjectDesignFragment
extends BaseFragment
implements StepView.OnItemClickListener {
    public static final String INTENT_ADD_DEVICE = "network_device";
    public static final int REQUEST_ADD_DEVICE = 1;
    private FragmentSimpProjectDesignBinding binding;
    private NetworkDeviceAdapter mDeviceAdapter;
    private ArrayList<NetworkDevice> deviceList = new ArrayList();
    private boolean isFirstAddDevice = true;
    private boolean isConfirmedPlan;
    private DbManager dbManager;
    private OrderEntity orderEntity;
    @Inject
    SimpleCacheUtil cacheUtil;
    @Inject
    StepEntity stepEntity;

    public static SimpProjectDesignFragment newInstance() {
        return new SimpProjectDesignFragment();
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getAppComponent().inject(this);
        this.dbManager = DbManager.getManager();
        if (this.stepEntity.getStepTwo() == 0) {
            this.stepEntity.setStepTwo(1);
        }
        this.initData();
    }

    private void initData() {
        this.orderEntity = DataSupport.findLast(OrderEntity.class);
        List<NetworkDevice> devices = this.dbManager.getDeviceList(2);
        if (!devices.isEmpty()) {
            this.deviceList = (ArrayList)devices;
        }
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.binding = (FragmentSimpProjectDesignBinding)DataBindingUtil.inflate((LayoutInflater)inflater, (int)R.layout.fragment_simp_project_design, (ViewGroup)container, (boolean)false);
        this.binding.setFrag(this);
        this.binding.setOrder(this.orderEntity);
        if (!this.deviceList.isEmpty()) {
            this.showCompletedView(true);
        }
        this.mDeviceAdapter = new NetworkDeviceAdapter();
        this.binding.deviceListView.setAdapter((ListAdapter)this.mDeviceAdapter);
        this.mDeviceAdapter.setData((Collection<NetworkDevice>)this.deviceList);
        return this.binding.getRoot();
    }

    @Override
    public void onResume() {
        super.onResume();
        this.initStepView();
    }

    private void initStepView() {
        this.binding.stepView.setCurrentIndex(2).setStepEntity(this.stepEntity).setOnItemClickListener(this);
    }

    private void updateStepState(int step, int status) {
        switch (step) {
            case 2: {
                this.binding.stepView.setStepEntity(this.stepEntity.setStepTwo(status));
                break;
            }
            case 3: {
                this.binding.stepView.setStepEntity(this.stepEntity.setStepThree(status));
                break;
            }
        }
    }

    private void resetView() {
        this.deviceList.clear();
        this.isFirstAddDevice = true;
        this.mDeviceAdapter.setData((Collection<NetworkDevice>)this.deviceList);
    }

    public void showAddDeviceView(View view) {
        if (this.mDeviceAdapter.getCount() < 12) {
            Bundle bundle = new Bundle();
            bundle.putBoolean("is_network_design", true);
            Intent intent = new Intent((Context)this.getActivity(), DeviceAddActivity.class);
            intent.putExtra("bundle", bundle);
            this.startActivityForResult(intent, 1);
        } else {
            Toast.makeText((Context)this.getActivity(), (int)R.string.unable_add_more_devices, (int)0).show();
        }
    }

    public void reviews(View view) {
        if (this.deviceList.isEmpty() || this.deviceList.size() == 1 && this.deviceList.get(0).getDeviceName().equals("-")) {
            Toast.makeText((Context)this.getActivity(), (int)R.string.nw_please_add_device, (int)0).show();
            return;
        }
        this.updateStepState(2, 2);
        this.showCompletedView(true);
        this.saveProjectDesignData();
    }

    private void showCompletedView(boolean isShow) {
        this.isConfirmedPlan = isShow;
        this.showUserInfo(isShow);
        this.showOrderInfo(isShow);
        if (isShow) {
            this.binding.btnStartTest.setVisibility(8);
            this.binding.btnRetest.setVisibility(0);
            this.binding.lyActionButton.setVisibility(8);
            this.binding.lyCmpActionButton.setVisibility(0);
        } else {
            this.binding.btnStartTest.setVisibility(0);
            this.binding.btnRetest.setVisibility(8);
            this.binding.lyActionButton.setVisibility(0);
            this.binding.lyCmpActionButton.setVisibility(8);
        }
    }

    public void onRedesign(View view) {
        this.updateStepState(2, 1);
        if (this.stepEntity.getStepThree() != 0) {
            this.updateStepState(3, 0);
        }
        this.showCompletedView(false);
        this.dbManager.deleteAll(2);
        this.dbManager.deleteAll(3);
        this.cacheUtil.remove("cache_config_design");
    }

    private void showUserInfo(boolean isShow) {
        if (isShow) {
            this.binding.includeUserInfo.lyUserInfo.setVisibility(0);
            return;
        }
        this.binding.includeUserInfo.lyUserInfo.setVisibility(8);
    }

    private void showOrderInfo(boolean isShow) {
        if (isShow) {
            this.binding.lyOrderInfo.setVisibility(0);
            return;
        }
        this.binding.lyOrderInfo.setVisibility(8);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        this.getActivity();
        if (resultCode == -1 && requestCode == 1) {
            NetworkDevice device = (NetworkDevice)data.getParcelableExtra(INTENT_ADD_DEVICE);
            if (this.isFirstAddDevice) {
                this.isFirstAddDevice = false;
                this.deviceList.clear();
            }
            this.deviceList.add(device);
            this.mDeviceAdapter.setData((Collection<NetworkDevice>)this.deviceList);
        }
    }

    public void onNextStep() {
        final Intent intent = new Intent((Context)this.getActivity(), PostInstallActivity.class);
        if (this.isConfirmedPlan) {
            this.getActivity().startActivity(intent);
        } else {
            this.showAlertDialog(null, this.getString(R.string.unconfirmed_skip_step), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int i) {
                    SimpProjectDesignFragment.this.getActivity().startActivity(intent);
                }
            });
        }
    }

    private void saveProjectDesignData() {
        for (NetworkDevice device : this.deviceList) {
            this.dbManager.saveDevice(device, 2);
        }
        ReportConfig config = new ReportConfig().setTitle(this.getString(R.string.intelligent_networking_scheme)).setMapTitle(this.getString(R.string.nw_network_design)).setDevices(this.deviceList).setHasFamily(false);
        this.cacheUtil.put("cache_config_design", config);
    }

    @Override
    public void onItemClick(View view, int position) {
        if (!this.isConfirmedPlan) {
            this.updateStepState(2, -1);
        }
        if (position == 3) {
            this.onNextStep();
        } else {
            this.getActivity().onBackPressed();
        }
    }

    @Override
    @Subscribe
    public void onDispatchEvent(BaseEvent event) {
    }
}

