/*
 * Decompiled with CFR 0.152.
 */
package com.komect.network.app.fragment;

import android.content.Context;
import android.databinding.DataBindingUtil;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.widget.SwipeRefreshLayout;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.Toast;
import com.komect.network.R;
import com.komect.network.app.activity.ReportActivity;
import com.komect.network.app.adapter.NetworkRecordAdapter;
import com.komect.network.app.fragment.BaseFragment;
import com.komect.network.app.widget.LoadMoreListView;
import com.komect.network.bean.SearchProfile;
import com.komect.network.database.DbManager;
import com.komect.network.database.OrderEntity;
import com.komect.network.databinding.FragmentRecordListBinding;
import com.komect.network.event.ActivityStartEvent;
import com.komect.network.typeenum.ListTypeEnum;
import java.io.Serializable;
import java.util.List;
import javax.inject.Inject;

public class QueryRecordListFragment
extends BaseFragment
implements AdapterView.OnItemClickListener,
SwipeRefreshLayout.OnRefreshListener,
LoadMoreListView.OnRefreshListener {
    @Inject
    SearchProfile searchProfile;
    private FragmentRecordListBinding binding;
    private NetworkRecordAdapter adapter;
    private DbManager dbManager;
    private List<OrderEntity> totalList;
    private int pageOffset;
    private static final int PAGE_SIZE = 20;

    @Override
    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.getAppComponent().inject(this);
        this.binding = (FragmentRecordListBinding)DataBindingUtil.inflate((LayoutInflater)inflater, (int)R.layout.fragment_record_list, (ViewGroup)container, (boolean)false);
        this.adapter = new NetworkRecordAdapter();
        this.binding.searchList.setAdapter((ListAdapter)this.adapter);
        this.dbManager = DbManager.getManager();
        this.binding.swipeGoogleAndLoadmoreRefreshLayout.setOnRefreshListener((SwipeRefreshLayout.OnRefreshListener)this);
        this.binding.searchList.setOnRefreshListener(this);
        this.binding.searchList.setOnItemClickListener(this);
        return this.binding.getRoot();
    }

    @Override
    public void onHiddenChanged(boolean hidden) {
        if (!hidden) {
            this.firstLoadList();
        }
    }

    public void firstLoadList() {
        this.totalList = this.dbManager.getOrderEntityByKeyword((String)this.searchProfile.keyWord.get());
        this.showList(ListTypeEnum.FirstLoad);
    }

    public void onRefresh() {
        this.showList(ListTypeEnum.Refresh);
    }

    public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
        Bundle bundle = new Bundle();
        bundle.putSerializable("order_entity", (Serializable)this.adapter.getData().get(i));
        new ActivityStartEvent().setTargetActivityCls(ReportActivity.class).setBundle(bundle).send();
    }

    @Override
    public void onLoadingMore() {
        this.showList(ListTypeEnum.LoadMore);
    }

    private void showList(ListTypeEnum listType) {
        switch (listType) {
            case FirstLoad: 
            case Refresh: {
                this.binding.swipeGoogleAndLoadmoreRefreshLayout.setRefreshing(true);
                this.pageOffset = 0;
                this.adapter.setData(this.totalList.subList(this.pageOffset, 20 < this.totalList.size() - this.pageOffset ? 20 : this.totalList.size() - this.pageOffset));
                this.pageOffset += 20;
                this.binding.swipeGoogleAndLoadmoreRefreshLayout.setRefreshing(false);
                break;
            }
            case LoadMore: {
                if (this.pageOffset <= this.totalList.size()) {
                    this.adapter.addData(this.totalList.subList(this.pageOffset, 20 < this.totalList.size() - this.pageOffset ? this.pageOffset + 20 : this.totalList.size()));
                    this.pageOffset += 20;
                    this.binding.searchList.loadMoreComplete();
                    break;
                }
                Toast.makeText((Context)this.getContext(), (CharSequence)"\u65e0\u66f4\u591a\u6570\u636e", (int)0).show();
                this.binding.searchList.loadMoreComplete();
                break;
            }
        }
    }
}

